Attribute VB_Name = "modSPL2VB"
Option Explicit

Public Const NSP_NO_SCALE As Long = 0
Public Const NSP_FIXED_SCALE As Long = 2
Public Const NSP_AUTO_SCALE As Long = 4
Public Const NSP_OVERFLOW As Long = 0
Public Const NSP_SATURATE As Long = 1
Public Const XBUFLEN = 31

Public Const NSP_Normal As Long = 0
Public Const NSP_Biased As Long = 1
Public Const NSP_UnBias As Long = 2

Public Const NSP_GT As Long = 1
Public Const NSP_LT As Long = 0


Public Const NSP_DCT_Forward As Long = 1
Public Const NSP_DCT_Inverse As Long = 2
Public Const NSP_DCT_Free As Long = 8

Public Const NSP_Forw As Long = 1
Public Const NSP_Inv As Long = 2
Public Const NSP_Init As Long = 4
Public Const NSP_Free As Long = 8
Public Const NSP_NoScale As Long = 16
Public Const NSP_NoBitRev As Long = 32
Public Const NSP_InBitRev As Long = 64
Public Const NSP_OutBitRev As Long = 128
Public Const NSP_OutRCPack As Long = 256
Public Const NSP_OutRCPerm As Long = 512
Public Const NSP_InRCPack As Long = 1024
Public Const NSP_InRCPerm As Long = 4096
Public Const NSP_DoIntCore As Long = 8192
Public Const NSP_DoFloatCore As Long = 16384
Public Const NSP_DoFastMMX As Long = 32768

Public Const NSP_LmsNull As Long = 0
Public Const NSP_LmsDefault As Long = 1
Public Const NSP_IirNull As Long = 0
Public Const NSP_IirDefault As Long = 1
Public Const NSP_IirInit As Long = 0
Public Const NSP_IirInitBq As Long = 1

Public wordSize As Long
Public Const NSP_Noflags As Long = 0
Public Const NSP_Round As Long = 128
Public Const NSP_TruncZero As Long = 256
Public Const NSP_TruncNeg As Long = 512
Public Const NSP_TruncPos As Long = 1024
Public Const NSP_Unsigned As Long = 2048
Public Const NSP_Clip As Long = 4096
Public Const NSP_OvfErr As Long = 8192
Public Const NSP_CVRT_MAXPHASE As Integer = 16383

Public Const NSP_C As Long = 1
Public Const NSP_L1 As Long = 2
Public Const NSP_L2 As Long = 4
Public Const NSP_RELATIVE As Long = 8


Public Const NSP_WtCoreFloat As Long = 1
Public Const NSP_WtCoreDouble As Long = 2
Public Const NSP_WtCoreShort As Long = 4

Public Const NSP_Haar As Long = 1
Public Const NSP_Daublet As Long = 2
Public Const NSP_Symmlet As Long = 3
Public Const NSP_Coiflet As Long = 4
Public Const NSP_Vaidyanathan As Long = 5
Public Const NSP_BSpline As Long = 6
Public Const NSP_BSpline_Dual As Long = 7
Public Const NSP_LinSpline As Long = 8
Public Const NSP_QuadSpline As Long = 9
Public Const NSP_WtByFilter As Long = 10

Public Const NSP_WtOrtType As Long = 1
Public Const NSP_WtBiOrtType As Long = 2
Public Const NSP_WtOrtUnknown As Long = 3

Public Enum NSP_WindowType
   NSP_WinRect = 0
   NSP_WinBartlett
   NSP_WinBlackmanOpt
   NSP_WinHamming
   NSP_WinHann
End Enum
    

Public Type SCplx
   re As Single
   im As Single
End Type

Public Type DCplx
   re As Double
   im As Double
End Type

Public Type WCplx
   re As Integer
   im As Integer
End Type

Public Type ICplx
   re As Long
   im As Long
End Type

Public Type NSPSToneState
   cosBase As Double
   cosCurr As Double
   cosPrev As Double
   mag As Single
   rFreq As Single
   phase As Single
   isInit As String * 4
   reserved(13) As Single
End Type

Public Type NSPCToneState
   cosBase As Double
   cosCurr As DCplx
   cosPrev As DCplx
   mag As Single
   rFreq As Single
   phase As Single
   isInit As String * 4
   reserved(9) As Single
End Type

Public Type NSPDToneState
   cosBase As Double
   cosCurr As Double
   cosPrev As Double
   mag As Double
   rFreq As Double
   phase As Double
   isInit As String * 4
End Type

Public Type NSPZToneState
   cosBase As Double
   cosCurr As DCplx
   cosPrev As DCplx
   mag As Double
   rFreq As Double
   phase As Double
   isInit As String * 4
End Type

Public Type NSPWToneState
    Dummy(31) As Double
End Type

Public Type NSPVToneState
    Dummy(31) As Double
End Type

Public Type NSPSTrnglState
    mag As Single
    Step As Single
    step1 As Single
    step2 As Single
    st12 As Single
    st21 As Single
    shft1 As Single
    shft2 As Single
    delta1 As Single
    delta2 As Single
    Last As Single
End Type

Public Type NSPCTrnglState
    mag As Single
    Step As SCplx
    step1 As Single
    step2 As Single
    st12 As Single
    st21 As Single
    shft1 As Single
    shft2 As Single
    delta1 As Single
    delta2 As Single
    Last As SCplx
End Type

Public Type NSPDTrnglState
    mag As Double
    Step As Double
    step1 As Double
    step2 As Double
    st12 As Double
    st21 As Double
    shft1 As Double
    shft2 As Double
    delta1 As Double
    delta2 As Double
    Last As Double
End Type

Public Type NSPZTrnglState
    mag As Double
    Step As DCplx
    step1 As Double
    step2 As Double
    st12 As Double
    st21 As Double
    shft1 As Double
    shft2 As Double
    delta1 As Double
    delta2 As Double
    Last As DCplx
End Type

Public Type NSPWTrnglState
    mag As Single
    Step As Single
    step1 As Single
    step2 As Single
    st12 As Single
    st21 As Single
    shft1 As Single
    shft2 As Single
    delta1 As Single
    delta2 As Single
    Last As Single
End Type

Public Type NSPVTrnglState
    mag As Single
    Step As SCplx
    step1 As Single
    step2 As Single
    st12 As Single
    st21 As Single
    shft1 As Single
    shft2 As Single
    delta1 As Single
    delta2 As Single
    Last As SCplx
End Type

Public Type NSPSRandUniState
    low As Single
    muler As Single
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPCRandUniState
    low As Single
    muler As Single
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPDRandUniState
    low As Double
    muler As Double
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPZRandUniState
    low As Double
    muler As Double
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPWRandUniState
    low As Single
    muler As Single
    center As Long
    pwr2 As Long
    m_seed(1) As Long
    d_seed(2) As Long
    carry As Long
    quickSeed As Long
    current As Long
    xbuf(XBUFLEN) As Integer
End Type

Public Type NSPVRandUniState
    low As Single
    muler As Single
    center As Long
    pwr2 As Long
    m_seed(1) As Long
    d_seed(2) As Long
    carry As Long
    quickSeed As Long
    current As Long
    xbuf(XBUFLEN) As Integer
End Type

Public Type NSPSRandGausState
    mean As Single
    stDev As Single
    extraValue As Single
    useExtra As Long
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPCRandGausState
    mean As Single
    stDev As Single
    extraValue As Single
    useExtra As Long
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPDRandGausState
    mean As Double
    stDev As Double
    extraValue As Double
    useExtra As Long
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPZRandGausState
    mean As Double
    stDev As Double
    extraValue As Double
    useExtra As Long
    seed2 As Long
    carry As Long
    seed1(2) As Long
    quickSeed As Long
End Type

Public Type NSPWRandGausState
    useExtra As Long
    seed2 As Long
    carry As Long
    seed1(2) As Long
    mean As Integer
    stDev As Integer
    extraValue As Integer
    quickSeed As Long
End Type

Public Type NSPVRandGausState
    useExtra As Long
    seed2 As Long
    carry As Long
    seed1(2) As Long
    mean As Integer
    stDev As Integer
    extraValue As Integer
    quickSeed As Long
End Type

Public Type NSPSGoertzState
    freq As Single
    cosV As Single
    sinV As Single
    cpcV As Single
    prev2re As Single
    prev2im As Single
    prev1re As Single
    prev1im As Single
End Type

Public Type NSPCGoertzState
    freq As Single
    cosV As Single
    sinV As Single
    cpcV As Single
    prev2re As Single
    prev2im As Single
    prev1re As Single
    prev1im As Single
End Type

Public Type NSPDGoertzState
    freq As Double
    cosV As Double
    sinV As Double
    cpcV As Double
    prev2re As Double
    prev2im As Double
    prev1re As Double
    prev1im As Double
End Type

Public Type NSPZGoertzState
    freq As Double
    cosV As Double
    sinV As Double
    cpcV As Double
    prev2re As Double
    prev2im As Double
    prev1re As Double
    prev1im As Double
End Type

Public Type NSPWGoertzState
    freq As Single
    cosV As Single
    sinV As Single
    cpcV As Single
    prev2re As Single
    prev2im As Single
    prev1re As Single
    prev1im As Single
End Type

Public Type NSPVGoertzState
    freq As Single
    cosV As Single
    sinV As Single
    cpcV As Single
    prev2re As Single
    prev2im As Single
    prev1re As Single
    prev1im As Single
End Type

Public Type FirLmsTapState
    taps As Long
    lenn As Long
    upFactor As Long
    upPhase As Long
    downFactor As Long
    downPhase As Long
    isMultiRate As Long
    isFilterMode As Long
End Type

Public Type FirLmsDlyState
    dlyl As Long
    lenn As Long
    isFilterMode As Long
End Type

Public Type NSPFirTapState
    FLTS As FirLmsTapState
    tapsFactor As Long
End Type

Public Type NSPFirDlyState
    FLDS As FirLmsDlyState
End Type

Public Type firSect
    num As Long
    lenn As Long
    xId As Long
    tId As Long
End Type

Public Type NSPFirState
    upFactor As Long
    upPhase As Long
    downFactor As Long
    downPhase As Long
    isMultiRate As Long
    isInit As Boolean
    tapsLen As Long
    tapsBlk As Long
    taps As Long
    dlylLen As Long
    inpLen As Long
    useInp As Long
    dlyl As Long
    dlylLimit As Long
    useDlyl As Long
    sect As firSect
    tapsFactor As Long
    utapsLen As Long
End Type

Public Type NSPLmsTapState
    FLTS As FirLmsTapState
    Leak As Single
    Step As Single
    errDly As Long
    type As Long
End Type

Public Type NSPLmsDlyState
    FLDS As FirLmsDlyState
    adaptB As Long
End Type

Public Type NSPWLmsTapState
    FLTS As FirLmsTapState
    Leak As Integer
    Step As Single
    errDly As Long
    type As Long
End Type

Public Type NSPWLmsDlyState
    FLDS As FirLmsDlyState
    adaptB As Long
End Type

Public Type NSPLmsState
    tapState As NSPLmsTapState
    dlyState As NSPLmsDlyState
    zVal As DCplx
End Type

Public Type NSPIirTapState
    order As Long
    taps As Long
    iirType As Long
    initype As Long
End Type

Public Type NSPIirDlyState
    dlyl As Long
End Type

Public Type NSPIirState
    tapSt As NSPIirTapState
    dlySt As NSPIirDlyState
    init As Long
End Type

Public Type NSPWtState
    wtCore       As Long
    wtType       As Long
    wtOrtType    As Long
    par1         As Long
    par2         As Long
    dataOrder    As Long
    level        As Long
    len_filt(3)  As Long
    ofs_filt(3)  As Long
    tap_filt(3)  As Long
    src_pad      As Long
    len_dec      As Long
    tree(32)     As Long
End Type

Public Type NSPLibVersion
    major As Long
    minor As Long
    build As Long
    Namee As String * 32
    Versionn As String * 32
    InternalVersionn As String * 32
    BuildDate As String * 32
    CallConv As String * 32
End Type




'CHAPTER 3.
'Arithmetic and Vector Manipulation Functions.
'___________________________________________________________________________________

'Set
Declare Function nspcSet Lib "nsp.dll" (ByVal re As Single, ByVal im As Single) _
    As SCplx
Declare Function nspzSet Lib "nsp.dll" (ByVal re As Double, ByVal im As Double) _
    As DCplx
Declare Function nspvSet Lib "nsp.dll" (ByVal re As Integer, ByVal im As Integer) _
    As WCplx
'Add
Declare Function nspcAddP Lib "nsp.dll" Alias "nspcAdd" _
    (ByVal CompAre As Single, ByVal CompAim As Single, ByVal CompBre As Single, _
    ByVal CompBim As Single) As SCplx
Declare Function nspzAddP Lib "nsp.dll" Alias "nspzAdd" _
    (ByVal CompAre As Double, ByVal CompAim As Double, ByVal CompBre As Double, _
    ByVal CompBim As Double) As DCplx
Declare Function nspvAddP Lib "nsp.dll" Alias "nspvAdd" _
    (ByVal CompAre As Integer, ByVal CompAim As Integer, ByVal CompBre As Integer, _
    ByVal CompBim As Integer, ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
'Conj
Declare Function nspcConjP Lib "nsp.dll" Alias "nspcConj" _
    (ByVal CompAre As Single, ByVal CompAim As Single) As SCplx
Declare Function nspzConjP Lib "nsp.dll" Alias "nspzConj" _
    (ByVal CompAre As Double, ByVal CompAim As Double) As DCplx
Declare Function nspvConjP Lib "nsp.dll" Alias "nspvConj" _
    (ByVal CompAre As Integer, ByVal CompAim As Integer) As WCplx
'Div
Declare Function nspcDivP Lib "nsp.dll" Alias "nspcDiv" _
    (ByVal CompAre As Single, ByVal CompAim As Single, ByVal CompBre As Single, _
    ByVal CompBim As Single) As SCplx
Declare Function nspzDivP Lib "nsp.dll" Alias "nspzDiv" _
    (ByVal CompAre As Double, ByVal CompAim As Double, ByVal CompBre As Double, _
    ByVal CompBim As Double) As DCplx
Declare Function nspvDivP Lib "nsp.dll" Alias "nspvDiv" _
    (ByVal CompAre As Integer, ByVal CompAim As Integer, ByVal CompBre As Integer, _
    ByVal CompBim As Integer) As WCplx
'Div
Declare Function nspcMpyP Lib "nsp.dll" Alias "nspcMpy" _
    (ByVal CompAre As Single, ByVal CompAim As Single, ByVal CompBre As Single, _
    ByVal CompBim As Single) As SCplx
Declare Function nspzMpyP Lib "nsp.dll" Alias "nspzMpy" _
    (ByVal CompAre As Double, ByVal CompAim As Double, ByVal CompBre As Double, _
    ByVal CompBim As Double) As DCplx
Declare Function nspvMpyP Lib "nsp.dll" Alias "nspvMpy" _
    (ByVal CompAre As Integer, ByVal CompAim As Integer, ByVal CompBre As Integer, _
    ByVal CompBim As Integer, ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
'Mpy
Declare Function nspcSubP Lib "nsp.dll" Alias "nspcSub" _
    (ByVal CompAre As Single, ByVal CompAim As Single, ByVal CompBre As Single, _
    ByVal CompBim As Single) As SCplx
Declare Function nspzSubP Lib "nsp.dll" Alias "nspzSub" _
    (ByVal CompAre As Double, ByVal CompAim As Double, ByVal CompBre As Double, _
    ByVal CompBim As Double) As DCplx
Declare Function nspvSubP Lib "nsp.dll" Alias "nspvSub" _
    (ByVal CompAre As Integer, ByVal CompAim As Integer, ByVal CompBre As Integer, _
    ByVal CompBim As Integer, ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
'___________________________________________________________________________________

'bCopy
Declare Sub nspsbCopyP Lib "nsp.dll" Alias "nspsbCopy" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbCopyP Lib "nsp.dll" Alias "nspcbCopy" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbCopyP Lib "nsp.dll" Alias "nspdbCopy" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbCopyP Lib "nsp.dll" Alias "nspzbCopy" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbCopyP Lib "nsp.dll" Alias "nspwbCopy" _
    (Src As Integer, Dst As Integer, ByVal N As Long)
Declare Sub nspvbCopyP Lib "nsp.dll" Alias "nspvbCopy" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long)

Declare Sub nspsbCopyPtr Lib "nsp.dll" Alias "nspsbCopy" _
    (ByVal srcPtr As Long, ByVal dstPtr As Long, ByVal N As Long)
Declare Sub nspdbCopyPtr Lib "nsp.dll" Alias "nspdbCopy" _
    (ByVal srcPtr As Long, ByVal dstPtr As Long, ByVal N As Long)
Declare Sub nspwbCopyPtr Lib "nsp.dll" Alias "nspwbCopy" _
    (ByVal srcPtr As Long, ByVal dstPtr As Long, ByVal N As Long)

'bSet
Declare Sub nspsbSetP Lib "nsp.dll" Alias "nspsbSet" _
    (ByVal Vall As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbSetP Lib "nsp.dll" Alias "nspcbSet" _
    (ByVal re As Single, ByVal im As Single, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbSetP Lib "nsp.dll" Alias "nspdbSet" _
    (ByVal Vall As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbSetP Lib "nsp.dll" Alias "nspzbSet" _
    (ByVal re As Double, ByVal im As Double, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbSetP Lib "nsp.dll" Alias "nspwbSet" _
    (ByVal Vall As Integer, Dst As Integer, ByVal N As Long)
Declare Sub nspvbSetP Lib "nsp.dll" Alias "nspvbSet" _
    (ByVal re As Integer, ByVal im As Integer, Dst As WCplx, ByVal N As Long)
'bZero
Declare Sub nspsbZeroP Lib "nsp.dll" Alias "nspsbZero" _
    (Dst As Single, ByVal N As Long)
Declare Sub nspcbZeroP Lib "nsp.dll" Alias "nspcbZero" _
    (Dst As SCplx, ByVal N As Long)
Declare Sub nspdbZeroP Lib "nsp.dll" Alias "nspdbZero" _
    (Dst As Double, ByVal N As Long)
Declare Sub nspzbZeroP Lib "nsp.dll" Alias "nspzbZero" _
    (Dst As DCplx, ByVal N As Long)
Declare Sub nspwbZeroP Lib "nsp.dll" Alias "nspwbZero" _
    (Dst As Integer, ByVal N As Long)
Declare Sub nspvbZeroP Lib "nsp.dll" Alias "nspvbZero" _
    (Dst As WCplx, ByVal N As Long)
'__________________________________________________________________________________
'bAdd1
Declare Sub nspsbAdd1P Lib "nsp.dll" Alias "nspsbAdd1" _
    (ByVal Vall As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbAdd1P Lib "nsp.dll" Alias "nspcbAdd1" _
    (ByVal Vallre As Single, ByVal Vallim As Single, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbAdd1P Lib "nsp.dll" Alias "nspdbAdd1" _
    (ByVal Vall As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbAdd1P Lib "nsp.dll" Alias "nspzbAdd1" _
    (ByVal Vallre As Double, ByVal Vallim As Double, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbAdd1P Lib "nsp.dll" Alias "nspwbAdd1" _
    (ByVal Vall As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbAdd1P Lib "nsp.dll" Alias "nspvbAdd1" _
    (ByVal Vallre As Integer, ByVal Vallim As Integer, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bAdd2
Declare Sub nspsbAdd2P Lib "nsp.dll" Alias "nspsbAdd2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbAdd2P Lib "nsp.dll" Alias "nspcbAdd2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbAdd2P Lib "nsp.dll" Alias "nspdbAdd2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbAdd2P Lib "nsp.dll" Alias "nspzbAdd2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbAdd2P Lib "nsp.dll" Alias "nspwbAdd2" _
    (Src As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbAdd2P Lib "nsp.dll" Alias "nspvbAdd2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bAdd3
Declare Sub nspsbAdd3P Lib "nsp.dll" Alias "nspsbAdd3" _
    (SrcA As Single, SrcB As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbAdd3P Lib "nsp.dll" Alias "nspcbAdd3" _
    (SrcA As SCplx, SrcB As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbAdd3P Lib "nsp.dll" Alias "nspdbAdd3" _
    (SrcA As Double, SrcB As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbAdd3P Lib "nsp.dll" Alias "nspzbAdd3" _
    (SrcA As DCplx, SrcB As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbAdd3P Lib "nsp.dll" Alias "nspwbAdd3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbAdd3P Lib "nsp.dll" Alias "nspvbAdd3" _
    (SrcA As WCplx, SrcB As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bMpy1
Declare Sub nspsbMpy1P Lib "nsp.dll" Alias "nspsbMpy1" _
    (ByVal Vall As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbMpy1P Lib "nsp.dll" Alias "nspcbMpy1" _
    (ByVal Vallre As Single, ByVal Vallim As Single, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbMpy1P Lib "nsp.dll" Alias "nspdbMpy1" _
    (ByVal Vall As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbMpy1P Lib "nsp.dll" Alias "nspzbMpy1" _
    (ByVal Vallre As Double, ByVal Vallim As Double, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbMpy1P Lib "nsp.dll" Alias "nspwbMpy1" _
    (ByVal Vall As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbMpy1P Lib "nsp.dll" Alias "nspvbMpy1" _
    (ByVal Vallre As Integer, ByVal Vallim As Integer, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bMpy2
Declare Sub nspsbMpy2P Lib "nsp.dll" Alias "nspsbMpy2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbMpy2P Lib "nsp.dll" Alias "nspcbMpy2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbMpy2P Lib "nsp.dll" Alias "nspdbMpy2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbMpy2P Lib "nsp.dll" Alias "nspzbMpy2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbMpy2P Lib "nsp.dll" Alias "nspwbMpy2" _
    (Src As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbMpy2P Lib "nsp.dll" Alias "nspvbMpy2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bMpy3
Declare Sub nspsbMpy3P Lib "nsp.dll" Alias "nspsbMpy3" _
    (SrcA As Single, SrcB As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbMpy3P Lib "nsp.dll" Alias "nspcbMpy3" _
    (SrcA As SCplx, SrcB As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbMpy3P Lib "nsp.dll" Alias "nspdbMpy3" _
    (SrcA As Double, SrcB As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbMpy3P Lib "nsp.dll" Alias "nspzbMpy3" _
    (SrcA As DCplx, SrcB As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbMpy3P Lib "nsp.dll" Alias "nspwbMpy3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbMpy3P Lib "nsp.dll" Alias "nspvbMpy3" _
    (SrcA As WCplx, SrcB As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bSub1
Declare Sub nspsbSub1P Lib "nsp.dll" Alias "nspsbSub1" _
    (ByVal Vall As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbSub1P Lib "nsp.dll" Alias "nspcbSub1" _
    (ByVal Vallre As Single, ByVal Vallim As Single, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbSub1P Lib "nsp.dll" Alias "nspdbSub1" _
    (ByVal Vall As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbSub1P Lib "nsp.dll" Alias "nspzbSub1" _
    (ByVal Vallre As Double, ByVal Vallim As Double, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbSub1P Lib "nsp.dll" Alias "nspwbSub1" _
    (ByVal Vall As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbSub1P Lib "nsp.dll" Alias "nspvbSub1" _
    (ByVal Vallre As Integer, ByVal Vallim As Integer, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bSub2
Declare Sub nspsbSub2P Lib "nsp.dll" Alias "nspsbSub2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbSub2P Lib "nsp.dll" Alias "nspcbSub2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbSub2P Lib "nsp.dll" Alias "nspdbSub2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbSub2P Lib "nsp.dll" Alias "nspzbSub2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbSub2P Lib "nsp.dll" Alias "nspwbSub2" _
    (Src As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbSub2P Lib "nsp.dll" Alias "nspvbSub2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bSub3
Declare Sub nspsbSub3P Lib "nsp.dll" Alias "nspsbSub3" _
    (Src As Single, Vall As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbSub3P Lib "nsp.dll" Alias "nspcbSub3" _
    (SrcA As SCplx, SrcB As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbSub3P Lib "nsp.dll" Alias "nspdbSub3" _
    (Src As Double, Vall As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbSub3P Lib "nsp.dll" Alias "nspzbSub3" _
    (SrcA As DCplx, SrcB As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbSub3P Lib "nsp.dll" Alias "nspwbSub3" _
    (Src As Integer, Vall As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbSub3P Lib "nsp.dll" Alias "nspvbSub3" _
    (SrcA As WCplx, SrcB As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bNormalize
Declare Sub nspsbNormalizeP Lib "nsp.dll" Alias "nspsbNormalize" _
    (Src As Single, Dst As Single, ByVal N As Long, ByVal Offset As Single, _
    ByVal factor As Single)
Declare Sub nspcbNormalizeP Lib "nsp.dll" Alias "nspcbNormalize" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long, ByVal offsetre As Single, _
    ByVal offsetim As Single, ByVal factor As Single)
Declare Sub nspdbNormalizeP Lib "nsp.dll" Alias "nspdbNormalize" _
    (Src As Double, Dst As Double, ByVal N As Long, ByVal Offset As Double, _
    ByVal factor As Single)
Declare Sub nspzbNormalizeP Lib "nsp.dll" Alias "nspzbNormalize" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long, ByVal offsetre As Double, _
    ByVal offsetim As Double, ByVal factor As Single)
Declare Sub nspwbNormalizeP Lib "nsp.dll" Alias "nspwbNormalize" _
    (Src As Integer, Dst As Integer, ByVal N As Long, ByVal Offset As Integer, _
    ByVal factor As Single)
Declare Sub nspvbNormalizeP Lib "nsp.dll" Alias "nspvbNormalize" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long, ByVal offsetre As Integer, _
    ByVal offsetim As Integer, ByVal factor As Single)
'DotProd
Declare Function nspsDotProdP Lib "nsp.dll" Alias "nspsDotProd" _
    (Vec1 As Single, Vec2 As Single, ByVal N As Long) As Single
Declare Function nspcDotProdP Lib "nsp.dll" Alias "nspcDotProd" _
    (Vec1 As SCplx, Vec2 As SCplx, ByVal N As Long) As SCplx
Declare Function nspdDotProdP Lib "nsp.dll" Alias "nspdDotProd" _
    (Vec1 As Double, Vec2 As Double, ByVal N As Long) As Double
Declare Function nspzDotProdP Lib "nsp.dll" Alias "nspzDotProd" _
    (Vec1 As DCplx, Vec2 As DCplx, ByVal N As Long) As DCplx
Declare Function nspscDotProdP Lib "nsp.dll" Alias "nspscDotProd" _
    (Vec1 As Single, Vec2 As SCplx, ByVal N As Long) As SCplx
Declare Function nspcsDotProdP Lib "nsp.dll" Alias "nspcsDotProd" _
    (Vec1 As SCplx, Vec2 As Single, ByVal N As Long) As SCplx
Declare Function nspdzDotProdP Lib "nsp.dll" Alias "nspdzDotProd" _
    (Vec1 As Double, Vec2 As DCplx, ByVal N As Long) As DCplx
Declare Function nspzdDotProdP Lib "nsp.dll" Alias "nspzdDotProd" _
    (Vec1 As DCplx, Vec2 As Double, ByVal N As Long) As DCplx
Declare Function nspwDotProdP Lib "nsp.dll" Alias "nspwDotProd" _
    (Vec1 As Integer, Vec2 As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As Integer
Declare Function nspvDotProdP Lib "nsp.dll" Alias "nspvDotProd" _
    (Vec1 As WCplx, Vec2 As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
'******
Declare Function nspwvDotProdP Lib "nsp.dll" Alias "nspwvDotProd" _
    (Vec1 As Integer, Vec2 As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx

'bThresh1
Declare Sub nspsbThresh1P Lib "nsp.dll" Alias "nspsbThresh1" _
    (Vec As Single, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
Declare Sub nspcbThresh1P Lib "nsp.dll" Alias "nspcbThresh1" _
    (Vec As SCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
Declare Sub nspdbThresh1P Lib "nsp.dll" Alias "nspdbThresh1" _
    (Vec As Double, ByVal N As Long, ByVal Thresh As Double, _
    ByVal re10p As Long)
Declare Sub nspzbThresh1P Lib "nsp.dll" Alias "nspzbThresh1" _
    (Vec As DCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
Declare Sub nspwbThresh1P Lib "nsp.dll" Alias "nspwbThresh1" _
    (Vec As Integer, ByVal N As Long, ByVal Thresh As Integer, _
    ByVal re10p As Long)
Declare Sub nspvbThresh1P Lib "nsp.dll" Alias "nspvbThresh1" _
    (Vec As WCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
'bThresh2
Declare Sub nspsbThresh2P Lib "nsp.dll" Alias "nspsbThresh2" _
    (Src As Single, Dst As Single, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
Declare Sub nspcbThresh2P Lib "nsp.dll" Alias "nspcbThresh2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
Declare Sub nspdbThresh2P Lib "nsp.dll" Alias "nspdbThresh2" _
    (Src As Double, Dst As Double, ByVal N As Long, ByVal Thresh As Double, _
    ByVal re10p As Long)
Declare Sub nspzbThresh2P Lib "nsp.dll" Alias "nspzbThresh2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long, ByVal Thresh As Double, _
    ByVal re10p As Long)
Declare Sub nspwbThresh2P Lib "nsp.dll" Alias "nspwbThresh2" _
    (Src As Integer, Dst As Integer, ByVal N As Long, ByVal Thresh As Integer, _
    ByVal re10p As Long)
Declare Sub nspvbThresh2P Lib "nsp.dll" Alias "nspvbThresh2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long, ByVal Thresh As Integer, _
    ByVal re10p As Long)
'bInvThresh1
Declare Sub nspsbInvThresh1P Lib "nsp.dll" Alias "nspsbInvThresh1" _
    (Vec As Single, ByVal N As Long, ByVal Thresh As Single)
Declare Sub nspcbInvThresh1P Lib "nsp.dll" Alias "nspcbInvThresh1" _
    (Vec As SCplx, ByVal N As Long, ByVal Thresh As Single)
Declare Sub nspdbInvThresh1P Lib "nsp.dll" Alias "nspdbInvThresh1" _
    (Vec As Double, ByVal N As Long, ByVal Thresh As Double)
Declare Sub nspzbInvThresh1P Lib "nsp.dll" Alias "nspzbInvThresh1" _
    (Vec As DCplx, ByVal N As Long, ByVal Thresh As Double)
'bInvThresh2
Declare Sub nspsbInvThresh2P Lib "nsp.dll" Alias "nspsbInvThresh2" _
    (Src As Single, Dst As Single, ByVal N As Long, ByVal Thresh As Single)
Declare Sub nspcbInvThresh2P Lib "nsp.dll" Alias "nspcbInvThresh2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long, ByVal Thresh As Single)
Declare Sub nspdbInvThresh2P Lib "nsp.dll" Alias "nspdbInvThresh2" _
    (Src As Double, Dst As Double, ByVal N As Long, ByVal Thresh As Double)
Declare Sub nspzbInvThresh2P Lib "nsp.dll" Alias "nspzbInvThresh2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long, ByVal Thresh As Double)
'bAbs1
Declare Sub nspsbAbs1P Lib "nsp.dll" Alias "nspsbAbs1" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspdbAbs1P Lib "nsp.dll" Alias "nspdbAbs1" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspwbAbs1P Lib "nsp.dll" Alias "nspwbAbs1" _
    (Vec As Integer, ByVal N As Long)
'bAbs2
Declare Sub nspsbAbs2P Lib "nsp.dll" Alias "nspsbAbs2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspdbAbs2P Lib "nsp.dll" Alias "nspdbAbs2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspwbAbs2P Lib "nsp.dll" Alias "nspwbAbs2" _
    (Src As Integer, Dst As Integer, ByVal N As Long)
'bSqr1
Declare Sub nspsbSqr1P Lib "nsp.dll" Alias "nspsbSqr1" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcbSqr1P Lib "nsp.dll" Alias "nspcbSqr1" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdbSqr1P Lib "nsp.dll" Alias "nspdbSqr1" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzbSqr1P Lib "nsp.dll" Alias "nspzbSqr1" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwbSqr1P Lib "nsp.dll" Alias "nspwbSqr1" _
    (Vec As Integer, ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbSqr1P Lib "nsp.dll" Alias "nspvbSqr1" _
    (Vec As WCplx, ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
'bSqr2
Declare Sub nspsbSqr2P Lib "nsp.dll" Alias "nspsbSqr2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbSqr2P Lib "nsp.dll" Alias "nspcbSqr2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbSqr2P Lib "nsp.dll" Alias "nspdbSqr2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbSqr2P Lib "nsp.dll" Alias "nspzbSqr2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbSqr2P Lib "nsp.dll" Alias "nspwbSqr2" _
    (Src As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvbSqr2P Lib "nsp.dll" Alias "nspvbSqr2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bSqrt1
Declare Sub nspsbSqrt1P Lib "nsp.dll" Alias "nspsbSqrt1" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcbSqrt1P Lib "nsp.dll" Alias "nspcbSqrt1" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdbSqrt1P Lib "nsp.dll" Alias "nspdbSqrt1" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzbSqrt1P Lib "nsp.dll" Alias "nspzbSqrt1" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwbSqrt1P Lib "nsp.dll" Alias "nspwbSqrt1" _
    (Vec As Integer, ByVal N As Long)
Declare Sub nspvbSqrt1P Lib "nsp.dll" Alias "nspvbSqrt1" _
    (Vec As WCplx, ByVal N As Long)
'Sqrt2
Declare Sub nspsbSqrt2P Lib "nsp.dll" Alias "nspsbSqrt2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspcbSqrt2P Lib "nsp.dll" Alias "nspcbSqrt2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspdbSqrt2P Lib "nsp.dll" Alias "nspdbSqrt2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspzbSqrt2P Lib "nsp.dll" Alias "nspzbSqrt2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspwbSqrt2P Lib "nsp.dll" Alias "nspwbSqrt2" _
    (Src As Integer, Dst As Integer, ByVal N As Long)
Declare Sub nspvbSqrt2P Lib "nsp.dll" Alias "nspvbSqrt2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long)
'bExp1
Declare Sub nspsbExp1P Lib "nsp.dll" Alias "nspsbExp1" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspdbExp1P Lib "nsp.dll" Alias "nspdbExp1" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspwbExp1P Lib "nsp.dll" Alias "nspwbExp1" _
    (Vec As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'bExp2
Declare Sub nspsbExp2P Lib "nsp.dll" Alias "nspsbExp2" _
    (Src As Single, Dst As Single, ByVal N As Long)
'*********
Declare Sub nspsdbExp2P Lib "nsp.dll" Alias "nspsdbExp2" _
    (Src As Single, Dst As Double, ByVal N As Long)
Declare Sub nspdbExp2P Lib "nsp.dll" Alias "nspdbExp2" _
    (Src As Double, Dst As Double, ByVal N As Long)
Declare Sub nspwbExp2P Lib "nsp.dll" Alias "nspwbExp2" _
    (Src As Integer, Dst As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

'bLn1
Declare Sub nspsbLn1P Lib "nsp.dll" Alias "nspsbLn1" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspdbLn1P Lib "nsp.dll" Alias "nspdbLn1" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspwbLn1P Lib "nsp.dll" Alias "nspwbLn1" _
    (Vec As Integer, ByVal N As Long)
'bLn2
Declare Sub nspsbLn2P Lib "nsp.dll" Alias "nspsbLn2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspdbLn2P Lib "nsp.dll" Alias "nspdbLn2" _
    (Src As Double, Dst As Double, ByVal N As Long)
'**********
Declare Sub nspdsbLn2P Lib "nsp.dll" Alias "nspdsbLn2" _
    (Src As Double, Dst As Single, ByVal N As Long)
Declare Sub nspwbLn2P Lib "nsp.dll" Alias "nspwbLn2" _
    (Src As Integer, Dst As Integer, ByVal N As Long)
'bLg1
'**********
Declare Sub nspsbLg1P Lib "nsp.dll" Alias "nspsbLg1" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspdbLg1P Lib "nsp.dll" Alias "nspdbLg1" _
    (Vec As Double, ByVal N As Long)
'*********
Declare Sub nspcbLg1P Lib "nsp.dll" Alias "nspcbLg1" _
    (Vec As SCplx, ByVal N As Long)
'bLg2
Declare Sub nspsbLg2P Lib "nsp.dll" Alias "nspsbLg2" _
    (Src As Single, Dst As Single, ByVal N As Long)
Declare Sub nspdbLg2P Lib "nsp.dll" Alias "nspdbLg2" _
    (Src As Double, Dst As Double, ByVal N As Long)
'*********
Declare Sub nspcbLg2P Lib "nsp.dll" Alias "nspcbLg2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
'*********
Declare Sub nspczbLg2P Lib "nsp.dll" Alias "nspczbLg2" _
    (Src As SCplx, Dst As DCplx, ByVal N As Long)
'bArctan1
'*********
Declare Sub nspsbArctan1P Lib "nsp.dll" Alias "nspsbArctan1" _
    (Vec As Single, ByVal N As Long)
'*********
Declare Sub nspdbArctan1P Lib "nsp.dll" Alias "nspdbArctan1" _
    (Vec As Double, ByVal N As Long)
'bArctan2
'*********
Declare Sub nspsbArctan2P Lib "nsp.dll" Alias "nspsbArctan2" _
    (Src As Single, Dst As Single, ByVal N As Long)
'*********
Declare Sub nspdbArctan2P Lib "nsp.dll" Alias "nspdbArctan2" _
    (Src As Double, Dst As Double, ByVal N As Long)
'___________________________________________________________________
'*********
Declare Sub nspwbAnd1P Lib "nsp.dll" Alias "nspwbAnd1" _
    (ByVal Val As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbAnd2P Lib "nsp.dll" Alias "nspwbAnd2" _
    (Src As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbAnd3P Lib "nsp.dll" Alias "nspwbAnd3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbOr1P Lib "nsp.dll" Alias "nspwbOr1" _
    (ByVal Val As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbOr2P Lib "nsp.dll" Alias "nspwbOr2" _
     (Src As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbOr3P Lib "nsp.dll" Alias "nspwbOr3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbXor1P Lib "nsp.dll" Alias "nspwbXor1" _
    (ByVal Val As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbXor2P Lib "nsp.dll" Alias "nspwbXor2" _
     (Src As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbXor3P Lib "nsp.dll" Alias "nspwbXor3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbNotP Lib "nsp.dll" Alias "nspwbNot" _
    (Dst As Integer, ByVal N As Long)
'*********
Declare Sub nspwbShiftLP Lib "nsp.dll" Alias "nspwbShiftL" _
    (Dst As Integer, ByVal N As Long, ByVal nShift As Long)
'*********
Declare Sub nspwbShiftRP Lib "nsp.dll" Alias "nspwbShiftR" _
    (Dst As Integer, ByVal N As Long, ByVal nShift As Long)
    
'__________________Vector Measure Functions_________________
'Max
Declare Function nspsMaxP Lib "nsp.dll" Alias "nspsMax" _
    (Vec As Single, ByVal N As Long) As Single
Declare Function nspdMaxP Lib "nsp.dll" Alias "nspdMax" _
    (Vec As Double, ByVal N As Long) As Double
Declare Function nspwMaxP Lib "nsp.dll" Alias "nspwMax" _
    (Vec As Integer, ByVal N As Long) As Integer
'MaxExt
'*******
Declare Function nspsMaxExtP Lib "nsp.dll" Alias "nspsMaxExt" _
    (Vec As Single, ByVal N As Long, Index As Long) As Single
'*******
Declare Function nspdMaxExtP Lib "nsp.dll" Alias "nspdMaxExt" _
    (Vec As Double, ByVal N As Long, Index As Long) As Double
'*******
Declare Function nspwMaxExtP Lib "nsp.dll" Alias "nspwMaxExt" _
    (Vec As Integer, ByVal N As Long, Index As Long) As Integer
'Min
Declare Function nspsMinP Lib "nsp.dll" Alias "nspsMin" _
    (Vec As Single, ByVal N As Long) As Single
Declare Function nspdMinP Lib "nsp.dll" Alias "nspdMin" _
    (Vec As Double, ByVal N As Long) As Double
Declare Function nspwMinP Lib "nsp.dll" Alias "nspwMin" _
    (Vec As Integer, ByVal N As Long) As Integer
'MinExt
'*******
Declare Function nspsMinExtP Lib "nsp.dll" Alias "nspsMinExt" _
    (Vec As Single, ByVal N As Long, Index As Long) As Single
'*******
Declare Function nspdMinExtP Lib "nsp.dll" Alias "nspdMinExt" _
    (Vec As Double, ByVal N As Long, Index As Long) As Double
'*******
Declare Function nspwMinExtP Lib "nsp.dll" Alias "nspwMinExt" _
    (Vec As Integer, ByVal N As Long, Index As Long) As Integer
    
'Sum
'********
Declare Function nspsSumP Lib "nsp.dll" Alias "nspsSum" _
    (Src As Single, ByVal N As Long) As Single
'********
Declare Function nspdSumP Lib "nsp.dll" Alias "nspdSum" _
    (Src As Double, ByVal N As Long) As Double
'********
Declare Function nspwSumP Lib "nsp.dll" Alias "nspwSum" _
    (Src As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As Integer
'********
Declare Function nspcSumP Lib "nsp.dll" Alias "nspcSum" _
    (Src As SCplx, ByVal N As Long, Sum As SCplx) As Long
    
'********
Declare Function nspzSumP Lib "nsp.dll" Alias "nspzSum" _
    (Src As DCplx, ByVal N As Long, Sum As DCplx) As Long
'********
Declare Function nspvSumP Lib "nsp.dll" Alias "nspvSum" _
    (Src As WCplx, ByVal N As Long, Sum As ICplx, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As Long
'Mean
Declare Function nspsMeanP Lib "nsp.dll" Alias "nspsMean" _
    (Vec As Single, ByVal N As Long) As Single
Declare Function nspdMeanP Lib "nsp.dll" Alias "nspdMean" _
    (Vec As Double, ByVal N As Long) As Double
Declare Function nspwMeanP Lib "nsp.dll" Alias "nspwMean" _
    (Vec As Integer, ByVal N As Long) As Integer
'StdDev
Declare Function nspsStdDevP Lib "nsp.dll" Alias "nspsStdDev" _
    (Vec As Single, ByVal N As Long) As Single
Declare Function nspdStdDevP Lib "nsp.dll" Alias "nspdStdDev" _
    (Vec As Double, ByVal N As Long) As Double
Declare Function nspwStdDevP Lib "nsp.dll" Alias "nspwStdDev" _
    (Vec As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As Integer
'Norm
Declare Function nspsNormP Lib "nsp.dll" Alias "nspsNorm" _
    (SrcA As Single, SrcB As Single, ByVal N As Long, ByVal flag As Long) _
    As Single
Declare Function nspcNormP Lib "nsp.dll" Alias "nspcNorm" _
    (SrcA As SCplx, SrcB As SCplx, ByVal N As Long, ByVal flag As Long) _
    As Single
Declare Function nspdNormP Lib "nsp.dll" Alias "nspdNorm" _
    (SrcA As Double, SrcB As Double, ByVal N As Long, ByVal flag As Long) _
    As Double
Declare Function nspzNormP Lib "nsp.dll" Alias "nspzNorm" _
    (SrcA As DCplx, SrcB As DCplx, ByVal N As Long, ByVal flag As Long) _
    As Double
Declare Function nspwNormP Lib "nsp.dll" Alias "nspwNorm" _
    (SrcA As Integer, SrcB As Integer, ByVal N As Long, ByVal flag As Long) _
    As Single
Declare Function nspvNormP Lib "nsp.dll" Alias "nspvNorm" _
    (SrcA As WCplx, SrcB As WCplx, ByVal N As Long, ByVal flag As Long) _
    As Single
'*********
 Declare Function nspwNormExtP Lib "nsp.dll" Alias "nspwNormExt" _
    (SrcA As Integer, SrcB As Integer, ByVal N As Long, ByVal flag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As Long
'*********
 Declare Function nspvNormExtP Lib "nsp.dll" Alias "nspvNormExt" _
     (SrcA As WCplx, SrcB As WCplx, ByVal N As Long, ByVal flag As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long) As Long


'________________Vector Conjugation Functions____________________

'bConj1
Declare Sub nspcbConj1P Lib "nsp.dll" Alias "nspcbConj1" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspzbConj1P Lib "nsp.dll" Alias "nspzbConj1" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspvbConj1P Lib "nsp.dll" Alias "nspvbConj1" _
    (Vec As WCplx, ByVal N As Long)
'bConj2
Declare Sub nspcbConj2P Lib "nsp.dll" Alias "nspcbConj2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspzbConj2P Lib "nsp.dll" Alias "nspzbConj2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspvbConj2P Lib "nsp.dll" Alias "nspvbConj2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long)
'bConjExtend1
Declare Sub nspcbConjExtend1P Lib "nsp.dll" Alias "nspcbConjExtend1" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspzbConjExtend1P Lib "nsp.dll" Alias "nspzbConjExtend1" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspvbConjExtend1P Lib "nsp.dll" Alias "nspvbConjExtend1" _
    (Vec As WCplx, ByVal N As Long)
'bConjExtend2
Declare Sub nspcbConjExtend2P Lib "nsp.dll" Alias "nspcbConjExtend2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspzbConjExtend2P Lib "nsp.dll" Alias "nspzbConjExtend2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspvbConjExtend2P Lib "nsp.dll" Alias "nspvbConjExtend2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long)
'bConjFlip2
Declare Sub nspcbConjFlip2P Lib "nsp.dll" Alias "nspcbConjFlip2" _
    (Src As SCplx, Dst As SCplx, ByVal N As Long)
Declare Sub nspzbConjFlip2P Lib "nsp.dll" Alias "nspzbConjFlip2" _
    (Src As DCplx, Dst As DCplx, ByVal N As Long)
Declare Sub nspvbConjFlip2P Lib "nsp.dll" Alias "nspvbConjFlip2" _
    (Src As WCplx, Dst As WCplx, ByVal N As Long)
'_________________Resampling Functions_______________________
'UpSample
Declare Sub nspsUpSampleP Lib "nsp.dll" Alias "nspsUpSample" _
    (Src As Single, ByVal SrcLen As Long, Dst As Single, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspcUpSampleP Lib "nsp.dll" Alias "nspcUpSample" _
    (Src As SCplx, ByVal SrcLen As Long, Dst As SCplx, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspdUpSampleP Lib "nsp.dll" Alias "nspdUpSample" _
    (Src As Double, ByVal SrcLen As Long, Dst As Double, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspzUpSampleP Lib "nsp.dll" Alias "nspzUpSample" _
    (Src As DCplx, ByVal SrcLen As Long, Dst As DCplx, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspwUpSampleP Lib "nsp.dll" Alias "nspwUpSample" _
    (Src As Integer, ByVal SrcLen As Long, Dst As Integer, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspvUpSampleP Lib "nsp.dll" Alias "nspvUpSample" _
    (Src As WCplx, ByVal SrcLen As Long, Dst As WCplx, DstLen As Long, _
    ByVal factor As Long, phase As Long)
'DownSample
Declare Sub nspsDownSampleP Lib "nsp.dll" Alias "nspsDownSample" _
    (Src As Single, ByVal SrcLen As Long, Dst As Single, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspcDownSampleP Lib "nsp.dll" Alias "nspcDownSample" _
    (Src As SCplx, ByVal SrcLen As Long, Dst As SCplx, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspdDownSampleP Lib "nsp.dll" Alias "nspdDownSample" _
    (Src As Double, ByVal SrcLen As Long, Dst As Double, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspzDownSampleP Lib "nsp.dll" Alias "nspzDownSample" _
    (Src As DCplx, ByVal SrcLen As Long, Dst As DCplx, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspwDownSampleP Lib "nsp.dll" Alias "nspwDownSample" _
    (Src As Integer, ByVal SrcLen As Long, Dst As Integer, DstLen As Long, _
    ByVal factor As Long, phase As Long)
Declare Sub nspvDownSampleP Lib "nsp.dll" Alias "nspvDownSample" _
    (Src As WCplx, ByVal SrcLen As Long, Dst As WCplx, DstLen As Long, _
    ByVal factor As Long, phase As Long)
'______________________Resampling with filtering_________________
'NSPStatus nspsSampInit (NSPSampState* sampSt, float* factorRange,
'float* freq, int nFactors,intnTaps)
'NSPStatus nspdSampInit (NSPSampState* sampSt, float* factorRange,
'float* freq, int nFactors,intnTaps)
    
' NSPStatus nspsSamp(NSPSampState* sampSt,const float* src,
'int srcLen, float* dst, int dstLen)
'NSPStatus nspdSamp(NSPSampState* sampSt,const double* src,
'int srcLen, double* dst,intdstLen)

'void nspSampFree(NSPSampState * sampSt)
    
'_________________Vector Correlation Functions_______________
'AutoCorr
Declare Sub nspsAutoCorrP Lib "nsp.dll" Alias "nspsAutoCorr" _
    (Src As Single, ByVal lenn As Long, Dst As Single, _
    ByVal nLags As Long, ByVal flag As Long)
Declare Sub nspcAutoCorrP Lib "nsp.dll" Alias "nspcAutoCorr" _
    (Src As SCplx, ByVal lenn As Long, Dst As SCplx, _
    ByVal nLags As Long, ByVal flag As Long)
Declare Sub nspdAutoCorrP Lib "nsp.dll" Alias "nspdAutoCorr" _
    (Src As Double, ByVal lenn As Long, Dst As Double, _
    ByVal nLags As Long, ByVal flag As Long)
Declare Sub nspzAutoCorrP Lib "nsp.dll" Alias "nspzAutoCorr" _
    (Src As DCplx, ByVal lenn As Long, Dst As DCplx, _
    ByVal nLags As Long, ByVal flag As Long)
Declare Sub nspwAutoCorrP Lib "nsp.dll" Alias "nspwAutoCorr" _
    (Src As Integer, ByVal lenn As Long, Dst As Integer, _
    ByVal nLags As Long, ByVal flag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvAutoCorrP Lib "nsp.dll" Alias "nspvAutoCorr" _
    (Src As WCplx, ByVal lenn As Long, Dst As WCplx, _
    ByVal nLags As Long, ByVal flag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
'CrossCorr
Declare Sub nspsCrossCorrP Lib "nsp.dll" Alias "nspsCrossCorr" _
    (SrcA As Single, ByVal LennA As Long, SrcB As Single, ByVal LennB As Long, _
    Dst As Single, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspcCrossCorrP Lib "nsp.dll" Alias "nspcCrossCorr" _
    (SrcA As SCplx, ByVal LennA As Long, SrcB As SCplx, ByVal LennB As Long, _
    Dst As SCplx, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspscCrossCorrP Lib "nsp.dll" Alias "nspscCrossCorr" _
    (SrcA As Single, ByVal LennA As Long, SrcB As SCplx, ByVal LennB As Long, _
    Dst As SCplx, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspcsCrossCorrP Lib "nsp.dll" Alias "nspcsCrossCorr" _
    (SrcA As SCplx, ByVal LennA As Long, SrcB As Single, ByVal LennB As Long, _
    Dst As SCplx, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspdCrossCorrP Lib "nsp.dll" Alias "nspdCrossCorr" _
    (SrcA As Double, ByVal LennA As Long, SrcB As Double, ByVal LennB As Long, _
    Dst As Double, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspzCrossCorrP Lib "nsp.dll" Alias "nspzCrossCorr" _
    (SrcA As DCplx, ByVal LennA As Long, SrcB As DCplx, ByVal LennB As Long, _
    Dst As DCplx, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspdzCrossCorrP Lib "nsp.dll" Alias "nspdzCrossCorr" _
    (SrcA As Double, ByVal LennA As Long, SrcB As DCplx, ByVal LennB As Long, _
    Dst As DCplx, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspzdCrossCorrP Lib "nsp.dll" Alias "nspzdCrossCorr" _
    (SrcA As DCplx, ByVal LennA As Long, SrcB As Double, ByVal LennB As Long, _
    Dst As DCplx, ByVal LoLag As Long, ByVal HiLag As Long)
Declare Sub nspwCrossCorrP Lib "nsp.dll" Alias "nspwCrossCorr" _
    (SrcA As Integer, ByVal LennA As Long, SrcB As Integer, ByVal LennB As Long, _
    Dst As Integer, ByVal LoLag As Long, ByVal HiLag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvCrossCorrP Lib "nsp.dll" Alias "nspvCrossCorr" _
    (SrcA As WCplx, ByVal LennA As Long, SrcB As WCplx, ByVal LennB As Long, _
    Dst As WCplx, ByVal LoLag As Long, ByVal HiLag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspwvCrossCorrP Lib "nsp.dll" Alias "nspwvCrossCorr" _
    (SrcA As Integer, ByVal LennA As Long, SrcB As WCplx, ByVal LennB As Long, _
    Dst As WCplx, ByVal LoLag As Long, ByVal HiLag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvwCrossCorrP Lib "nsp.dll" Alias "nspvwCrossCorr" _
    (SrcA As WCplx, ByVal LennA As Long, SrcB As Integer, ByVal LennB As Long, _
    Dst As WCplx, ByVal LoLag As Long, ByVal HiLag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

'CHAPTER 4.
'Vector Data Conversion Functions.

'bReal
Declare Sub nspcbRealP Lib "nsp.dll" Alias "nspcbReal" _
    (Src As SCplx, Dst As Single, ByVal N As Long)
Declare Sub nspzbRealP Lib "nsp.dll" Alias "nspzbReal" _
    (Src As DCplx, Dst As Double, ByVal N As Long)
Declare Sub nspvbRealP Lib "nsp.dll" Alias "nspvbReal" _
    (Src As WCplx, Dst As Integer, ByVal N As Long)
'bImag
Declare Sub nspcbImagP Lib "nsp.dll" Alias "nspcbImag" _
    (Src As SCplx, Dst As Single, ByVal N As Long)
Declare Sub nspzbImagP Lib "nsp.dll" Alias "nspzbImag" _
    (Src As DCplx, Dst As Double, ByVal N As Long)
Declare Sub nspvbImagP Lib "nsp.dll" Alias "nspvbImag" _
    (Src As WCplx, Dst As Integer, ByVal N As Long)
    
Declare Sub nspcb2RealToCplxP Lib "nsp.dll" Alias "nspcb2RealToCplx" _
    (srcReal As Single, srcImag As Single, Dst As SCplx, ByVal N As Long)
Declare Sub nspzb2RealToCplxP Lib "nsp.dll" Alias "nspzb2RealToCplx" _
    (srcReal As Double, srcImag As Double, Dst As DCplx, ByVal N As Long)
Declare Sub nspvb2RealToCplxP Lib "nsp.dll" Alias "nspvb2RealToCplx" _
    (srcReal As Integer, srcImag As Integer, Dst As WCplx, ByVal N As Long)

Declare Sub nspcbCplxTo2RealP Lib "nsp.dll" Alias "nspcbCplxTo2Real" _
    (Src As SCplx, DstReal As Single, DstImag As Single, ByVal N As Long)
Declare Sub nspzbCplxTo2RealP Lib "nsp.dll" Alias "nspzbCplxTo2Real" _
    (Src As DCplx, DstReal As Double, DstImag As Double, ByVal N As Long)
Declare Sub nspvbCplxTo2RealP Lib "nsp.dll" Alias "nspvbCplxTo2Real" _
    (Src As WCplx, DstReal As Integer, DstImag As Integer, ByVal N As Long)

Declare Sub nspcbMagP Lib "nsp.dll" Alias "nspcbMag" _
    (Src As SCplx, mag As Single, ByVal N As Long)
Declare Sub nspzbMagP Lib "nsp.dll" Alias "nspzbMag" _
    (Src As DCplx, mag As Double, ByVal N As Long)
Declare Sub nspvbMagP Lib "nsp.dll" Alias "nspvbMag" _
    (Src As WCplx, mag As Integer, ByVal N As Long, ByVal ScaleMode As Long, _
    ScaleFactor As Long)

Declare Sub nspsbrMagP Lib "nsp.dll" Alias "nspsbrMag" _
    (srcReal As Single, srcImag As Single, mag As Single, ByVal N As Long)
Declare Sub nspdbrMagP Lib "nsp.dll" Alias "nspdbrMag" _
    (srcReal As Double, srcImag As Double, mag As Double, ByVal N As Long)
Declare Sub nspwbrMagP Lib "nsp.dll" Alias "nspwbrMag" _
    (srcReal As Integer, srcImag As Integer, mag As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspcbPhaseP Lib "nsp.dll" Alias "nspcbPhase" _
    (Src As SCplx, phase As Single, ByVal N As Long)
Declare Sub nspzbPhaseP Lib "nsp.dll" Alias "nspzbPhase" _
    (Src As DCplx, phase As Double, ByVal N As Long)
Declare Sub nspvbPhaseP Lib "nsp.dll" Alias "nspvbPhase" _
    (Src As WCplx, phase As Integer, ByVal N As Long, ByVal ScaleMode As Long, _
    ScaleFactor As Long)

Declare Sub nspsbrPhaseP Lib "nsp.dll" Alias "nspsbrPhase" _
    (srcReal As Single, srcImag As Single, phase As Single, ByVal N As Long)
Declare Sub nspdbrPhaseP Lib "nsp.dll" Alias "nspdbrPhase" _
    (srcReal As Double, srcImag As Double, phase As Double, ByVal N As Long)
Declare Sub nspwbrPhaseP Lib "nsp.dll" Alias "nspwbrPhase" _
    (srcReal As Integer, srcImag As Integer, phase As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspcbPowerSpectrP Lib "nsp.dll" Alias "nspcbPowerSpectr" _
    (Src As SCplx, Spectr As Single, ByVal N As Long)
Declare Sub nspzbPowerSpectrP Lib "nsp.dll" Alias "nspzbPowerSpectr" _
    (Src As DCplx, Spectr As Double, ByVal N As Long)
Declare Sub nspvbPowerSpectrP Lib "nsp.dll" Alias "nspvbPowerSpectr" _
    (Src As WCplx, Spectr As Integer, ByVal N As Long, ByVal ScaleMode As Long, _
    ScaleFactor As Long)

Declare Sub nspsbrPowerSpectrP Lib "nsp.dll" Alias "nspsbrPowerSpectr" _
    (srcReal As Single, srcImag As Single, Spectr As Single, ByVal N As Long)
Declare Sub nspdbrPowerSpectrP Lib "nsp.dll" Alias "nspdbrPowerSpectr" _
    (srcReal As Double, srcImag As Double, Spectr As Double, ByVal N As Long)
Declare Sub nspwbrPowerSpectrP Lib "nsp.dll" Alias "nspwbrPowerSpectr" _
    (srcReal As Integer, srcImag As Integer, Spectr As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsbFloatToInt8P Lib "nsp.dll" Alias "nspsbFloatToInt" _
    (Src As Single, Dst As Byte, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspsbFloatToInt16P Lib "nsp.dll" Alias "nspsbFloatToInt" _
    (Src As Single, Dst As Integer, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspsbFloatToInt32P Lib "nsp.dll" Alias "nspsbFloatToInt" _
    (Src As Single, Dst As Long, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspdbFloatToInt8P Lib "nsp.dll" Alias "nspdbFloatToInt" _
    (Src As Double, Dst As Byte, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspdbFloatToInt16P Lib "nsp.dll" Alias "nspdbFloatToInt" _
    (Src As Double, Dst As Integer, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspdbFloatToInt32P Lib "nsp.dll" Alias "nspdbFloatToInt" _
    (Src As Double, Dst As Long, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
    
Declare Sub nspsbInt8ToFloatP Lib "nsp.dll" Alias "nspsbIntToFloat" _
    (Src As Byte, Dst As Single, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspsbInt16ToFloatP Lib "nsp.dll" Alias "nspsbIntToFloat" _
    (Src As Integer, Dst As Single, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspsbInt32ToFloatP Lib "nsp.dll" Alias "nspsbIntToFloat" _
    (Src As Long, Dst As Single, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspdbInt8ToFloatP Lib "nsp.dll" Alias "nspdbIntToFloat" _
    (Src As Byte, Dst As Double, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspdbInt16ToFloatP Lib "nsp.dll" Alias "nspdbIntToFloat" _
    (Src As Integer, Dst As Double, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspdbInt32ToFloatP Lib "nsp.dll" Alias "nspdbIntToFloat" _
    (Src As Long, Dst As Double, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal flags As Long)
Declare Sub nspsbFloatToFix8P Lib "nsp.dll" Alias "nspsbFloatToFix" _
    (Src As Single, Dst As Byte, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspsbFloatToFix16P Lib "nsp.dll" Alias "nspsbFloatToFix" _
    (Src As Single, Dst As Integer, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)

Declare Sub nspsbFloatToFix32P Lib "nsp.dll" Alias "nspsbFloatToFix" _
    (Src As Single, Dst As Long, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspdbFloatToFix8P Lib "nsp.dll" Alias "nspdbFloatToFix" _
    (Src As Double, Dst As Byte, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspdbFloatToFix16P Lib "nsp.dll" Alias "nspdbFloatToFix" _
    (Src As Double, Dst As Integer, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspdbFloatToFix32P Lib "nsp.dll" Alias "nspdbFloatToFix" _
    (Src As Double, Dst As Long, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
    
Declare Sub nspsbFix8ToFloatP Lib "nsp.dll" Alias "nspsbFixToFloat" _
    (Src As Byte, Dst As Single, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspsbFix16ToFloatP Lib "nsp.dll" Alias "nspsbFixToFloat" _
    (Src As Integer, Dst As Single, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspsbFix32ToFloatP Lib "nsp.dll" Alias "nspsbFixToFloat" _
    (Src As Long, Dst As Single, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspdbFix8ToFloatP Lib "nsp.dll" Alias "nspdbFixToFloat" _
    (Src As Byte, Dst As Double, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspdbFix16ToFloatP Lib "nsp.dll" Alias "nspdbFixToFloat" _
    (Src As Integer, Dst As Double, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)
Declare Sub nspdbFix32ToFloatP Lib "nsp.dll" Alias "nspdbFixToFloat" _
    (Src As Long, Dst As Double, ByVal lenn As Long, _
    ByVal wordSize As Long, ByVal fractBits As Long, ByVal flags As Long)

Declare Sub nspsbFloatToS31FixP Lib "nsp.dll" Alias "nspsbFloatToS31Fix" _
    (Src As Single, Dst As Long, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspdbFloatToS31FixP Lib "nsp.dll" Alias "nspdbFloatToS31Fix" _
    (Src As Double, Dst As Long, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspsbS31FixToFloatP Lib "nsp.dll" Alias "nspsbS31FixToFloat" _
    (Src As Long, Dst As Single, ByVal lenn As Long)
Declare Sub nspdbS31FixToFloatP Lib "nsp.dll" Alias "nspdbS31FixToFloat" _
    (Src As Long, Dst As Double, ByVal lenn As Long)
Declare Sub nspsbFloatToS1516FixP Lib "nsp.dll" Alias "nspsbFloatToS1516Fix" _
    (Src As Single, Dst As Long, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspdbFloatToS1516FixP Lib "nsp.dll" Alias "nspdbFloatToS1516Fix" _
    (Src As Double, Dst As Long, ByVal lenn As Long, ByVal flags As Long)

Declare Sub nspsbS1516FixToFloatP Lib "nsp.dll" Alias "nspsbS1516FixToFloat" _
    (Src As Long, Dst As Single, ByVal lenn As Long)
Declare Sub nspdbS1516FixToFloatP Lib "nsp.dll" Alias "nspdbS1516FixToFloat" _
    (Src As Long, Dst As Double, ByVal lenn As Long)
Declare Sub nspsbFloatToS15FixP Lib "nsp.dll" Alias "nspsbFloatToS15Fix" _
    (Src As Single, Dst As Integer, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspdbFloatToS15FixP Lib "nsp.dll" Alias "nspdbFloatToS15Fix" _
    (Src As Double, Dst As Integer, ByVal lenn As Long, ByVal flags As Long)

Declare Sub nspsbS15FixToFloatP Lib "nsp.dll" Alias "nspsbS15FixToFloat" _
    (Src As Integer, Dst As Single, ByVal lenn As Long)
Declare Sub nspdbS15FixToFloatP Lib "nsp.dll" Alias "nspdbS15FixToFloat" _
    (Src As Integer, Dst As Double, ByVal lenn As Long)

Declare Sub nspsbFloatToS7FixP Lib "nsp.dll" Alias "nspsbFloatToS7Fix" _
    (Src As Single, Dst As Byte, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspdbFloatToS7FixP Lib "nsp.dll" Alias "nspdbFloatToS7Fix" _
    (Src As Double, Dst As Byte, ByVal lenn As Long, ByVal flags As Long)

Declare Sub nspsbS7FixToFloatP Lib "nsp.dll" Alias "nspsbS7FixToFloat" _
    (Src As Byte, Dst As Single, ByVal lenn As Long)
Declare Sub nspdbS7FixToFloatP Lib "nsp.dll" Alias "nspdbS7FixToFloat" _
    (Src As Byte, Dst As Double, ByVal lenn As Long)
'______________Coordinate Conversion Functions____________________
Declare Sub nspcbCartToPolarP Lib "nsp.dll" Alias "nspcbCartToPolar" _
    (Src As SCplx, mag As Single, phase As Single, ByVal lenn As Long)
Declare Sub nspzbCartToPolarP Lib "nsp.dll" Alias "nspzbCartToPolar" _
    (Src As DCplx, mag As Double, phase As Double, ByVal lenn As Long)

Declare Sub nspsbrCartToPolarP Lib "nsp.dll" Alias "nspsbrCartToPolar" _
    (srcReal As Single, srcImag As Single, mag As Single, phase As Single, _
    ByVal lenn As Long)
Declare Sub nspdbrCartToPolarP Lib "nsp.dll" Alias "nspdbrCartToPolar" _
    (srcReal As Double, srcImag As Double, mag As Double, phase As Double, _
    ByVal lenn As Long)

Declare Sub nspcbPolarToCartP Lib "nsp.dll" Alias "nspcbPolarToCart" _
    (mag As Single, phase As Single, Src As SCplx, ByVal lenn As Long)
Declare Sub nspzbPolarToCartP Lib "nsp.dll" Alias "nspzbPolarToCart" _
    (mag As Double, phase As Double, Src As DCplx, ByVal lenn As Long)

Declare Sub nspsbrPolarToCartP Lib "nsp.dll" Alias "nspsbrPolarToCart" _
    (mag As Single, phase As Single, srcReal As Single, srcImag As Single, _
    ByVal lenn As Long)
Declare Sub nspdbrPolarToCartP Lib "nsp.dll" Alias "nspdbrPolarToCart" _
    (mag As Double, phase As Double, srcReal As Double, srcImag As Double, _
    ByVal lenn As Long)
'_____________Companding Functions_________________________________
Declare Sub nspsbMuLawToLinP Lib "nsp.dll" Alias "nspsbMuLawToLin" _
    (Src As Byte, Dst As Single, ByVal lenn As Long)
Declare Sub nspdbMuLawToLinP Lib "nsp.dll" Alias "nspdbMuLawToLin" _
    (Src As Byte, Dst As Double, ByVal lenn As Long)
Declare Sub nspwbMuLawToLinP Lib "nsp.dll" Alias "nspwbMuLawToLin" _
    (Src As Byte, Dst As Integer, ByVal lenn As Long)

Declare Sub nspsbLinToMuLawP Lib "nsp.dll" Alias "nspsbLinToMuLaw" _
    (Src As Single, Dst As Byte, ByVal lenn As Long)
Declare Sub nspdbLinToMuLawP Lib "nsp.dll" Alias "nspdbLinToMuLaw" _
    (Src As Double, Dst As Byte, ByVal lenn As Long)
Declare Sub nspwbLinToMuLawP Lib "nsp.dll" Alias "nspwbLinToMuLaw" _
    (Src As Integer, Dst As Byte, ByVal lenn As Long)

Declare Sub nspsbALawToLinP Lib "nsp.dll" Alias "nspsbALawToLin" _
    (Src As Byte, Dst As Single, ByVal lenn As Long)
Declare Sub nspdbALawToLinP Lib "nsp.dll" Alias "nspdbALawToLin" _
    (Src As Byte, Dst As Double, ByVal lenn As Long)
Declare Sub nspwbALawToLinP Lib "nsp.dll" Alias "nspwbALawToLin" _
    (Src As Byte, Dst As Integer, ByVal lenn As Long)

Declare Sub nspsbLinToALawP Lib "nsp.dll" Alias "nspsbLinToALaw" _
    (Src As Single, Dst As Byte, ByVal lenn As Long)
Declare Sub nspdbLinToALawP Lib "nsp.dll" Alias "nspdbLinToALaw" _
    (Src As Double, Dst As Byte, ByVal lenn As Long)
Declare Sub nspwbLinToALawP Lib "nsp.dll" Alias "nspwbLinToALaw" _
    (Src As Integer, Dst As Byte, ByVal lenn As Long)

Declare Sub nspbMuLawToALawP Lib "nsp.dll" Alias "nspbMuLawToALaw" _
    (Src As Byte, Dst As Byte, ByVal lenn As Long)
Declare Sub nspbALawToMuLawP Lib "nsp.dll" Alias "nspbALawToMuLaw" _
    (Src As Byte, Dst As Byte, ByVal lenn As Long)


'CHAPTER 5.
'Sample-Generating Functions.

Declare Sub nspsbToneP Lib "nsp.dll" Alias "nspsbTone" _
    (statePtr As NSPSToneState, Samps As Single, ByVal SampsLenn As Long)
Declare Sub nspcbToneP Lib "nsp.dll" Alias "nspcbTone" _
    (statePtr As NSPCToneState, Samps As SCplx, ByVal SampsLenn As Long)
Declare Sub nspdbToneP Lib "nsp.dll" Alias "nspdbTone" _
    (statePtr As NSPDToneState, Samps As Double, ByVal SampsLenn As Long)
Declare Sub nspzbToneP Lib "nsp.dll" Alias "nspzbTone" _
    (statePtr As NSPZToneState, Samps As DCplx, ByVal SampsLenn As Long)
Declare Sub nspwbToneP Lib "nsp.dll" Alias "nspwbTone" _
    (statePtr As NSPWToneState, Samps As Integer, ByVal SampsLenn As Long)
Declare Sub nspvbToneP Lib "nsp.dll" Alias "nspvbTone" _
    (statePtr As NSPVToneState, Samps As WCplx, ByVal SampsLenn As Long)
Declare Function nspsTone Lib "nsp.dll" _
    (statePtr As NSPSToneState) As Single
Declare Function nspcTone Lib "nsp.dll" _
    (statePtr As NSPCToneState) As SCplx

Declare Function nspdTone Lib "nsp.dll" _
    (statePtr As NSPDToneState) As Double
Declare Function nspzTone Lib "nsp.dll" _
    (statePtr As NSPZToneState) As DCplx
Declare Function nspwTone Lib "nsp.dll" _
    (statePtr As NSPWToneState) As Integer
Declare Function nspvTone Lib "nsp.dll" _
    (statePtr As NSPVToneState) As WCplx
    
Declare Sub nspsToneInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Single, _
    statePtr As NSPSToneState)
Declare Sub nspcToneInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Single, _
    statePtr As NSPCToneState)
Declare Sub nspdToneInit Lib "nsp.dll" _
    (ByVal rFreq As Double, ByVal phase As Double, ByVal mag As Double, _
    statePtr As NSPDToneState)
Declare Sub nspzToneInit Lib "nsp.dll" _
    (ByVal rFreq As Double, ByVal phase As Double, ByVal mag As Double, _
    statePtr As NSPZToneState)
Declare Sub nspwToneInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Integer, _
    statePtr As NSPWToneState)
Declare Sub nspvToneInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Integer, _
    statePtr As NSPVToneState)
'_________________________________________________________________
Declare Sub nspsbTrnglP Lib "nsp.dll" Alias "nspsbTrngl" _
    (statePtr As NSPSTrnglState, Samps As Single, ByVal SampsLenn As Long)
Declare Sub nspcbTrnglP Lib "nsp.dll" Alias "nspcbTrngl" _
    (statePtr As NSPCTrnglState, Samps As SCplx, ByVal SampsLenn As Long)
Declare Sub nspdbTrnglP Lib "nsp.dll" Alias "nspdbTrngl" _
    (statePtr As NSPDTrnglState, Samps As Double, ByVal SampsLenn As Long)
Declare Sub nspzbTrnglP Lib "nsp.dll" Alias "nspzbTrngl" _
    (statePtr As NSPZTrnglState, Samps As DCplx, ByVal SampsLenn As Long)
Declare Sub nspwbTrnglP Lib "nsp.dll" Alias "nspwbTrngl" _
    (statePtr As NSPWTrnglState, Samps As Integer, ByVal SampsLenn As Long)
Declare Sub nspvbTrnglP Lib "nsp.dll" Alias "nspvbTrngl" _
    (statePtr As NSPVTrnglState, Samps As WCplx, ByVal SampsLenn As Long)
Declare Function nspsTrngl Lib "nsp.dll" _
    (statePtr As NSPSTrnglState) As Single
Declare Function nspcTrngl Lib "nsp.dll" _
    (statePtr As NSPCTrnglState) As SCplx
Declare Function nspdTrngl Lib "nsp.dll" _
    (statePtr As NSPDTrnglState) As Double
Declare Function nspzTrngl Lib "nsp.dll" _
    (statePtr As NSPZTrnglState) As DCplx
Declare Function nspwTrngl Lib "nsp.dll" _
    (statePtr As NSPWTrnglState) As Integer
Declare Function nspvTrngl Lib "nsp.dll" _
    (statePtr As NSPVTrnglState) As WCplx
    
Declare Sub nspsTrnglInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Single, _
    ByVal asym As Single, statePtr As NSPSTrnglState)
Declare Sub nspcTrnglInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Single, _
    ByVal asym As Single, statePtr As NSPCTrnglState)
Declare Sub nspdTrnglInit Lib "nsp.dll" _
    (ByVal rFreq As Double, ByVal phase As Double, ByVal mag As Double, _
    ByVal asym As Double, statePtr As NSPDTrnglState)
Declare Sub nspzTrnglInit Lib "nsp.dll" _
    (ByVal rFreq As Double, ByVal phase As Double, ByVal mag As Double, _
    ByVal asym As Double, statePtr As NSPZTrnglState)
Declare Sub nspwTrnglInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Integer, _
    ByVal asym As Single, statePtr As NSPWTrnglState)
Declare Sub nspvTrnglInit Lib "nsp.dll" _
    (ByVal rFreq As Single, ByVal phase As Single, ByVal mag As Integer, _
    ByVal asym As Single, statePtr As NSPVTrnglState)
'_________________________________________________________________
Declare Sub nspsbRandUniP Lib "nsp.dll" Alias "nspsbRandUni" _
    (statePtr As NSPSRandUniState, Samps As Single, ByVal SampsLenn As Long)
Declare Sub nspcbRandUniP Lib "nsp.dll" Alias "nspcbRandUni" _
    (statePtr As NSPCRandUniState, Samps As SCplx, ByVal SampsLenn As Long)
Declare Sub nspdbRandUniP Lib "nsp.dll" Alias "nspdbRandUni" _
    (statePtr As NSPDRandUniState, Samps As Double, ByVal SampsLenn As Long)
Declare Sub nspzbRandUniP Lib "nsp.dll" Alias "nspzbRandUni" _
    (statePtr As NSPZRandUniState, Samps As DCplx, ByVal SampsLenn As Long)
Declare Sub nspwbRandUniP Lib "nsp.dll" Alias "nspwbRandUni" _
    (statePtr As NSPWRandUniState, Samps As Integer, ByVal SampsLenn As Long)
Declare Sub nspvbRandUniP Lib "nsp.dll" Alias "nspvbRandUni" _
    (statePtr As NSPVRandUniState, Samps As WCplx, ByVal SampsLenn As Long)

Declare Function nspsRandUni Lib "nsp.dll" _
    (statePtr As NSPSRandUniState) As Single
Declare Function nspcRandUni Lib "nsp.dll" _
    (statePtr As NSPCRandUniState) As SCplx
Declare Function nspdRandUni Lib "nsp.dll" _
    (statePtr As NSPDRandUniState) As Double
Declare Function nspzRandUni Lib "nsp.dll" _
    (statePtr As NSPZRandUniState) As DCplx
Declare Function nspwRandUni Lib "nsp.dll" _
    (statePtr As NSPWRandUniState) As Integer
Declare Function nspvRandUni Lib "nsp.dll" _
    (statePtr As NSPVRandUniState) As WCplx

Declare Sub nspsRandUniInit Lib "nsp.dll" _
    (ByVal seed As Single, ByVal low As Single, ByVal high As Single, _
    statePtr As NSPSRandUniState)
Declare Sub nspcRandUniInit Lib "nsp.dll" _
    (ByVal seed As Single, ByVal low As Single, ByVal high As Single, _
    statePtr As NSPCRandUniState)
Declare Sub nspdRandUniInit Lib "nsp.dll" _
    (ByVal seed As Double, ByVal low As Double, ByVal high As Double, _
    statePtr As NSPDRandUniState)
Declare Sub nspzRandUniInit Lib "nsp.dll" _
    (ByVal seed As Double, ByVal low As Double, ByVal high As Double, _
    statePtr As NSPZRandUniState)
Declare Sub nspwRandUniInit Lib "nsp.dll" _
    (ByVal seed As Integer, ByVal low As Integer, ByVal high As Integer, _
    statePtr As NSPWRandUniState)
Declare Sub nspvRandUniInit Lib "nsp.dll" _
    (ByVal seed As Integer, ByVal low As Integer, ByVal high As Integer, _
    statePtr As NSPVRandUniState)

Declare Sub nspsbRandGausP Lib "nsp.dll" Alias "nspsbRandGaus" _
    (statePtr As NSPSRandGausState, Samps As Single, ByVal SampsLenn As Long)
Declare Sub nspcbRandGausP Lib "nsp.dll" Alias "nspcbRandGaus" _
    (statePtr As NSPCRandGausState, Samps As SCplx, ByVal SampsLenn As Long)
Declare Sub nspdbRandGausP Lib "nsp.dll" Alias "nspdbRandGaus" _
    (statePtr As NSPDRandGausState, Samps As Double, ByVal SampsLenn As Long)
Declare Sub nspzbRandGausP Lib "nsp.dll" Alias "nspzbRandGaus" _
    (statePtr As NSPZRandGausState, Samps As DCplx, ByVal SampsLenn As Long)
Declare Sub nspwbRandGausP Lib "nsp.dll" Alias "nspwbRandGaus" _
    (statePtr As NSPWRandGausState, Samps As Integer, ByVal SampsLenn As Long)
Declare Sub nspvbRandGausP Lib "nsp.dll" Alias "nspvbRandGaus" _
    (statePtr As NSPVRandGausState, Samps As WCplx, ByVal SampsLenn As Long)
Declare Function nspsRandGaus Lib "nsp.dll" _
    (statePtr As NSPSRandGausState) As Single
Declare Function nspcRandGaus Lib "nsp.dll" _
    (statePtr As NSPCRandGausState) As SCplx
Declare Function nspdRandGaus Lib "nsp.dll" _
    (statePtr As NSPDRandGausState) As Double
Declare Function nspzRandGaus Lib "nsp.dll" _
    (statePtr As NSPZRandGausState) As DCplx
    
Declare Function nspwRandGaus Lib "nsp.dll" _
    (statePtr As NSPWRandGausState) As Integer
Declare Function nspvRandGaus Lib "nsp.dll" _
    (statePtr As NSPVRandGausState) As WCplx
    
Declare Sub nspsRandGausInit Lib "nsp.dll" _
    (ByVal seed As Single, ByVal mean As Single, ByVal stdDev As Single, _
    statePtr As NSPSRandGausState)
Declare Sub nspcRandGausInit Lib "nsp.dll" _
    (ByVal seed As Single, ByVal mean As Single, ByVal stdDev As Single, _
    statePtr As NSPCRandGausState)
Declare Sub nspdRandGausInit Lib "nsp.dll" _
    (ByVal seed As Double, ByVal mean As Double, ByVal stdDev As Double, _
    statePtr As NSPDRandGausState)
Declare Sub nspzRandGausInit Lib "nsp.dll" _
    (ByVal seed As Double, ByVal mean As Double, ByVal stdDev As Double, _
    statePtr As NSPZRandGausState)
Declare Sub nspwRandGausInit Lib "nsp.dll" _
    (ByVal seed As Integer, ByVal mean As Integer, ByVal stdDev As Integer, _
    statePtr As NSPWRandGausState)
Declare Sub nspvRandGausInit Lib "nsp.dll" _
    (ByVal seed As Integer, ByVal mean As Integer, ByVal stdDev As Integer, _
    statePtr As NSPVRandGausState)



'CHAPTER 6.
'Windowing Functions.

Declare Sub nspsWinBartlettP Lib "nsp.dll" Alias "nspsWinBartlett" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcWinBartlettP Lib "nsp.dll" Alias "nspcWinBartlett" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdWinBartlettP Lib "nsp.dll" Alias "nspdWinBartlett" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzWinBartlettP Lib "nsp.dll" Alias "nspzWinBartlett" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwWinBartlettP Lib "nsp.dll" Alias "nspwWinBartlett" _
    (Vec As Integer, ByVal N As Long)
Declare Sub nspvWinBartlettP Lib "nsp.dll" Alias "nspvWinBartlett" _
    (Vec As WCplx, ByVal N As Long)
    
Declare Sub nspsWinBlackmanP Lib "nsp.dll" Alias "nspsWinBlackman" _
    (Vec As Single, ByVal N As Long, ByVal alpha As Single)
Declare Sub nspcWinBlackmanP Lib "nsp.dll" Alias "nspcWinBlackman" _
    (Vec As SCplx, ByVal N As Long, ByVal alpha As Single)
Declare Sub nspdWinBlackmanP Lib "nsp.dll" Alias "nspdWinBlackman" _
    (Vec As Double, ByVal N As Long, ByVal alpha As Double)
Declare Sub nspzWinBlackmanP Lib "nsp.dll" Alias "nspzWinBlackman" _
    (Vec As DCplx, ByVal N As Long, ByVal alpha As Double)
Declare Sub nspwWinBlackmanP Lib "nsp.dll" Alias "nspwWinBlackman" _
    (Vec As Integer, ByVal N As Long, ByVal alpha As Single)
Declare Sub nspvWinBlackmanP Lib "nsp.dll" Alias "nspvWinBlackman" _
    (Vec As WCplx, ByVal N As Long, ByVal alpha As Single)

Declare Sub nspsWinBlackmanStdP Lib "nsp.dll" Alias "nspsWinBlackmanStd" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcWinBlackmanStdP Lib "nsp.dll" Alias "nspcWinBlackmanStd" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdWinBlackmanStdP Lib "nsp.dll" Alias "nspdWinBlackmanStd" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzWinBlackmanStdP Lib "nsp.dll" Alias "nspzWinBlackmanStd" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwWinBlackmanStdP Lib "nsp.dll" Alias "nspwWinBlackmanStd" _
    (Vec As Integer, ByVal N As Long)
Declare Sub nspvWinBlackmanStdP Lib "nsp.dll" Alias "nspvWinBlackmanStd" _
    (Vec As WCplx, ByVal N As Long)

Declare Sub nspsWinBlackmanOptP Lib "nsp.dll" Alias "nspsWinBlackmanOpt" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcWinBlackmanOptP Lib "nsp.dll" Alias "nspcWinBlackmanOpt" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdWinBlackmanOptP Lib "nsp.dll" Alias "nspdWinBlackmanOpt" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzWinBlackmanOptP Lib "nsp.dll" Alias "nspzWinBlackmanOpt" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwWinBlackmanOptP Lib "nsp.dll" Alias "nspwWinBlackmanOpt" _
    (Vec As Integer, ByVal N As Long)
Declare Sub nspvWinBlackmanOptP Lib "nsp.dll" Alias "nspvWinBlackmanOpt" _
    (Vec As WCplx, ByVal N As Long)

Declare Sub nspsWinHammingP Lib "nsp.dll" Alias "nspsWinHamming" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcWinHammingP Lib "nsp.dll" Alias "nspcWinHamming" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdWinHammingP Lib "nsp.dll" Alias "nspdWinHamming" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzWinHammingP Lib "nsp.dll" Alias "nspzWinHamming" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwWinHammingP Lib "nsp.dll" Alias "nspwWinHamming" _
    (Vec As Integer, ByVal N As Long)
Declare Sub nspvWinHammingP Lib "nsp.dll" Alias "nspvWinHamming" _
    (Vec As WCplx, ByVal N As Long)

Declare Sub nspsWinHannP Lib "nsp.dll" Alias "nspsWinHann" _
    (Vec As Single, ByVal N As Long)
Declare Sub nspcWinHannP Lib "nsp.dll" Alias "nspcWinHann" _
    (Vec As SCplx, ByVal N As Long)
Declare Sub nspdWinHannP Lib "nsp.dll" Alias "nspdWinHann" _
    (Vec As Double, ByVal N As Long)
Declare Sub nspzWinHannP Lib "nsp.dll" Alias "nspzWinHann" _
    (Vec As DCplx, ByVal N As Long)
Declare Sub nspwWinHannP Lib "nsp.dll" Alias "nspwWinHann" _
    (Vec As Integer, ByVal N As Long)
Declare Sub nspvWinHannP Lib "nsp.dll" Alias "nspvWinHann" _
    (Vec As WCplx, ByVal N As Long)

Declare Sub nspsWinKaiserP Lib "nsp.dll" Alias "nspsWinKaiser" _
    (Vec As Single, ByVal N As Long, ByVal beta As Single)
Declare Sub nspcWinKaiserP Lib "nsp.dll" Alias "nspcWinKaiser" _
    (Vec As SCplx, ByVal N As Long, ByVal beta As Single)
Declare Sub nspdWinKaiserP Lib "nsp.dll" Alias "nspdWinKaiser" _
    (Vec As Double, ByVal N As Long, ByVal beta As Double)
Declare Sub nspzWinKaiserP Lib "nsp.dll" Alias "nspzWinKaiser" _
    (Vec As DCplx, ByVal N As Long, ByVal beta As Single)
Declare Sub nspwWinKaiserP Lib "nsp.dll" Alias "nspwWinKaiser" _
    (Vec As Integer, ByVal N As Long, ByVal beta As Single)
Declare Sub nspvWinKaiserP Lib "nsp.dll" Alias "nspvWinKaiser" _
    (Vec As WCplx, ByVal N As Long, ByVal beta As Single)



'CHAPTER 7.
'Fourier and Discrete Cosine Transform Functions.

Declare Sub nspcDftP Lib "nsp.dll" Alias "nspcDft" _
    (inSamps As SCplx, OutSamps As SCplx, ByVal Length As Long, _
    ByVal flags As Long)
Declare Sub nspzDftP Lib "nsp.dll" Alias "nspzDft" _
    (inSamps As DCplx, OutSamps As DCplx, ByVal Length As Long, _
    ByVal flags As Long)
Declare Sub nspvDftP Lib "nsp.dll" Alias "nspvDft" _
    (inSamps As WCplx, OutSamps As WCplx, ByVal Length As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    
Declare Function nspsbGoertzP Lib "nsp.dll" Alias "nspsbGoertz" _
    (stPtr As NSPSGoertzState, inSamps As Single, ByVal lenn As Long) As SCplx
Declare Function nspcbGoertzP Lib "nsp.dll" Alias "nspcbGoertz" _
    (stPtr As NSPCGoertzState, inSamps As SCplx, ByVal lenn As Long) As SCplx
Declare Function nspdbGoertzP Lib "nsp.dll" Alias "nspdbGoertz" _
    (stPtr As NSPDGoertzState, inSamps As Double, ByVal lenn As Long) As DCplx
Declare Function nspzbGoertzP Lib "nsp.dll" Alias "nspzbGoertz" _
    (stPtr As NSPZGoertzState, inSamps As DCplx, ByVal lenn As Long) As DCplx
Declare Function nspwbGoertzP Lib "nsp.dll" Alias "nspwbGoertz" _
    (stPtr As NSPWGoertzState, inSamps As Integer, ByVal lenn As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
Declare Function nspvbGoertzP Lib "nsp.dll" Alias "nspvbGoertz" _
    (stPtr As NSPVGoertzState, inSamps As WCplx, ByVal lenn As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
    
Declare Function nspsGoertz Lib "nsp.dll" _
    (stPtr As NSPSGoertzState, ByVal Sample As Single) As SCplx
Declare Function nspcGoertz Lib "nsp.dll" _
    (stPtr As NSPCGoertzState, ByVal Sample As SCplx) As SCplx
Declare Function nspdGoertz Lib "nsp.dll" _
    (stPtr As NSPDGoertzState, ByVal Sample As Double) As DCplx
Declare Function nspzGoertz Lib "nsp.dll" _
    (stPtr As NSPZGoertzState, ByVal Sample As DCplx) As DCplx
Declare Function nspwGoertz Lib "nsp.dll" _
    (stPtr As NSPWGoertzState, ByVal Sample As Integer) As WCplx
Declare Function nspvGoertz Lib "nsp.dll" _
    (stPtr As NSPVGoertzState, ByVal Sample As WCplx) As WCplx

Declare Sub nspsGoertzInit Lib "nsp.dll" _
    (ByVal freq As Single, stPtr As NSPSGoertzState)
Declare Sub nspcGoertzInit Lib "nsp.dll" _
    (ByVal freq As Single, stPtr As NSPCGoertzState)
Declare Sub nspdGoertzInit Lib "nsp.dll" _
    (ByVal freq As Double, stPtr As NSPDGoertzState)
Declare Sub nspzGoertzInit Lib "nsp.dll" _
    (ByVal freq As Double, stPtr As NSPZGoertzState)
Declare Sub nspwGoertzInit Lib "nsp.dll" _
    (ByVal freq As Single, stPtr As NSPWGoertzState)
Declare Sub nspvGoertzInit Lib "nsp.dll" _
    (ByVal freq As Single, stPtr As NSPVGoertzState)

Declare Sub nspsGoertzReset Lib "nsp.dll" (stPtr As NSPSGoertzState)
Declare Sub nspcGoertzReset Lib "nsp.dll" (stPtr As NSPCGoertzState)
Declare Sub nspdGoertzReset Lib "nsp.dll" (stPtr As NSPDGoertzState)
Declare Sub nspzGoertzReset Lib "nsp.dll" (stPtr As NSPZGoertzState)
Declare Sub nspwGoertzReset Lib "nsp.dll" (stPtr As NSPWGoertzState)
Declare Sub nspvGoertzReset Lib "nsp.dll" (stPtr As NSPVGoertzState)

Declare Sub nspcFftP Lib "nsp.dll" Alias "nspcFft" _
    (Samps As SCplx, ByVal order As Long, ByVal flags As Long)
Declare Sub nspcrFftP Lib "nsp.dll" Alias "nspcrFft" _
    (reSamps As Single, imSamps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspcFftNipP Lib "nsp.dll" Alias "nspcFftNip" _
    (inSamps As SCplx, OutSamps As SCplx, ByVal order As Long, ByVal flags As Long)
Declare Sub nspcrFftNipP Lib "nsp.dll" Alias "nspcrFftNip" _
    (reInSamps As Single, imInSamps As Single, reOutSamps As Single, _
    imOutSamps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspzFftP Lib "nsp.dll" Alias "nspzFft" _
    (Samps As DCplx, ByVal order As Long, ByVal flags As Long)
Declare Sub nspzrFftP Lib "nsp.dll" Alias "nspzrFft" _
    (reSamps As Double, imSamps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspzFftNipP Lib "nsp.dll" Alias "nspzFftNip" _
    (inSamps As DCplx, OutSamps As DCplx, ByVal order As Long, ByVal flags As Long)
Declare Sub nspzrFftNipP Lib "nsp.dll" Alias "nspzrFftNip" _
    (reInSamps As Double, imInSamps As Double, reOutSamps As Double, _
    imOutSamps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspvFftP Lib "nsp.dll" Alias "nspvFft" _
    (Samps As WCplx, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvrFftP Lib "nsp.dll" Alias "nspvrFft" _
    (reSamps As Integer, imSamps As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvFftNipP Lib "nsp.dll" Alias "nspvFftNip" _
    (inSamps As WCplx, OutSamps As WCplx, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspvrFftNipP Lib "nsp.dll" Alias "nspvrFftNip" _
    (reInSamps As Integer, imInSamps As Integer, reOutSamps As Integer, _
    imOutSamps As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsRealFftlP Lib "nsp.dll" Alias "nspsRealFftl" _
    (Samps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspsRealFftlNipP Lib "nsp.dll" Alias "nspsRealFftlNip" _
    (inSamps As Single, OutSamps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdRealFftlP Lib "nsp.dll" Alias "nspdRealFftl" _
    (Samps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdRealFftlNipP Lib "nsp.dll" Alias "nspdRealFftlNip" _
    (inSamps As Double, OutSamps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspwRealFftlP Lib "nsp.dll" Alias "nspwRealFftl" _
    (Samps As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspwRealFftlNipP Lib "nsp.dll" Alias "nspwRealFftlNip" _
    (inSamps As Integer, OutSamps As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsMpyRCPack2P Lib "nsp.dll" Alias "nspsMpyRCPack2" _
    (Src As Single, Dst As Single, ByVal order As Long)
Declare Sub nspdMpyRCPack2P Lib "nsp.dll" Alias "nspdMpyRCPack2" _
    (Src As Double, Dst As Double, ByVal order As Long)
Declare Sub nspwMpyRCPack2P Lib "nsp.dll" Alias "nspwMpyRCPack2" _
    (Src As Integer, Dst As Integer, ByVal order As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsMpyRCPack3P Lib "nsp.dll" Alias "nspsMpyRCPack3" _
    (SrcA As Single, SrcB As Single, Dst As Single, ByVal order As Long)
Declare Sub nspdMpyRCPack3P Lib "nsp.dll" Alias "nspdMpyRCPack3" _
    (SrcA As Double, SrcB As Double, Dst As Double, ByVal order As Long)
Declare Sub nspwMpyRCPack3P Lib "nsp.dll" Alias "nspwMpyRCPack3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal order As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsMpyRCPerm2P Lib "nsp.dll" Alias "nspsMpyRCPerm2" _
    (Src As Single, Dst As Single, ByVal order As Long)
Declare Sub nspdMpyRCPerm2P Lib "nsp.dll" Alias "nspdMpyRCPerm2" _
    (Src As Double, Dst As Double, ByVal order As Long)
Declare Sub nspwMpyRCPerm2P Lib "nsp.dll" Alias "nspwMpyRCPerm2" _
    (Src As Integer, Dst As Integer, ByVal order As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsMpyRCPerm3P Lib "nsp.dll" Alias "nspsMpyRCPerm3" _
    (SrcA As Single, SrcB As Single, Dst As Single, ByVal order As Long)
Declare Sub nspdMpyRCPerm3P Lib "nsp.dll" Alias "nspdMpyRCPerm3" _
    (SrcA As Double, SrcB As Double, Dst As Double, ByVal order As Long)
Declare Sub nspwMpyRCPerm3P Lib "nsp.dll" Alias "nspwMpyRCPerm3" _
    (SrcA As Integer, SrcB As Integer, Dst As Integer, ByVal order As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsCcsFftlP Lib "nsp.dll" Alias "nspsCcsFftl" _
    (Samps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdCcsFftlP Lib "nsp.dll" Alias "nspdCcsFftl" _
    (Samps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspwCcsFftlP Lib "nsp.dll" Alias "nspwCcsFftl" _
    (Samps As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspsCcsFftlNipP Lib "nsp.dll" Alias "nspsCcsFftlNip" _
    (inSamps As Single, OutSamps As Single, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspdCcsFftlNipP Lib "nsp.dll" Alias "nspdCcsFftlNip" _
    (inSamps As Double, OutSamps As Double, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspwCcsFftlNipP Lib "nsp.dll" Alias "nspwCcsFftlNip" _
    (inSamps As Integer, OutSamps As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsRealFftP Lib "nsp.dll" Alias "nspsRealFft" _
    (Samps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspsRealFftNipP Lib "nsp.dll" Alias "nspsReaFftlNip" _
    (inSamps As Single, OutSamps As SCplx, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdRealFftP Lib "nsp.dll" Alias "nspdRealFft" _
    (Samps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdRealFftNipP Lib "nsp.dll" Alias "nspdRealFftNip" _
    (inSamps As Double, OutSamps As DCplx, ByVal order As Long, ByVal flags As Long)
Declare Sub nspwRealFftP Lib "nsp.dll" Alias "nspwRealFft" _
    (Samps As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspwRealFftNipP Lib "nsp.dll" Alias "nspwRealFftNip" _
    (inSamps As Integer, OutSamps As WCplx, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsCcsFftP Lib "nsp.dll" Alias "nspsCcsFft" _
    (Samps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdCcsFftP Lib "nsp.dll" Alias "nspdCcsFft" _
    (Samps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspwCcsFftP Lib "nsp.dll" Alias "nspwCcsFft" _
    (Samps As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspsCcsFftNipP Lib "nsp.dll" Alias "nspsCcsFftNip" _
    (inSamps As SCplx, OutSamps As Single, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspdCcsFftNipP Lib "nsp.dll" Alias "nspdCcsFftNip" _
    (inSamps As DCplx, OutSamps As Double, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspwCcsFftNipP Lib "nsp.dll" Alias "nspwCcsFftNip" _
    (inSamps As WCplx, OutSamps As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsReal2FftP Lib "nsp.dll" Alias "nspsReal2Fft" _
    (xSamps As Single, ySamps As Single, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspsReal2FftNipP Lib "nsp.dll" Alias "nspsReal2FftNip" _
    (xInSamps As Single, xOutSamps As SCplx, yInSamps As Single, yOutSamps As SCplx, _
    ByVal order As Long, ByVal flags As Long)
Declare Sub nspdReal2FftP Lib "nsp.dll" Alias "nspdReal2Fft" _
    (xSamps As Double, ySamps As Double, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspdReal2FftNipP Lib "nsp.dll" Alias "nspdReal2FftNip" _
    (xInSamps As Double, xOutSamps As DCplx, yInSamps As Double, yOutSamps As DCplx, _
    ByVal order As Long, ByVal flags As Long)
Declare Sub nspwReal2FftP Lib "nsp.dll" Alias "nspwReal2Fft" _
    (xSamps As Integer, ySamps As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspwReal2FftNipP Lib "nsp.dll" Alias "nspwReal2FftNip" _
    (xInSamps As Integer, xOutSamps As WCplx, yInSamps As Integer, _
    yOutSamps As WCplx, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspsCcs2FftP Lib "nsp.dll" Alias "nspsCcs2Fft" _
    (xSamps As Single, ySamps As Single, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspdCcs2FftP Lib "nsp.dll" Alias "nspdCcs2Fft" _
    (xSamps As Double, ySamps As Double, ByVal order As Long, _
    ByVal flags As Long)
Declare Sub nspwCcs2FftP Lib "nsp.dll" Alias "nspwCcs2Fft" _
    (xSamps As Integer, ySamps As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspsCcs2FftNipP Lib "nsp.dll" Alias "nspsCcs2FftNip" _
    (xInSamps As SCplx, xOutSamps As Single, yInSamps As SCplx, _
    yOutSamps As Single, ByVal order As Long, ByVal flags As Long)
Declare Sub nspdCcs2FftNipP Lib "nsp.dll" Alias "nspdCcs2FftNip" _
    (xInSamps As DCplx, xOutSamps As Double, yInSamps As DCplx, _
    yOutSamps As Double, ByVal order As Long, ByVal flags As Long)
Declare Sub nspwCcs2FftNipP Lib "nsp.dll" Alias "nspwCcs2FftNip" _
    (xInSamps As WCplx, xOutSamps As Integer, yInSamps As WCplx, _
    yOutSamps As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)

Declare Sub nspFreeBitRevTbls Lib "nsp.dll" ()
Declare Sub nspcFreeTwdTbls Lib "nsp.dll" ()
Declare Sub nspzFreeTwdTbls Lib "nsp.dll" ()
Declare Sub nspvFreeTwdTbls Lib "nsp.dll" ()
'_________________________________________________________________
Declare Sub nspsDctP Lib "nsp.dll" Alias "nspsDct" _
    (Src As Single, Dst As Single, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspdDctP Lib "nsp.dll" Alias "nspdDct" _
    (Src As Double, Dst As Double, ByVal lenn As Long, ByVal flags As Long)
Declare Sub nspwDctP Lib "nsp.dll" Alias "nspwDct" _
    (Src As Integer, Dst As Integer, ByVal lenn As Long, ByVal flags As Long)



'CHAPTER 8.
'Filtering Functions.

Declare Sub nspsFirlInitP Lib "nsp.dll" Alias "nspsFirlInit" _
    (taps As Single, ByVal tapsLenn As Long, tapStPtr As NSPFirTapState)
Declare Sub nspsFirlInitMrP Lib "nsp.dll" Alias "nspsFirlInitMr" _
    (taps As Single, ByVal tapsLenn As Long, ByVal upFactor As Long, _
    ByVal upPhase As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    tapStPtr As NSPFirTapState)
Declare Sub nspsFirlInitDlylP Lib "nsp.dll" Alias "nspsFirlInitDlyl" _
    (tapStPtr As NSPFirTapState, dlyl As Single, dlyStPtr As NSPFirDlyState)
Declare Sub nspcFirlInitP Lib "nsp.dll" Alias "nspcFirlInit" _
    (taps As SCplx, ByVal tapsLenn As Long, tapStPtr As NSPFirTapState)
Declare Sub nspcFirlInitMrP Lib "nsp.dll" Alias "nspcFirlInitMr" _
    (taps As SCplx, ByVal tapsLenn As Long, ByVal upFactor As Long, _
    ByVal upPhase As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    tapStPtr As NSPFirTapState)
Declare Sub nspcFirlInitDlylP Lib "nsp.dll" Alias "nspcFirlInitDlyl" _
    (tapStPtr As NSPFirTapState, dlyl As SCplx, dlyStPtr As NSPFirDlyState)
Declare Sub nspdFirlInitP Lib "nsp.dll" Alias "nspdFirlInit" _
    (taps As Double, ByVal tapsLenn As Long, tapStPtr As NSPFirTapState)
Declare Sub nspdFirlInitMrP Lib "nsp.dll" Alias "nspdFirlInitMr" _
    (taps As Double, ByVal tapsLenn As Long, ByVal upFactor As Long, _
    ByVal upPhase As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    tapStPtr As NSPFirTapState)
Declare Sub nspdFirlInitDlylP Lib "nsp.dll" Alias "nspdFirlInitDlyl" _
    (tapStPtr As NSPFirTapState, dlyl As Double, dlyStPtr As NSPFirDlyState)
Declare Sub nspzFirlInitP Lib "nsp.dll" Alias "nspzFirlInit" _
    (taps As DCplx, ByVal tapsLenn As Long, tapStPtr As NSPFirTapState)
Declare Sub nspzFirlInitMrP Lib "nsp.dll" Alias "nspzFirlInitMr" _
    (taps As DCplx, ByVal tapsLenn As Long, ByVal upFactor As Long, _
    ByVal upPhase As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    tapStPtr As NSPFirTapState)
Declare Sub nspzFirlInitDlylP Lib "nsp.dll" Alias "nspzFirlInitDlyl" _
    (tapStPtr As NSPFirTapState, dlyl As DCplx, dlyStPtr As NSPFirDlyState)
Declare Sub nspwFirlInitP Lib "nsp.dll" Alias "nspwFirlInit" _
    (taps As Integer, ByVal tapsLenn As Long, tapStPtr As NSPFirTapState)
Declare Sub nspwFirlInitMrP Lib "nsp.dll" Alias "nspwFirlInitMr" _
    (taps As Integer, ByVal tapsLenn As Long, ByVal upFactor As Long, _
    ByVal upPhase As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    tapStPtr As NSPFirTapState)
Declare Sub nspwFirlInitDlylP Lib "nsp.dll" Alias "nspwFirlInitDlyl" _
    (tapStPtr As NSPFirTapState, dlyl As Integer, dlyStPtr As NSPFirDlyState)
Declare Function nspsFirl Lib "nsp.dll" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal samp As Single) As Single
Declare Sub nspsbFirlP Lib "nsp.dll" Alias "nspsbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As Single, OutSamps As Single, ByVal numIters As Long)
Declare Function nspcFirlP Lib "nsp.dll" Alias "nspcFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal sampre As Single, ByVal sampim As Single) As SCplx
Declare Sub nspcbFirlP Lib "nsp.dll" Alias "nspcbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As SCplx, OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspscFirl Lib "nsp.dll" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal samp As Single) As SCplx
Declare Sub nspscbFirlP Lib "nsp.dll" Alias "nspscbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As Single, OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspcsFirlP Lib "nsp.dll" Alias "nspcsFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal sampre As Single, ByVal sampim As Single) As SCplx
Declare Sub nspcsbFirlP Lib "nsp.dll" Alias "nspcsbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As SCplx, OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspdFirl Lib "nsp.dll" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal samp As Double) As Double
Declare Sub nspdbFirlP Lib "nsp.dll" Alias "nspdbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As Double, OutSamps As Double, ByVal numIters As Long)
Declare Function nspzFirlP Lib "nsp.dll" Alias "nspzFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal sampre As Double, ByVal sampim As Double) As DCplx
Declare Sub nspzbFirlP Lib "nsp.dll" Alias "nspzbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As DCplx, OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspdzFirl Lib "nsp.dll" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal samp As Double) As DCplx
Declare Sub nspdzbFirlP Lib "nsp.dll" Alias "nspdzbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As Double, OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspzdFirlP Lib "nsp.dll" Alias "nspzdFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal sampre As Double, ByVal sampim As Double) As DCplx
Declare Sub nspzdbFirlP Lib "nsp.dll" Alias "nspzdbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As DCplx, OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspwFirl Lib "nsp.dll" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    ByVal samp As Integer, ByVal ScaleMode As Long, ScaleFactor As Long) _
    As Integer
Declare Sub nspwbFirlP Lib "nsp.dll" Alias "nspwbFirl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps As Integer, OutSamps As Integer, ByVal numIters As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspsFirlGetTapsP Lib "nsp.dll" Alias "nspsFirlGetTaps" _
    (tapStPtr As NSPFirTapState, outTaps As Single)
Declare Sub nspsFirlSetTapsP Lib "nsp.dll" Alias "nspsFirlSetTaps" _
    (inTaps As Single, tapStPtr As NSPFirTapState)
Declare Sub nspcFirlGetTapsP Lib "nsp.dll" Alias "nspcFirlGetTaps" _
    (tapStPtr As NSPFirTapState, outTaps As SCplx)
Declare Sub nspcFirlSetTapsP Lib "nsp.dll" Alias "nspcFirlSetTaps" _
    (inTaps As SCplx, tapStPtr As NSPFirTapState)
Declare Sub nspdFirlGetTapsP Lib "nsp.dll" Alias "nspdFirlGetTaps" _
    (tapStPtr As NSPFirTapState, outTaps As Double)
Declare Sub nspdFirlSetTapsP Lib "nsp.dll" Alias "nspdFirlSetTaps" _
    (inTaps As Double, tapStPtr As NSPFirTapState)
Declare Sub nspzFirlGetTapsP Lib "nsp.dll" Alias "nspzFirlGetTaps" _
    (tapStPtr As NSPFirTapState, outTaps As DCplx)
Declare Sub nspzFirlSetTapsP Lib "nsp.dll" Alias "nspzFirlSetTaps" _
    (inTaps As DCplx, tapStPtr As NSPFirTapState)
Declare Sub nspwFirlGetTapsP Lib "nsp.dll" Alias "nspwFirlGetTaps" _
    (tapStPtr As NSPFirTapState, outTaps As Single)
Declare Sub nspwFirlSetTapsP Lib "nsp.dll" Alias "nspwFirlSetTaps" _
    (inTaps As Single, tapStPtr As NSPFirTapState)
Declare Sub nspsFirlGetDlylP Lib "nsp.dll" Alias "nspsFirlGetDlyl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, outDlyl As Single)
Declare Sub nspsFirlSetDlylP Lib "nsp.dll" Alias "nspsFirlSetDlyl" _
    (tapStPtr As NSPFirTapState, inDlyl As Single, dlyStPtr As NSPFirDlyState)
Declare Sub nspcFirlGetDlylP Lib "nsp.dll" Alias "nspcFirlGetDlyl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, outDlyl As SCplx)
Declare Sub nspcFirlSetDlylP Lib "nsp.dll" Alias "nspcFirlSetDlyl" _
    (tapStPtr As NSPFirTapState, inDlyl As SCplx, dlyStPtr As NSPFirDlyState)
Declare Sub nspdFirlGetDlylP Lib "nsp.dll" Alias "nspdFirlGetDlyl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, outDlyl As Double)
Declare Sub nspdFirlSetDlylP Lib "nsp.dll" Alias "nspdFirlSetDlyl" _
    (tapStPtr As NSPFirTapState, inDlyl As Double, dlyStPtr As NSPFirDlyState)
Declare Sub nspzFirlGetDlylP Lib "nsp.dll" Alias "nspzFirlGetDlyl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, outDlyl As DCplx)
Declare Sub nspzFirlSetDlylP Lib "nsp.dll" Alias "nspzFirlSetDlyl" _
    (tapStPtr As NSPFirTapState, inDlyl As DCplx, dlyStPtr As NSPFirDlyState)
Declare Sub nspwFirlGetDlylP Lib "nsp.dll" Alias "nspwFirlGetDlyl" _
    (tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, outDlyl As Integer)
Declare Sub nspwFirlSetDlylP Lib "nsp.dll" Alias "nspwFirlSetDlyl" _
    (tapStPtr As NSPFirTapState, inDlyl As Integer, dlyStPtr As NSPFirDlyState)
Declare Sub nspsFirInitP Lib "nsp.dll" Alias "nspsFirInit" _
    (tapVals As Single, ByVal tapsLen As Long, dlyVals As Single, _
    statePtr As NSPFirState)
Declare Sub nspsFirInitMrP Lib "nsp.dll" Alias "nspsFirInitMr" _
    (tapVals As Single, ByVal tapsLen As Long, dlyVals As Single, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspcFirInitP Lib "nsp.dll" Alias "nspcFirInit" _
    (tapVals As SCplx, ByVal tapsLen As Long, dlyVals As SCplx, _
    statePtr As NSPFirState)
Declare Sub nspcFirInitMrP Lib "nsp.dll" Alias "nspcFirInitMr" _
    (tapVals As SCplx, ByVal tapsLen As Long, dlyVals As SCplx, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspscFirInitP Lib "nsp.dll" Alias "nspscFirInit" _
    (tapVals As SCplx, ByVal tapsLen As Long, dlyVals As Single, _
    statePtr As NSPFirState)
Declare Sub nspscFirInitMrP Lib "nsp.dll" Alias "nspscFirInitMr" _
    (tapVals As SCplx, ByVal tapsLen As Long, dlyVals As Single, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspcsFirInitP Lib "nsp.dll" Alias "nspcsFirInit" _
    (tapVals As Single, ByVal tapsLen As Long, dlyVals As SCplx, _
    statePtr As NSPFirState)
Declare Sub nspcsFirInitMrP Lib "nsp.dll" Alias "nspcsFirInitMr" _
    (tapVals As Single, ByVal tapsLen As Long, dlyVals As SCplx, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspdFirInitP Lib "nsp.dll" Alias "nspdFirInit" _
    (tapVals As Double, ByVal tapsLen As Long, dlyVals As Double, _
    statePtr As NSPFirState)
Declare Sub nspdFirInitMrP Lib "nsp.dll" Alias "nspdFirInitMr" _
    (tapVals As Double, ByVal tapsLen As Long, dlyVals As Double, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspzFirInitP Lib "nsp.dll" Alias "nspzFirInit" _
    (tapVals As DCplx, ByVal tapsLen As Long, dlyVals As DCplx, _
    statePtr As NSPFirState)
Declare Sub nspzFirInitMrP Lib "nsp.dll" Alias "nspzFirInitMr" _
    (tapVals As DCplx, ByVal tapsLen As Long, dlyVals As DCplx, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspdzFirInitP Lib "nsp.dll" Alias "nspdzFirInit" _
    (tapVals As DCplx, ByVal tapsLen As Long, dlyVals As Double, _
    statePtr As NSPFirState)
Declare Sub nspdzFirInitMrP Lib "nsp.dll" Alias "nspdzFirInitMr" _
    (tapVals As DCplx, ByVal tapsLen As Long, dlyVals As Double, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspzdFirInitP Lib "nsp.dll" Alias "nspzdFirInit" _
    (tapVals As Double, ByVal tapsLen As Long, dlyVals As DCplx, _
    statePtr As NSPFirState)
Declare Sub nspzdFirInitMrP Lib "nsp.dll" Alias "nspzdFirInitMr" _
    (tapVals As Double, ByVal tapsLen As Long, dlyVals As DCplx, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspwFirInitP Lib "nsp.dll" Alias "nspwFirInit" _
    (tapVals As Integer, ByVal tapsLen As Long, dlyVals As Integer, _
    statePtr As NSPFirState)
Declare Sub nspwFirInitMrP Lib "nsp.dll" Alias "nspwFirInitMr" _
    (tapVals As Integer, ByVal tapsLen As Long, dlyVals As Integer, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, statePtr As NSPFirState)
Declare Sub nspFirFree Lib "nsp.dll" (statePtr As NSPFirState)
Declare Function nspsFir Lib "nsp.dll" (statePtr As NSPFirState, _
    ByVal samp As Single) As Single
Declare Sub nspsbFirP Lib "nsp.dll" Alias "nspsbFir" (statePtr As NSPFirState, _
    inSamps As Single, OutSamps As Single, ByVal numIters As Long)
Declare Function nspcFirP Lib "nsp.dll" Alias "nspcFir" _
    (statePtr As NSPFirState, ByVal sampre As Single, ByVal sampim As Single) _
    As SCplx
Declare Sub nspcbFirP Lib "nsp.dll" Alias "nspcbFir" (statePtr As NSPFirState, _
    inSamps As SCplx, OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspscFir Lib "nsp.dll" _
    (statePtr As NSPFirState, ByVal samp As Single) As SCplx
Declare Sub nspscbFirP Lib "nsp.dll" Alias "nspscbFir" (statePtr As NSPFirState, _
    inSamps As Single, OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspcsFirP Lib "nsp.dll" Alias "nspcsFir" _
    (statePtr As NSPFirState, ByVal sampre As Single, ByVal sampim As Single) _
    As SCplx
Declare Sub nspcsbFirP Lib "nsp.dll" Alias "nspcsbFir" (statePtr As NSPFirState, _
    inSamps As SCplx, OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspdFir Lib "nsp.dll" (statePtr As NSPFirState, _
    ByVal samp As Double) As Double
Declare Sub nspdbFirP Lib "nsp.dll" Alias "nspdbFir" (statePtr As NSPFirState, _
    inSamps As Double, OutSamps As Double, ByVal numIters As Long)
Declare Function nspzFirP Lib "nsp.dll" Alias "nspzFir" _
    (statePtr As NSPFirState, ByVal sampre As Double, ByVal sampim As Double) _
    As DCplx
Declare Sub nspzbFirP Lib "nsp.dll" Alias "nspzbFir" (statePtr As NSPFirState, _
    inSamps As DCplx, OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspdzFir Lib "nsp.dll" _
    (statePtr As NSPFirState, ByVal samp As Double) As DCplx
Declare Sub nspdzbFirP Lib "nsp.dll" Alias "nspdzbFir" (statePtr As NSPFirState, _
    inSamps As Double, OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspzdFirP Lib "nsp.dll" Alias "nspzdFir" _
    (statePtr As NSPFirState, ByVal sampre As Double, ByVal sampim As Double) _
    As DCplx
Declare Sub nspzdbFirP Lib "nsp.dll" Alias "nspzdbFir" (statePtr As NSPFirState, _
    inSamps As DCplx, OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspwFir Lib "nsp.dll" (statePtr As NSPFirState, _
    ByVal samp As Integer, ByVal ScaleMode As Long, ScaleFactor As Long) _
    As Integer
Declare Sub nspwbFirP Lib "nsp.dll" Alias "nspwbFir" (statePtr As NSPFirState, _
    inSamps As Integer, OutSamps As Integer, ByVal numIters As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspsFirGetTapsP Lib "nsp.dll" Alias "nspsFirGetTaps" _
    (statePtr As NSPFirState, outTaps As Single)
Declare Sub nspsFirSetTapsP Lib "nsp.dll" Alias "nspsFirSetTaps" _
    (inTaps As Single, statePtr As NSPFirState)
Declare Sub nspcFirGetTapsP Lib "nsp.dll" Alias "nspcFirGetTaps" _
    (statePtr As NSPFirState, outTaps As SCplx)
Declare Sub nspcFirSetTapsP Lib "nsp.dll" Alias "nspcFirSetTaps" _
    (inTaps As SCplx, statePtr As NSPFirState)
Declare Sub nspdFirGetTapsP Lib "nsp.dll" Alias "nspdFirGetTaps" _
    (statePtr As NSPFirState, outTaps As Double)
Declare Sub nspdFirSetTapsP Lib "nsp.dll" Alias "nspdFirSetTaps" _
    (inTaps As Double, statePtr As NSPFirState)
Declare Sub nspzFirGetTapsP Lib "nsp.dll" Alias "nspzFirGetTaps" _
    (statePtr As NSPFirState, outTaps As DCplx)
Declare Sub nspzFirSetTapsP Lib "nsp.dll" Alias "nspzFirSetTaps" _
    (inTaps As DCplx, statePtr As NSPFirState)
Declare Sub nspwFirGetTapsP Lib "nsp.dll" Alias "nspwFirGetTaps" _
    (statePtr As NSPFirState, outTaps As Single)
Declare Sub nspwFirSetTapsP Lib "nsp.dll" Alias "nspwFirSetTaps" _
    (inTaps As Single, statePtr As NSPFirState)
Declare Sub nspsFirGetDlylP Lib "nsp.dll" Alias "nspsFirGetDlyl" _
    (statePtr As NSPFirState, outDlyl As Single)
Declare Sub nspsFirSetDlylP Lib "nsp.dll" Alias "nspsFirSetDlyl" _
    (inDlyl As Single, statePtr As NSPFirState)
Declare Sub nspcFirGetDlylP Lib "nsp.dll" Alias "nspcFirGetDlyl" _
    (statePtr As NSPFirState, outDlyl As SCplx)
Declare Sub nspcFirSetDlylP Lib "nsp.dll" Alias "nspcFirSetDlyl" _
    (inDlyl As SCplx, statePtr As NSPFirState)
Declare Sub nspdFirGetDlylP Lib "nsp.dll" Alias "nspdFirGetDlyl" _
    (statePtr As NSPFirState, outDlyl As Double)
Declare Sub nspdFirSetDlylP Lib "nsp.dll" Alias "nspdFirSetDlyl" _
    (inDlyl As Double, statePtr As NSPFirState)
Declare Sub nspzFirGetDlylP Lib "nsp.dll" Alias "nspzFirGetDlyl" _
    (statePtr As NSPFirState, outDlyl As DCplx)
Declare Sub nspzFirSetDlylP Lib "nsp.dll" Alias "nspzFirSetDlyl" _
    (inDlyl As DCplx, statePtr As NSPFirState)
Declare Sub nspwFirGetDlylP Lib "nsp.dll" Alias "nspwFirGetDlyl" _
    (statePtr As NSPFirState, outDlyl As Integer)
Declare Sub nspwFirSetDlylP Lib "nsp.dll" Alias "nspwFirSetDlyl" _
    (inDlyl As Integer, statePtr As NSPFirState)
    
Declare Sub nspdFirLowpassP Lib "nsp.dll" Alias "nspdFirLowpass" _
    (ByVal rFreq As Double, taps As Double, ByVal tapsLen As Integer, _
    ByVal winType As NSP_WindowType, ByVal doNormal As Integer)

Declare Sub nspdFirHighpassP Lib "nsp.dll" Alias "nspdFirHighpass" _
    (ByVal rFreq As Double, taps As Double, ByVal tapsLen As Integer, _
    ByVal winType As NSP_WindowType, ByVal doNormal As Integer)

Declare Sub nspdFirBandpassP Lib "nsp.dll" Alias "nspdFirBandpass" _
    (ByVal rLowFreq As Double, ByVal rHighFreq As Double, _
    taps As Double, ByVal tapsLen As Integer, _
    ByVal winType As NSP_WindowType, ByVal doNormal As Integer)
Declare Sub nspdFirBandstopP Lib "nsp.dll" Alias "nspdFirBandstop" _
    (ByVal rLowFreq As Double, ByVal rHighFreq As Double, _
    taps As Double, ByVal tapsLen As Integer, _
    ByVal winType As NSP_WindowType, ByVal doNormal As Integer)

'_________________________________________________________________
Declare Sub nspsLmslInitP Lib "nsp.dll" Alias "nspsLmslInit" _
    (ByVal lmsType As Long, taps As Single, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
Declare Sub nspsLmslInitMrP Lib "nsp.dll" Alias "nspsLmslInitMr" _
    (ByVal lmsType As Long, taps As Single, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
Declare Sub nspsLmslInitDlylP Lib "nsp.dll" Alias "nspsLmslInitDlyl" _
    (tapStPtr As NSPLmsTapState, dlyl As Single, ByVal adaptB As Long, _
    dlyStPtr As NSPLmsDlyState)
Declare Sub nspcLmslInitP Lib "nsp.dll" Alias "nspcLmslInit" _
    (ByVal lmsType As Long, taps As SCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
Declare Sub nspcLmslInitMrP Lib "nsp.dll" Alias "nspcLmslInitMr" _
    (ByVal lmsType As Long, taps As SCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
Declare Sub nspcLmslInitDlylP Lib "nsp.dll" Alias "nspcLmslInitDlyl" _
    (tapStPtr As NSPLmsTapState, dlyl As SCplx, ByVal adaptB As Long, _
    dlyStPtr As NSPLmsDlyState)
Declare Sub nspdLmslInitP Lib "nsp.dll" Alias "nspdLmslInit" _
    (ByVal lmsType As Long, taps As Double, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
Declare Sub nspdLmslInitMrP Lib "nsp.dll" Alias "nspdLmslInitMr" _
    (ByVal lmsType As Long, taps As Double, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
Declare Sub nspdLmslInitDlylP Lib "nsp.dll" Alias "nspdLmslInitDlyl" _
    (tapStPtr As NSPLmsTapState, dlyl As Double, ByVal adaptB As Long, _
    dlyStPtr As NSPLmsDlyState)
Declare Sub nspzLmslInitP Lib "nsp.dll" Alias "nspzLmslInit" _
    (ByVal lmsType As Long, taps As DCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
Declare Sub nspzLmslInitMrP Lib "nsp.dll" Alias "nspzLmslInitMr" _
    (ByVal lmsType As Long, taps As DCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
Declare Sub nspzLmslInitDlylP Lib "nsp.dll" Alias "nspzLmslInitDlyl" _
    (tapStPtr As NSPLmsTapState, dlyl As DCplx, ByVal adaptB As Long, _
    dlyStPtr As NSPLmsDlyState)
Declare Sub nspwLmslInitP Lib "nsp.dll" Alias "nspwLmslInit" _
    (ByVal lmsType As Long, taps As Single, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal errDly As Long, tapStPtr As NSPWLmsTapState)
Declare Sub nspwLmslInitDlylP Lib "nsp.dll" Alias "nspwLmslInitDlyl" _
    (tapStPtr As NSPWLmsTapState, dlyl As Integer, dlyStPtr As NSPWLmsDlyState)
Declare Sub nspsLmslGetTapsP Lib "nsp.dll" Alias "nspsLmslGetTaps" _
    (tapStPtr As NSPLmsTapState, outTaps As Single)
Declare Sub nspsLmslSetTapsP Lib "nsp.dll" Alias "nspsLmslSetTaps" _
    (inTaps As Single, tapStPtr As NSPLmsTapState)
Declare Sub nspcLmslGetTapsP Lib "nsp.dll" Alias "nspcLmslGetTaps" _
    (tapStPtr As NSPLmsTapState, outTaps As SCplx)
Declare Sub nspcLmslSetTapsP Lib "nsp.dll" Alias "nspcLmslSetTaps" _
    (inTaps As SCplx, tapStPtr As NSPLmsTapState)
Declare Sub nspdLmslGetTapsP Lib "nsp.dll" Alias "nspdLmslGetTaps" _
    (tapStPtr As NSPLmsTapState, outTaps As Double)
Declare Sub nspdLmslSetTapsP Lib "nsp.dll" Alias "nspdLmslSetTaps" _
    (inTaps As Double, tapStPtr As NSPLmsTapState)
Declare Sub nspzLmslGetTapsP Lib "nsp.dll" Alias "nspzLmslGetTaps" _
    (tapStPtr As NSPLmsTapState, outTaps As DCplx)
Declare Sub nspzLmslSetTapsP Lib "nsp.dll" Alias "nspzLmslSetTaps" _
    (inTaps As DCplx, tapStPtr As NSPLmsTapState)
Declare Sub nspwLmslGetTapsP Lib "nsp.dll" Alias "nspwLmslGetTaps" _
    (tapStPtr As NSPWLmsTapState, outTaps As Single)
Declare Sub nspwLmslSetTapsP Lib "nsp.dll" Alias "nspwLmslSetTaps" _
    (inTaps As Single, tapStPtr As NSPWLmsTapState)
Declare Sub nspsLmslGetDlylP Lib "nsp.dll" Alias "nspsLmslGetDlyl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, outDlyl As Single)
Declare Sub nspsLmslSetDlylP Lib "nsp.dll" Alias "nspsLmslSetDlyl" _
    (tapStPtr As NSPLmsTapState, inDlyl As Single, dlyStPtr As NSPLmsDlyState)
Declare Sub nspcLmslGetDlylP Lib "nsp.dll" Alias "nspcLmslGetDlyl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, outDlyl As SCplx)
Declare Sub nspcLmslSetDlylP Lib "nsp.dll" Alias "nspcLmslSetDlyl" _
    (tapStPtr As NSPLmsTapState, inDlyl As SCplx, dlyStPtr As NSPLmsDlyState)
Declare Sub nspdLmslGetDlylP Lib "nsp.dll" Alias "nspdLmslGetDlyl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, outDlyl As Double)
Declare Sub nspdLmslSetDlylP Lib "nsp.dll" Alias "nspdLmslSetDlyl" _
    (tapStPtr As NSPLmsTapState, inDlyl As Double, dlyStPtr As NSPLmsDlyState)
Declare Sub nspzLmslGetDlylP Lib "nsp.dll" Alias "nspzLmslGetDlyl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, outDlyl As DCplx)
Declare Sub nspzLmslSetDlylP Lib "nsp.dll" Alias "nspzLmslSetDlyl" _
    (tapStPtr As NSPLmsTapState, inDlyl As DCplx, dlyStPtr As NSPLmsDlyState)
Declare Sub nspwLmslGetDlylP Lib "nsp.dll" Alias "nspwLmslGetDlyl" _
    (tapStPtr As NSPWLmsTapState, dlyStPtr As NSPWLmsDlyState, outDlyl As Integer)
Declare Sub nspwLmslSetDlylP Lib "nsp.dll" Alias "nspwLmslSetDlyl" _
    (tapStPtr As NSPWLmsTapState, inDlyl As Integer, dlyStPtr As NSPWLmsDlyState)
Declare Function nspsLmslGetStep Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState) As Single
Declare Sub nspsLmslSetStep Lib "nsp.dll" _
    (ByVal Step As Single, tapStPtr As NSPLmsTapState)
Declare Function nspwLmslGetStep Lib "nsp.dll" _
    (statePtr As NSPWLmsTapState) As Single
Declare Sub nspwLmslSetStep Lib "nsp.dll" _
    (ByVal Step As Single, statePtr As NSPWLmsTapState)
Declare Function nspsLmslGetLeak Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState) As Single
Declare Sub nspsLmslSetLeak Lib "nsp.dll" _
    (ByVal Leak As Single, tapStPtr As NSPLmsTapState)
Declare Function nspsLmsl Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, ByVal samp As Single, _
    ByVal Errr As Single) As Single
Declare Function nspsbLmslP Lib "nsp.dll" Alias "nspsbLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Single, _
    ByVal Errr As Single) As Single
Declare Function nspcLmslP Lib "nsp.dll" Alias "nspcLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal sampre As Single, ByVal sampim As Single, ByVal ErrrRe As Single, _
    ByVal ErrrIm As Single) As SCplx
Declare Function nspcbLmslP Lib "nsp.dll" Alias "nspcbLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As SCplx, _
    ByVal ErrrRe As Single, ByVal ErrrIm As Single) As SCplx
Declare Function nspscLmslP Lib "nsp.dll" Alias "nspscLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal samp As Single, ByVal ErrrRe As Single, ByVal ErrrIm As Single) As SCplx
Declare Function nspscbLmslP Lib "nsp.dll" Alias "nspscbLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Single, _
    ByVal ErrrRe As Single, ByVal ErrrIm As Single) As SCplx
Declare Function nspdLmsl Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, ByVal samp As Double, _
    ByVal Errr As Double) As Double
Declare Function nspdbLmslP Lib "nsp.dll" Alias "nspdbLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Double, _
    ByVal Errr As Double) As Double
Declare Function nspzLmslP Lib "nsp.dll" Alias "nspzLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal sampre As Double, ByVal sampim As Double, _
    ByVal ErrrRe As Double, ByVal ErrrIm As Double) As DCplx
Declare Function nspzbLmslP Lib "nsp.dll" Alias "nspzbLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As DCplx, _
    ByVal ErrrRe As Double, ByVal ErrrIm As Double) As DCplx
Declare Function nspdzLmslP Lib "nsp.dll" Alias "nspdzLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal samp As Double, ByVal ErrrRe As Double, ByVal ErrrIm As Double) As DCplx
Declare Function nspdzbLmslP Lib "nsp.dll" Alias "nspdzbLmsl" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Double, _
    ByVal ErrrRe As Double, ByVal ErrrIm As Double) As DCplx
Declare Function nspwLmsl Lib "nsp.dll" _
    (tapStPtr As NSPWLmsTapState, dlyStPtr As NSPWLmsDlyState, _
    ByVal samp As Integer, ByVal Errr As Integer) As Integer
Declare Function nspsLmslNa Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, ByVal samp As Single) _
    As Single
Declare Sub nspsbLmslNaP Lib "nsp.dll" Alias "nspsbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Single, _
    OutSamps As Single, ByVal numIters As Long)
Declare Function nspcLmslNaP Lib "nsp.dll" Alias "nspcLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal sampre As Single, ByVal sampim As Single) As SCplx
Declare Sub nspcbLmslNaP Lib "nsp.dll" Alias "nspcbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As SCplx, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspscLmslNa Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal samp As Single) As SCplx
Declare Sub nspscbLmslNaP Lib "nsp.dll" Alias "nspscbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Single, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspcsLmslNaP Lib "nsp.dll" Alias "nspcsLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal sampre As Single, ByVal sampim As Single) As SCplx
Declare Sub nspcsbLmslNaP Lib "nsp.dll" Alias "nspcsbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As SCplx, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspdLmslNa Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, ByVal samp As Double) _
    As Double
Declare Sub nspdbLmslNaP Lib "nsp.dll" Alias "nspdbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Double, _
    OutSamps As Double, ByVal numIters As Long)
Declare Function nspzLmslNaP Lib "nsp.dll" Alias "nspzLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal sampre As Double, ByVal sampim As Double) As DCplx
Declare Sub nspzbLmslNaP Lib "nsp.dll" Alias "nspzbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As DCplx, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspdzLmslNa Lib "nsp.dll" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal samp As Double) As DCplx
Declare Sub nspdzbLmslNaP Lib "nsp.dll" Alias "nspdzbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As Double, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspzdLmslNaP Lib "nsp.dll" Alias "nspzdLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    ByVal sampre As Double, ByVal sampim As Double) As DCplx
Declare Sub nspzdbLmslNaP Lib "nsp.dll" Alias "nspzdbLmslNa" _
    (tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, inSamps As DCplx, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Sub nspsLmsInitP Lib "nsp.dll" Alias "nspsLmsInit" _
    (ByVal lmsType As Long, tapVals As Single, ByVal tapsLenn As Long, _
     dlyVals As Single, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, statePtr As NSPLmsState)
Declare Sub nspsLmsInitMrP Lib "nsp.dll" Alias "nspsLmsInitMr" _
    (ByVal lmsType As Long, tapVals As Single, ByVal tapsLenn As Long, _
     dlyVals As Single, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
     statePtr As NSPLmsState)
Declare Sub nspcLmsInitP Lib "nsp.dll" Alias "nspcLmsInit" _
    (ByVal lmsType As Long, tapVals As SCplx, ByVal tapsLenn As Long, _
     dlyVals As SCplx, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, statePtr As NSPLmsState)
Declare Sub nspcLmsInitMrP Lib "nsp.dll" Alias "nspcLmsInitMr" _
    (ByVal lmsType As Long, tapVals As SCplx, ByVal tapsLenn As Long, _
     dlyVals As SCplx, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
     statePtr As NSPLmsState)
Declare Sub nspscLmsInitP Lib "nsp.dll" Alias "nspscLmsInit" _
    (ByVal lmsType As Long, tapVals As SCplx, ByVal tapsLenn As Long, _
     dlyVals As Single, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, statePtr As NSPLmsState)
Declare Sub nspscLmsInitMrP Lib "nsp.dll" Alias "nspscLmsInitMr" _
    (ByVal lmsType As Long, tapVals As SCplx, ByVal tapsLenn As Long, _
     dlyVals As Single, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
     statePtr As NSPLmsState)
Declare Sub nspdLmsInitP Lib "nsp.dll" Alias "nspdLmsInit" _
    (ByVal lmsType As Long, tapVals As Double, ByVal tapsLenn As Long, _
     dlyVals As Double, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, statePtr As NSPLmsState)
Declare Sub nspdLmsInitMrP Lib "nsp.dll" Alias "nspdLmsInitMr" _
    (ByVal lmsType As Long, tapVals As Double, ByVal tapsLenn As Long, _
     dlyVals As Double, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
     statePtr As NSPLmsState)
Declare Sub nspzLmsInitP Lib "nsp.dll" Alias "nspzLmsInit" _
    (ByVal lmsType As Long, tapVals As DCplx, ByVal tapsLenn As Long, _
     dlyVals As DCplx, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, statePtr As NSPLmsState)
Declare Sub nspzLmsInitMrP Lib "nsp.dll" Alias "nspzLmsInitMr" _
    (ByVal lmsType As Long, tapVals As DCplx, ByVal tapsLenn As Long, _
     dlyVals As DCplx, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
     statePtr As NSPLmsState)
Declare Sub nspdzLmsInitP Lib "nsp.dll" Alias "nspdzLmsInit" _
    (ByVal lmsType As Long, tapVals As DCplx, ByVal tapsLenn As Long, _
     dlyVals As Double, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, statePtr As NSPLmsState)
Declare Sub nspdzLmsInitMrP Lib "nsp.dll" Alias "nspdzLmsInitMr" _
    (ByVal lmsType As Long, tapVals As DCplx, ByVal tapsLenn As Long, _
     dlyVals As Double, ByVal Step As Single, ByVal Leak As Single, _
     ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
     statePtr As NSPLmsState)
Declare Sub nspLmsFree Lib "nsp.dll" (statePtr As NSPLmsState)
Declare Function nspsLms Lib "nsp.dll" _
    (statePtr As NSPLmsState, ByVal samp As Single, ByVal Errr As Single) As Single
Declare Function nspsbLmsP Lib "nsp.dll" Alias "nspsbLms" _
    (statePtr As NSPLmsState, inSamps As Single, ByVal Errr As Single) As Single
Declare Function nspcLmsP Lib "nsp.dll" Alias "nspcLms" _
    (statePtr As NSPLmsState, ByVal sampre As Single, ByVal sampim As Single, _
    ByVal ErrrRe As Single, ByVal ErrrIm As Single) As SCplx
Declare Function nspcbLmsP Lib "nsp.dll" Alias "nspcbLms" _
    (statePtr As NSPLmsState, inSamps As SCplx, ByVal ErrrRe As Single, _
    ByVal ErrrIm As Single) As SCplx
Declare Function nspscLmsP Lib "nsp.dll" Alias "nspscLms" _
    (statePtr As NSPLmsState, ByVal samp As Single, _
    ByVal ErrrRe As Single, ByVal ErrrIm As Single) As SCplx
Declare Function nspscbLmsP Lib "nsp.dll" Alias "nspscbLms" _
    (statePtr As NSPLmsState, inSamps As Single, ByVal ErrrRe As Single, _
    ByVal ErrrIm As Single) As SCplx
Declare Function nspdLms Lib "nsp.dll" _
    (statePtr As NSPLmsState, ByVal samp As Double, ByVal Errr As Double) As Double
Declare Function nspdbLmsP Lib "nsp.dll" Alias "nspdbLms" _
    (statePtr As NSPLmsState, inSamps As Double, ByVal Errr As Double) As Double
Declare Function nspzLmsP Lib "nsp.dll" Alias "nspzLms" _
    (statePtr As NSPLmsState, ByVal sampre As Double, ByVal sampim As Double, _
    ByVal ErrrRe As Double, ByVal ErrrIm As Double) As DCplx
Declare Function nspzbLmsP Lib "nsp.dll" Alias "nspzbLms" _
    (statePtr As NSPLmsState, inSamps As DCplx, ByVal ErrrRe As Double, _
    ByVal ErrrIm As Double) As DCplx
Declare Function nspdzLmsP Lib "nsp.dll" Alias "nspdzLms" _
    (statePtr As NSPLmsState, ByVal samp As Double, _
    ByVal ErrrRe As Double, ByVal ErrrIm As Double) As DCplx
Declare Function nspdzbLmsP Lib "nsp.dll" Alias "nspdzbLms" _
    (statePtr As NSPLmsState, inSamps As Double, ByVal ErrrRe As Double, _
    ByVal ErrrIm As Double) As DCplx
Declare Sub nspsLmsGetTapsP Lib "nsp.dll" Alias "nspsLmsGetTaps" _
    (statePtr As NSPLmsState, outTaps As Single)
Declare Sub nspsLmsSetTapsP Lib "nsp.dll" Alias "nspsLmsSetTaps" _
    (inTaps As Single, statePtr As NSPLmsState)
Declare Sub nspcLmsGetTapsP Lib "nsp.dll" Alias "nspcLmsGetTaps" _
    (statePtr As NSPLmsState, outTaps As SCplx)
Declare Sub nspcLmsSetTapsP Lib "nsp.dll" Alias "nspcLmsSetTaps" _
    (inTaps As SCplx, statePtr As NSPLmsState)
Declare Sub nspdLmsGetTapsP Lib "nsp.dll" Alias "nspdLmsGetTaps" _
    (statePtr As NSPLmsState, outTaps As Double)
Declare Sub nspdLmsSetTapsP Lib "nsp.dll" Alias "nspdLmsSetTaps" _
    (inTaps As Double, statePtr As NSPLmsState)
Declare Sub nspzLmsGetTapsP Lib "nsp.dll" Alias "nspzLmsGetTaps" _
    (statePtr As NSPLmsState, outTaps As DCplx)
Declare Sub nspzLmsSetTapsP Lib "nsp.dll" Alias "nspzLmsSetTaps" _
    (inTaps As DCplx, statePtr As NSPLmsState)
Declare Sub nspsLmsGetDlylP Lib "nsp.dll" Alias "nspsLmsGetDlyl" _
    (statePtr As NSPLmsState, outDlyl As Single)
Declare Sub nspsLmsSetDlylP Lib "nsp.dll" Alias "nspsLmsSetDlyl" _
    (inDlyl As Single, statePtr As NSPLmsState)
Declare Sub nspcLmsGetDlylP Lib "nsp.dll" Alias "nspcLmsGetDlyl" _
    (statePtr As NSPLmsState, outDlyl As SCplx)
Declare Sub nspcLmsSetDlylP Lib "nsp.dll" Alias "nspcLmsSetDlyl" _
    (inDlyl As SCplx, statePtr As NSPLmsState)
Declare Sub nspdLmsGetDlylP Lib "nsp.dll" Alias "nspdLmsGetDlyl" _
    (statePtr As NSPLmsState, outDlyl As Double)
Declare Sub nspdLmsSetDlylP Lib "nsp.dll" Alias "nspdLmsSetDlyl" _
    (inDlyl As Double, statePtr As NSPLmsState)
Declare Sub nspzLmsGetDlylP Lib "nsp.dll" Alias "nspzLmsGetDlyl" _
    (statePtr As NSPLmsState, outDlyl As DCplx)
Declare Sub nspzLmsSetDlylP Lib "nsp.dll" Alias "nspzLmsSetDlyl" _
    (inDlyl As DCplx, statePtr As NSPLmsState)
Declare Function nspsLmsGetStep Lib "nsp.dll" (statePtr As NSPLmsState) As Single
Declare Sub nspsLmsSetStep Lib "nsp.dll" _
    (ByVal Step As Single, statePtr As NSPLmsState)
Declare Function nspsLmsGetLeak Lib "nsp.dll" (statePtr As NSPLmsState) As Single
Declare Sub nspsLmsSetLeak Lib "nsp.dll" _
    (ByVal Leak As Single, statePtr As NSPLmsState)
Declare Function nspsLmsDes Lib "nsp.dll" (statePtr As NSPLmsState, _
    ByVal samp As Single, ByVal des As Single) As Single
Declare Sub nspsbLmsDesP Lib "nsp.dll" Alias "nspsbLmsDes" _
    (statePtr As NSPLmsState, inSamps As Single, desSamps As Single, _
    OutSamps As Single, ByVal numIters As Long)
Declare Function nspcLmsDesP Lib "nsp.dll" Alias "nspcLmsDes" _
    (statePtr As NSPLmsState, ByVal sampre As Single, ByVal sampim As Single, _
    ByVal desre As Single, ByVal desim As Single) As SCplx
Declare Sub nspcbLmsDesP Lib "nsp.dll" Alias "nspcbLmsDes" _
    (statePtr As NSPLmsState, inSamps As SCplx, desSamps As SCplx, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspscLmsDesP Lib "nsp.dll" Alias "nspscLmsDes" _
    (statePtr As NSPLmsState, ByVal samp As Single, _
    ByVal desre As Single, ByVal desim As Single) As SCplx
Declare Sub nspscbLmsDesP Lib "nsp.dll" Alias "nspscbLmsDes" _
    (statePtr As NSPLmsState, inSamps As Single, desSamps As SCplx, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspdLmsDes Lib "nsp.dll" (statePtr As NSPLmsState, _
    ByVal samp As Double, ByVal des As Double) As Double
Declare Sub nspdbLmsDesP Lib "nsp.dll" Alias "nspdbLmsDes" _
    (statePtr As NSPLmsState, inSamps As Double, desSamps As Double, _
    OutSamps As Double, ByVal numIters As Long)
Declare Function nspzLmsDesP Lib "nsp.dll" Alias "nspzLmsDes" _
    (statePtr As NSPLmsState, ByVal sampre As Double, ByVal sampim As Double, _
    ByVal desre As Double, ByVal desim As Double) As DCplx
Declare Sub nspzbLmsDesP Lib "nsp.dll" Alias "nspzbLmsDes" _
    (statePtr As NSPLmsState, inSamps As DCplx, desSamps As DCplx, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspdzLmsDesP Lib "nsp.dll" Alias "nspdzLmsDes" _
    (statePtr As NSPLmsState, ByVal samp As Double, _
    ByVal desre As Double, ByVal desim As Double) As DCplx
Declare Sub nspdzbLmsDesP Lib "nsp.dll" Alias "nspdzbLmsDes" _
    (statePtr As NSPLmsState, inSamps As Double, desSamps As DCplx, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspsLmsGetErrVal Lib "nsp.dll" (statePtr As NSPLmsState) As Single
Declare Sub nspsLmsSetErrVal Lib "nsp.dll" _
    (ByVal Errr As Single, statePtr As NSPLmsState)
Declare Function nspcLmsGetErrVal Lib "nsp.dll" (statePtr As NSPLmsState) As SCplx
Declare Sub nspcLmsSetErrValP Lib "nsp.dll" Alias "nspcLmsSetErrVal" _
    (ByVal ErrrRe As Single, ByVal ErrrIm As Single, statePtr As NSPLmsState)
Declare Function nspdLmsGetErrVal Lib "nsp.dll" (statePtr As NSPLmsState) As Double
Declare Sub nspdLmsSetErrVal Lib "nsp.dll" _
    (ByVal Errr As Double, statePtr As NSPLmsState)
Declare Function nspzLmsGetErrVal Lib "nsp.dll" (statePtr As NSPLmsState) As DCplx
Declare Sub nspzLmsSetErrValP Lib "nsp.dll" Alias "nspzLmsSetErrVal" _
    (ByVal ErrrRe As Double, ByVal ErrrIm As Double, statePtr As NSPLmsState)
'_________________________________________________________________
     
     
Declare Sub nspsbMedianFilter1P Lib "nsp.dll" Alias "nspsbMedianFilter1" _
    (InOut As Single, ByVal winLength As Long, ByVal maskSize As Long)
Declare Sub nspdbMedianFilter1P Lib "nsp.dll" Alias "nspdbMedianFilter1" _
    (InOut As Double, ByVal winLength As Long, ByVal maskSize As Long)
Declare Sub nspwbMedianFilter1P Lib "nsp.dll" Alias "nspwbMedianFilter1" _
    (InOut As Integer, ByVal winLength As Long, ByVal maskSize As Long)
    
Declare Sub nspsbMedianFilter2P Lib "nsp.dll" Alias "nspsMedianFilter2" _
    (medIn As Single, medOut As Single, ByVal winLength As Long, _
    ByVal maskSize As Long)
Declare Sub nspdbMedianFilter2P Lib "nsp.dll" Alias "nspsMedianFilter2" _
    (medIn As Double, medOut As Double, ByVal winLength As Long, _
    ByVal maskSize As Long)
Declare Sub nspwbMedianFilter2P Lib "nsp.dll" Alias "nspsMedianFilter2" _
    (medIn As Integer, medOut As Long, ByVal winLength As Long, _
    ByVal maskSize As Long)
'_________________________________________________________________


Declare Sub nspsIirlInitP Lib "nsp.dll" Alias "nspsIirlInit" _
    (ByVal iirType As Long, taps As Single, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspsIirlInitBqP Lib "nsp.dll" Alias "nspsIirlInitBq" _
    (ByVal iirType As Long, taps As Single, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspsIirlInitDlylP Lib "nsp.dll" Alias "nspsIirlInitDlyl" _
    (tapStPtr As NSPIirTapState, dlyl As Single, dlyStPtr As NSPIirDlyState)
Declare Sub nspcIirlInitP Lib "nsp.dll" Alias "nspcIirlInit" _
    (ByVal iirType As Long, taps As SCplx, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspcIirlInitBqP Lib "nsp.dll" Alias "nspcIirlInitBq" _
    (ByVal iirType As Long, taps As SCplx, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspcIirlInitDlylP Lib "nsp.dll" Alias "nspcIirlInitDlyl" _
    (tapStPtr As NSPIirTapState, dlyl As SCplx, dlyStPtr As NSPIirDlyState)
Declare Sub nspdIirlInitP Lib "nsp.dll" Alias "nspdIirlInit" _
    (ByVal iirType As Long, taps As Double, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspdIirlInitBqP Lib "nsp.dll" Alias "nspdIirlInitBq" _
    (ByVal iirType As Long, taps As Double, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspdIirlInitDlylP Lib "nsp.dll" Alias "nspdIirlInitDlyl" _
    (tapStPtr As NSPIirTapState, dlyl As Double, dlyStPtr As NSPIirDlyState)
Declare Sub nspzIirlInitP Lib "nsp.dll" Alias "nspzIirlInit" _
    (ByVal iirType As Long, taps As DCplx, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspzIirlInitBqP Lib "nsp.dll" Alias "nspzIirlInitBq" _
    (ByVal iirType As Long, taps As DCplx, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspzIirlInitDlylP Lib "nsp.dll" Alias "nspzIirlInitDlyl" _
    (tapStPtr As NSPIirTapState, dlyl As DCplx, dlyStPtr As NSPIirDlyState)
Declare Sub nspwIirlInitP Lib "nsp.dll" Alias "nspwIirlInit" _
    (ByVal iirType As Long, taps As Single, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspwIirlInitBqP Lib "nsp.dll" Alias "nspwIirlInitBq" _
    (ByVal iirType As Long, taps As Single, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
Declare Sub nspwIirlInitDlylP Lib "nsp.dll" Alias "nspwIirlInitDlyl" _
    (tapStPtr As NSPIirTapState, dlyl As Long, dlyStPtr As NSPIirDlyState)
Declare Function nspsIirl Lib "nsp.dll" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal samp As Single) _
    As Single
Declare Sub nspsbIirlP Lib "nsp.dll" Alias "nspsbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As Single, _
    OutSamps As Single, ByVal numIters As Long)
Declare Function nspcIirlP Lib "nsp.dll" Alias "nspcIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal sampre As Single, _
    ByVal sampim As Single) As SCplx
Declare Sub nspcbIirlP Lib "nsp.dll" Alias "nspcbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As SCplx, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspscIirl Lib "nsp.dll" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal samp As Single) _
    As SCplx
Declare Sub nspscbIirlP Lib "nsp.dll" Alias "nspscbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As Single, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspcsIirlP Lib "nsp.dll" Alias "nspcsIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal sampre As Single, _
    ByVal sampim As Single) As SCplx
Declare Sub nspcsbIirlP Lib "nsp.dll" Alias "nspcsbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As SCplx, _
    OutSamps As SCplx, ByVal numIters As Long)
Declare Function nspdIirl Lib "nsp.dll" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal samp As Double) _
    As Double
Declare Sub nspdbIirlP Lib "nsp.dll" Alias "nspdbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As Double, _
    OutSamps As Double, ByVal numIters As Long)
Declare Function nspzIirlP Lib "nsp.dll" Alias "nspzIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal sampre As Double, _
    ByVal sampim As Double) As DCplx
Declare Sub nspzbIirlP Lib "nsp.dll" Alias "nspzbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As DCplx, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspdzIirl Lib "nsp.dll" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal samp As Double) _
    As DCplx
Declare Sub nspdzbIirlP Lib "nsp.dll" Alias "nspdzbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As Double, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspzdIirlP Lib "nsp.dll" Alias "nspzdIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal sampre As Double, _
    ByVal sampim As Double) As DCplx
Declare Sub nspzdbIirlP Lib "nsp.dll" Alias "nspzdbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As DCplx, _
    OutSamps As DCplx, ByVal numIters As Long)
Declare Function nspwIirl Lib "nsp.dll" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, ByVal samp As Integer, _
    ByVal ScaleMode As Long, ScaleFactor As Long) As Integer
Declare Sub nspwbIirlP Lib "nsp.dll" Alias "nspwbIirl" _
    (tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, inSamps As Integer, _
    OutSamps As Integer, ByVal numIters As Long, ByVal ScaleMode As Long, _
    ScaleFactor As Long)
Declare Sub nspsIirInitP Lib "nsp.dll" Alias "nspsIirInit" _
    (ByVal iirType As Long, tapVals As Single, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspsIirInitBqP Lib "nsp.dll" Alias "nspsIirInitBq" _
    (ByVal iirType As Long, tapVals As Single, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspcIirInitP Lib "nsp.dll" Alias "nspcIirInit" _
    (ByVal iirType As Long, tapVals As SCplx, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspcIirInitBqP Lib "nsp.dll" Alias "nspcIirInitBq" _
    (ByVal iirType As Long, tapVals As SCplx, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspscIirInitP Lib "nsp.dll" Alias "nspscIirInit" _
    (ByVal iirType As Long, tapVals As SCplx, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspscIirInitBqP Lib "nsp.dll" Alias "nspscIirInitBq" _
    (ByVal iirType As Long, tapVals As SCplx, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspcsIirInitP Lib "nsp.dll" Alias "nspcsIirInit" _
    (ByVal iirType As Long, tapVals As Single, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspcsIirInitBqP Lib "nsp.dll" Alias "nspcsIirInitBq" _
    (ByVal iirType As Long, tapVals As Single, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspdIirInitP Lib "nsp.dll" Alias "nspdIirInit" _
    (ByVal iirType As Long, tapVals As Double, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspdIirInitBqP Lib "nsp.dll" Alias "nspdIirInitBq" _
    (ByVal iirType As Long, tapVals As Double, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspzIirInitP Lib "nsp.dll" Alias "nspzIirInit" _
    (ByVal iirType As Long, tapVals As DCplx, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspzIirInitBqP Lib "nsp.dll" Alias "nspzIirInitBq" _
    (ByVal iirType As Long, tapVals As DCplx, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspdzIirInitP Lib "nsp.dll" Alias "nspdzIirInit" _
    (ByVal iirType As Long, tapVals As DCplx, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspdzIirInitBqP Lib "nsp.dll" Alias "nspdzIirInitBq" _
    (ByVal iirType As Long, tapVals As DCplx, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspzdIirInitP Lib "nsp.dll" Alias "nspzdIirInit" _
    (ByVal iirType As Long, tapVals As Double, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspzdIirInitBqP Lib "nsp.dll" Alias "nspzdIirInitBq" _
    (ByVal iirType As Long, tapVals As Double, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Sub nspIirFree Lib "nsp.dll" (statePtr As NSPIirState)
Declare Sub nspwIirInitP Lib "nsp.dll" Alias "nspwIirInit" _
    (ByVal iirType As Long, tapVals As Single, ByVal order As Long, _
    statePtr As NSPIirState)
Declare Sub nspwIirInitBqP Lib "nsp.dll" Alias "nspwIirInitBq" _
    (ByVal iirType As Long, tapVals As Single, ByVal numQuads As Long, _
    statePtr As NSPIirState)
Declare Function nspsIir Lib "nsp.dll" _
    (statePtr As NSPIirState, ByVal samp As Single) As Single
Declare Sub nspsbIirP Lib "nsp.dll" Alias "nspsbIir" _
    (statePtr As NSPIirState, inSamps As Single, OutSamps As Single, _
    ByVal numIters As Long)
Declare Function nspcIirP Lib "nsp.dll" Alias "nspcIir" _
    (statePtr As NSPIirState, ByVal sampre As Single, ByVal sampim As Single) As SCplx
Declare Sub nspcbIirP Lib "nsp.dll" Alias "nspcbIir" _
    (statePtr As NSPIirState, inSamps As SCplx, OutSamps As SCplx, _
    ByVal numIters As Long)
Declare Function nspscIir Lib "nsp.dll" _
    (statePtr As NSPIirState, ByVal samp As Single) As SCplx
Declare Sub nspscbIirP Lib "nsp.dll" Alias "nspscbIir" _
    (statePtr As NSPIirState, inSamps As Single, OutSamps As SCplx, _
    ByVal numIters As Long)
Declare Function nspcsIirP Lib "nsp.dll" Alias "nspcsIir" _
    (statePtr As NSPIirState, ByVal sampre As Single, ByVal sampim As Single) As SCplx
Declare Sub nspcsbIirP Lib "nsp.dll" Alias "nspcsbIir" _
    (statePtr As NSPIirState, inSamps As SCplx, OutSamps As SCplx, _
    ByVal numIters As Long)
Declare Function nspdIir Lib "nsp.dll" _
    (statePtr As NSPIirState, ByVal samp As Double) As Double
Declare Sub nspdbIirP Lib "nsp.dll" Alias "nspdbIir" _
    (statePtr As NSPIirState, inSamps As Double, OutSamps As Double, _
    ByVal numIters As Long)
Declare Function nspzIirP Lib "nsp.dll" Alias "nspzIir" _
    (statePtr As NSPIirState, ByVal sampre As Double, ByVal sampim As Double) As DCplx
Declare Sub nspzbIirP Lib "nsp.dll" Alias "nspzbIir" _
    (statePtr As NSPIirState, inSamps As DCplx, OutSamps As DCplx, _
    ByVal numIters As Long)
Declare Function nspdzIir Lib "nsp.dll" _
    (statePtr As NSPIirState, ByVal samp As Double) As DCplx
Declare Sub nspdzbIirP Lib "nsp.dll" Alias "nspdzbIir" _
    (statePtr As NSPIirState, inSamps As Double, OutSamps As DCplx, _
    ByVal numIters As Long)
Declare Function nspzdIirP Lib "nsp.dll" Alias "nspzdIir" _
    (statePtr As NSPIirState, ByVal sampre As Double, ByVal sampim As Double) As DCplx
Declare Sub nspzdbIirP Lib "nsp.dll" Alias "nspzdbIir" _
    (statePtr As NSPIirState, inSamps As DCplx, OutSamps As DCplx, _
    ByVal numIters As Long)
Declare Function nspwIir Lib "nsp.dll" _
    (statePtr As NSPIirState, ByVal samp As Integer, ByVal ScaleMode As Long, _
    ScaleFactor As Long) As Integer
Declare Sub nspwbIirP Lib "nsp.dll" Alias "nspwbIir" _
    (statePtr As NSPIirState, inSamps As Integer, OutSamps As Integer, _
    ByVal numIters As Long, ByVal ScaleMode As Long, ScaleFactor As Long)



'CHAPTER 9.
'Convolution Functions.

Declare Sub nspsConvP Lib "nsp.dll" Alias "nspsConv" _
    (X As Single, ByVal xLenn As Long, h As Single, ByVal hLenn As Long, Y As Single)
Declare Sub nspcConvP Lib "nsp.dll" Alias "nspcConv" _
    (X As SCplx, ByVal xLenn As Long, h As SCplx, ByVal hLenn As Long, Y As SCplx)
Declare Sub nspscConvP Lib "nsp.dll" Alias "nspscConv" _
    (X As Single, ByVal xLenn As Long, h As SCplx, ByVal hLenn As Long, Y As SCplx)
Declare Sub nspcsConvP Lib "nsp.dll" Alias "nspcsConv" _
    (X As SCplx, ByVal xLenn As Long, h As Single, ByVal hLenn As Long, Y As SCplx)
Declare Sub nspdConvP Lib "nsp.dll" Alias "nspdConv" _
    (X As Double, ByVal xLenn As Long, h As Double, ByVal hLenn As Long, Y As Double)
Declare Sub nspzConvP Lib "nsp.dll" Alias "nspzConv" _
    (X As DCplx, ByVal xLenn As Long, h As DCplx, ByVal hLenn As Long, Y As DCplx)
Declare Sub nspdzConvP Lib "nsp.dll" Alias "nspdzConv" _
    (X As Double, ByVal xLenn As Long, h As DCplx, ByVal hLenn As Long, Y As DCplx)
Declare Sub nspzdConvP Lib "nsp.dll" Alias "nspzdConv" _
    (X As DCplx, ByVal xLenn As Long, h As Double, ByVal hLenn As Long, Y As DCplx)
Declare Sub nspwConvP Lib "nsp.dll" Alias "nspwConv" _
    (X As Integer, ByVal xLenn As Long, h As Integer, ByVal hLenn As Long, _
    Y As Integer, ByVal ScaleMode As Long, ScaleFactor As Long)
Declare Sub nspsConv2DP Lib "nsp.dll" Alias "nspsConv2D" _
    (X As Single, ByVal xCols As Long, ByVal xRows As Long, h As Single, _
    ByVal hCols As Long, ByVal hRows As Long, Y As Single)
Declare Sub nspdConv2DP Lib "nsp.dll" Alias "nspdConv2D" _
    (X As Double, ByVal xCols As Long, ByVal xRows As Long, h As Double, _
    ByVal hCols As Long, ByVal hRows As Long, Y As Double)
Declare Sub nspwConv2DP Lib "nsp.dll" Alias "nspwConv2D" _
    (X As Integer, ByVal xCols As Long, ByVal xRows As Long, h As Integer, _
    ByVal hCols As Long, ByVal hRows As Long, Y As Integer, ByVal ScaleMode As Long, _
    ScaleFactor As Long)
Declare Sub nspsFilter2DP Lib "nsp.dll" Alias "nspsFilter2D" _
    (X As Single, ByVal xCols As Long, ByVal xRows As Long, h As Single, _
    ByVal hCols As Long, ByVal hRows As Long, Y As Single)
Declare Sub nspdFilter2DP Lib "nsp.dll" Alias "nspdFilter2D" _
    (X As Double, ByVal xCols As Long, ByVal xRows As Long, h As Double, _
    ByVal hCols As Long, ByVal hRows As Long, Y As Double)
Declare Sub nspwFilter2DP Lib "nsp.dll" Alias "nspwFilter2D" _
    (X As Integer, ByVal xCols As Long, ByVal xRows As Long, h As Integer, _
    ByVal hCols As Long, ByVal hRows As Long, Y As Integer, ByVal ScaleMode As Long, ScaleFactor As Long)



'CHAPTER 10.
'Wavelet Functions.

Declare Sub nspsWtInit Lib "nsp.dll" _
    (ByVal par1 As Long, ByVal par2 As Long, ByVal dataOrder As Long, _
    ByVal level As Long, wtstate As NSPWtState, ByVal wtType As Long)
Declare Sub nspdWtInit Lib "nsp.dll" _
    (ByVal par1 As Long, ByVal par2 As Long, ByVal dataOrder As Long, _
    ByVal level As Long, wtstate As NSPWtState, ByVal wtType As Long)
Declare Sub nspwWtInit Lib "nsp.dll" _
    (ByVal par1 As Long, ByVal par2 As Long, ByVal dataOrder As Long, _
    ByVal level As Long, wtstate As NSPWtState, ByVal wtType As Long)
Declare Sub nspsWtInitLen Lib "nsp.dll" _
    (ByVal par1 As Long, ByVal par2 As Long, ByVal Length As Long, _
    ByVal level As Long, wtstate As NSPWtState, ByVal wtType As Long, _
    len_dec As Long)
Declare Sub nspdWtInitLen Lib "nsp.dll" _
    (ByVal par1 As Long, ByVal par2 As Long, ByVal Length As Long, _
    ByVal level As Long, wtstate As NSPWtState, ByVal wtType As Long, _
    len_dec As Long)
Declare Sub nspwWtInitLen Lib "nsp.dll" _
    (ByVal par1 As Long, ByVal par2 As Long, ByVal Length As Long, _
    ByVal level As Long, wtstate As NSPWtState, ByVal wtType As Long, _
    len_dec As Long)
Declare Sub nspdWtSetStateP Lib "nsp.dll" Alias "nspdWtSetState" _
    (wtstate As NSPWtState, ByVal wtType As Long, ByVal par1 As Long, _
    ByVal par2 As Long, ByVal dataOrder As Long, ByVal level As Long, _
    TapsArr As Long, Flen As Long, Fofs As Long)
Declare Sub nspsWtSetStateP Lib "nsp.dll" Alias "nspsWtSetState" _
    (wtstate As NSPWtState, ByVal wtType As Long, ByVal par1 As Long, _
    ByVal par2 As Long, ByVal dataOrder As Long, ByVal level As Long, _
    TapsArr As Long, Flen As Long, Fofs As Long)
Declare Sub nspwWtSetStateP Lib "nsp.dll" Alias "nspwWtSetState" _
    (wtstate As NSPWtState, ByVal wtType As Long, ByVal par1 As Long, _
    ByVal par2 As Long, ByVal dataOrder As Long, ByVal level As Long, _
    TapsArr As Long, Flen As Long, Fofs As Long)
Declare Sub nspsWtGetStateP Lib "nsp.dll" Alias "nspsWtGetState" _
    (wtstate As NSPWtState, wtType As Long, par1 As Long, par2 As Long, _
    dataOrder As Long, level As Long, TapsArr As Long, _
    Flen As Long, Fofs As Long)
Declare Sub nspdWtGetStateP Lib "nsp.dll" Alias "nspdWtGetState" _
    (wtstate As NSPWtState, wtType As Long, par1 As Long, par2 As Long, _
    dataOrder As Long, level As Long, TapsArr As Long, _
    Flen As Long, Fofs As Long)
Declare Sub nspwWtGetStateP Lib "nsp.dll" Alias "nspwWtGetState" _
    (wtstate As NSPWtState, wtType As Long, par1 As Long, par2 As Long, _
    dataOrder As Long, level As Long, TapsArr As Long, _
    Flen As Long, Fofs As Long)
Declare Sub nspsWtInitUserFilterP Lib "nsp.dll" Alias "nspsWtInitUserFilter" _
    (TapsArr As Long, Flen As Long, Fofs As Long, ByVal Length As Long, _
    ByVal level As Long, wtstate As NSPWtState, len_dec As Long)
Declare Sub nspdWtInitUserFilterP Lib "nsp.dll" Alias "nspdWtInitUserFilter" _
    (TapsArr As Long, Flen As Long, Fofs As Long, ByVal Length As Long, _
    ByVal level As Long, wtstate As NSPWtState, len_dec As Long)
Declare Sub nspwWtInitUserFilterP Lib "nsp.dll" Alias "nspwWtInitUserFilter" _
    (TapsArr As Long, Flen As Long, Fofs As Long, ByVal Length As Long, _
    ByVal level As Long, wtstate As NSPWtState, len_dec As Long)
Declare Sub nspsWtDecomposeP Lib "nsp.dll" Alias "nspsWtDecompose" _
    (wtstate As NSPWtState, Src As Single, Dst As Single)
Declare Sub nspdWtDecomposeP Lib "nsp.dll" Alias "nspdWtDecompose" _
    (wtstate As NSPWtState, Src As Double, Dst As Double)
Declare Sub nspwWtDecomposeP Lib "nsp.dll" Alias "nspwWtDecompose" _
    (wtstate As NSPWtState, Src As Integer, Dst As Integer)
Declare Sub nspsWtReconstructP Lib "nsp.dll" Alias "nspsWtReconstruct" _
    (wtstate As NSPWtState, Src As Single, Dst As Single)
Declare Sub nspdWtReconstructP Lib "nsp.dll" Alias "nspdWtReconstruct" _
    (wtstate As NSPWtState, Src As Double, Dst As Double)
Declare Sub nspwWtReconstructP Lib "nsp.dll" Alias "nspwWtReconstruct" _
    (wtstate As NSPWtState, Src As Integer, Dst As Integer)
Declare Sub nspWtFree Lib "nsp.dll" (wtstate As NSPWtState)



'CHAPTER 11.
'Library Information

Declare Function nspGetLibVersionVBP Lib "LibVers.dll" _
    Alias "_nspGetLibVersionVB@0" () As NSPLibVersion
    
'_________________________________________________________________
'___________________________Implementation________________________

'CHAPTER 3.
'Arithmetic and Vector Manipulation Functions.

Function nspcAdd(CompA As SCplx, CompB As SCplx) As SCplx
    nspcAdd = nspcAddP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspzAdd(CompA As DCplx, CompB As DCplx) As DCplx
    nspzAdd = nspzAddP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspvAdd(CompA As WCplx, CompB As WCplx, ByVal ScaleMode As Long, _
    ScaleFactor As Long) As WCplx
    nspvAdd = nspvAddP(CompA.re, CompA.im, CompB.re, CompB.im, ScaleMode, ScaleFactor)
End Function
Function nspcConj(CompA As SCplx) As SCplx
    nspcConj = nspcConjP(CompA.re, CompA.im)
End Function
Function nspzConj(CompA As DCplx) As DCplx
    nspzConj = nspzConjP(CompA.re, CompA.im)
End Function
Function nspvConj(CompA As WCplx) As WCplx
    nspvConj = nspvConjP(CompA.re, CompA.im)
End Function
Function nspcDiv(CompA As SCplx, CompB As SCplx) As SCplx
    nspcDiv = nspcDivP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspzDiv(CompA As DCplx, CompB As DCplx) As DCplx
    nspzDiv = nspzDivP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspvDiv(CompA As WCplx, CompB As WCplx) As WCplx
    nspvDiv = nspvDivP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspcMpy(CompA As SCplx, CompB As SCplx) As SCplx
    nspcMpy = nspcMpyP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspzMpy(CompA As DCplx, CompB As DCplx) As DCplx
    nspzMpy = nspzMpyP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspvMpy(CompA As WCplx, CompB As WCplx, ByVal ScaleMode As Long, _
    ScaleFactor As Long) As WCplx
    nspvMpy = nspvMpyP(CompA.re, CompA.im, CompB.re, CompB.im, ScaleMode, ScaleFactor)
End Function
Function nspcSub(CompA As SCplx, CompB As SCplx) As SCplx
    nspcSub = nspcSubP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspzSub(CompA As DCplx, CompB As DCplx) As DCplx
    nspzSub = nspzSubP(CompA.re, CompA.im, CompB.re, CompB.im)
End Function
Function nspvSub(CompA As WCplx, CompB As WCplx, ByVal ScaleMode As Long, _
    ScaleFactor As Long) As WCplx
    nspvSub = nspvSubP(CompA.re, CompA.im, CompB.re, CompB.im, ScaleMode, ScaleFactor)
End Function
Sub nspsbCopy(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbCopyP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbCopy(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbCopyP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbCopy(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbCopyP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbCopy(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbCopyP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbCopy(Src() As Integer, Dst() As Integer, ByVal N As Long)
     Call nspwbCopyP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbCopy(Src() As WCplx, Dst() As WCplx, ByVal N As Long)
     Call nspvbCopyP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspsbSet(ByVal Vall As Single, Dst() As Single, ByVal N As Long)
     Call nspsbSetP(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspcbSet(ByVal re As Single, ByVal im As Single, Dst() As SCplx, ByVal N As Long)
     Call nspcbSetP(re, im, Dst(LBound(Dst)), N)
End Sub
Sub nspdbSet(ByVal Vall As Double, Dst() As Double, ByVal N As Long)
     Call nspdbSetP(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspzbSet(ByVal re As Double, ByVal im As Double, Dst() As DCplx, ByVal N As Long)
     Call nspzbSetP(re, im, Dst(LBound(Dst)), N)
End Sub
Sub nspwbSet(ByVal Vall As Integer, Dst() As Integer, ByVal N As Long)
     Call nspwbSetP(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspvbSet(ByVal re As Integer, ByVal im As Integer, Dst() As WCplx, _
    ByVal N As Long)
     Call nspvbSetP(re, im, Dst(LBound(Dst)), N)
End Sub
Sub nspsbZero(Dst() As Single, ByVal N As Long)
     Call nspsbZeroP(Dst(LBound(Dst)), N)
End Sub
Sub nspcbZero(Dst() As SCplx, ByVal N As Long)
     Call nspcbZeroP(Dst(LBound(Dst)), N)
End Sub
Sub nspdbZero(Dst() As Double, ByVal N As Long)
     Call nspdbZeroP(Dst(LBound(Dst)), N)
End Sub
Sub nspzbZero(Dst() As DCplx, ByVal N As Long)
     Call nspzbZeroP(Dst(LBound(Dst)), N)
End Sub
Sub nspwbZero(Dst() As Integer, ByVal N As Long)
     Call nspwbZeroP(Dst(LBound(Dst)), N)
End Sub
Sub nspvbZero(Dst() As WCplx, ByVal N As Long)
     Call nspvbZeroP(Dst(LBound(Dst)), N)
End Sub
Sub nspsbAdd1(ByVal Vall As Single, Dst() As Single, ByVal N As Long)
     Call nspsbAdd1P(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspcbAdd1(Vall As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbAdd1P(Vall.re, Vall.im, Dst(LBound(Dst)), N)
End Sub
Sub nspdbAdd1(ByVal Vall As Double, Dst() As Double, ByVal N As Long)
     Call nspdbAdd1P(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspzbAdd1(Vall As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbAdd1P(Vall.re, Vall.im, Dst(LBound(Dst)), N)
End Sub
Sub nspwbAdd1(ByVal Vall As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbAdd1P(Vall, Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbAdd1(Vall As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbAdd1P(Vall.re, Vall.im, Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbAdd2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbAdd2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbAdd2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbAdd2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbAdd2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbAdd2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbAdd2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbAdd2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbAdd2(Src() As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbAdd2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspvbAdd2(Src() As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbAdd2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsbAdd3(SrcA() As Single, SrcB() As Single, Dst() As Single, _
    ByVal N As Long)
     Call nspsbAdd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbAdd3(SrcA() As SCplx, SrcB() As SCplx, Dst() As SCplx, _
    ByVal N As Long)
     Call nspcbAdd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbAdd3(SrcA() As Double, SrcB() As Double, Dst() As Double, _
    ByVal N As Long)
     Call nspdbAdd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbAdd3(SrcA() As DCplx, SrcB() As DCplx, Dst() As DCplx, _
    ByVal N As Long)
     Call nspzbAdd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbAdd3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbAdd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), _
     N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbAdd3(SrcA() As WCplx, SrcB() As WCplx, Dst() As WCplx, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbAdd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), _
     N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbMpy1(ByVal Vall As Single, Dst() As Single, ByVal N As Long)
     Call nspsbMpy1P(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspcbMpy1(Vall As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbMpy1P(Vall.re, Vall.im, Dst(LBound(Dst)), N)
End Sub
Sub nspdbMpy1(ByVal Vall As Double, Dst() As Double, ByVal N As Long)
     Call nspdbMpy1P(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspzbMpy1(Vall As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbMpy1P(Vall.re, Vall.im, Dst(LBound(Dst)), N)
End Sub
Sub nspwbMpy1(ByVal Vall As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbMpy1P(Vall, Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbMpy1(Vall As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbMpy1P(Vall.re, Vall.im, Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbMpy2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbMpy2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbMpy2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbMpy2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbMpy2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbMpy2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbMpy2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbMpy2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbMpy2(Src() As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbMpy2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspvbMpy2(Src() As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbMpy2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsbMpy3(SrcA() As Single, SrcB() As Single, Dst() As Single, _
    ByVal N As Long)
     Call nspsbMpy3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbMpy3(SrcA() As SCplx, SrcB() As SCplx, Dst() As SCplx, _
    ByVal N As Long)
     Call nspcbMpy3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbMpy3(SrcA() As Double, SrcB() As Double, Dst() As Double, _
    ByVal N As Long)
     Call nspdbMpy3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbMpy3(SrcA() As DCplx, SrcB() As DCplx, Dst() As DCplx, _
    ByVal N As Long)
     Call nspzbMpy3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbMpy3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbMpy3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), _
     N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbMpy3(SrcA() As WCplx, SrcB() As WCplx, Dst() As WCplx, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbMpy3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), _
     N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbSub1(ByVal Vall As Single, Dst() As Single, ByVal N As Long)
     Call nspsbSub1P(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspcbSub1(Vall As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbSub1P(Vall.re, Vall.im, Dst(LBound(Dst)), N)
End Sub
Sub nspdbSub1(ByVal Vall As Double, Dst() As Double, ByVal N As Long)
     Call nspdbSub1P(Vall, Dst(LBound(Dst)), N)
End Sub
Sub nspzbSub1(Vall As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbSub1P(Vall.re, Vall.im, Dst(LBound(Dst)), N)
End Sub
Sub nspwbSub1(ByVal Vall As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbSub1P(Vall, Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbSub1(Vall As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbSub1P(Vall.re, Vall.im, Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbSub2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbSub2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbSub2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbSub2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbSub2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbSub2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbSub2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbSub2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbSub2(Src() As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbSub2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspvbSub2(Src() As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbSub2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsbSub3(Src() As Single, Vall() As Single, Dst() As Single, _
    ByVal N As Long)
     Call nspsbSub3P(Src(LBound(Src)), Vall(LBound(Vall)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbSub3(SrcA() As SCplx, SrcB() As SCplx, Dst() As SCplx, _
    ByVal N As Long)
     Call nspcbSub3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbSub3(Src() As Double, Vall() As Double, Dst() As Double, _
    ByVal N As Long)
     Call nspdbSub3P(Src(LBound(Src)), Vall(LBound(Vall)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbSub3(SrcA() As DCplx, SrcB() As DCplx, Dst() As DCplx, _
    ByVal N As Long)
     Call nspzbSub3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbSub3(Src() As Integer, Vall() As Integer, Dst() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbSub3P(Src(LBound(Src)), Vall(LBound(Vall)), Dst(LBound(Dst)), _
     N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbSub3(SrcA() As WCplx, SrcB() As WCplx, Dst() As WCplx, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbSub3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), _
     N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbNormalize(Src() As Single, Dst() As Single, ByVal N As Long, _
    ByVal Offset As Single, ByVal factor As Single)
    Call nspsbNormalizeP(Src(LBound(Src)), Dst(LBound(Dst)), N, Offset, factor)
End Sub
Sub nspcbNormalize(Src() As SCplx, Dst() As SCplx, ByVal N As Long, _
    Offset As SCplx, ByVal factor As Single)
    Call nspcbNormalizeP(Src(LBound(Src)), Dst(LBound(Dst)), N, Offset.re, Offset.im, _
    factor)
End Sub
Sub nspdbNormalize(Src() As Double, Dst() As Double, ByVal N As Long, _
    ByVal Offset As Double, ByVal factor As Single)
    Call nspdbNormalizeP(Src(LBound(Src)), Dst(LBound(Dst)), N, Offset, factor)
End Sub
Sub nspzbNormalize(Src() As DCplx, Dst() As DCplx, ByVal N As Long, _
    Offset As DCplx, ByVal factor As Single)
    Call nspzbNormalizeP(Src(LBound(Src)), Dst(LBound(Dst)), N, Offset.re, Offset.im, _
    factor)
End Sub
Sub nspwbNormalize(Src() As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal Offset As Integer, ByVal factor As Single)
    Call nspwbNormalizeP(Src(LBound(Src)), Dst(LBound(Dst)), N, Offset, factor)
End Sub
Sub nspvbNormalize(Src() As WCplx, Dst() As WCplx, ByVal N As Long, _
    Offset As WCplx, ByVal factor As Single)
    Call nspvbNormalizeP(Src(LBound(Src)), Dst(LBound(Dst)), N, Offset.re, Offset.im, _
    factor)
End Sub
Function nspsDotProd(Vec1() As Single, Vec2() As Single, ByVal N As Long) _
    As Single
     nspsDotProd = nspsDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspcDotProd(Vec1() As SCplx, Vec2() As SCplx, ByVal N As Long) As SCplx
     nspcDotProd = nspcDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspscDotProd(Vec1() As Single, Vec2() As SCplx, ByVal N As Long) As SCplx
     nspscDotProd = nspscDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspcsDotProd(Vec1() As SCplx, Vec2() As Single, ByVal N As Long) As SCplx
     nspcsDotProd = nspcsDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspdDotProd(Vec1() As Double, Vec2() As Double, ByVal N As Long) _
    As Double
     nspdDotProd = nspdDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspzDotProd(Vec1() As DCplx, Vec2() As DCplx, ByVal N As Long) As DCplx
     nspzDotProd = nspzDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspdzDotProd(Vec1() As Double, Vec2() As DCplx, ByVal N As Long) As DCplx
     nspdzDotProd = nspdzDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspzdDotProd(Vec1() As DCplx, Vec2() As Double, ByVal N As Long) As DCplx
     nspzdDotProd = nspzdDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N)
End Function
Function nspwDotProd(Vec1() As Integer, Vec2() As Integer, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long) As Integer
     nspwDotProd = nspwDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N, _
     ScaleMode, ScaleFactor)
End Function
Function nspvDotProd(Vec1() As WCplx, Vec2() As WCplx, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
     nspvDotProd = nspvDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N, _
     ScaleMode, ScaleFactor)
End Function
'***********
 Function nspwvDotProd(Vec1() As Integer, Vec2() As WCplx, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
     nspwvDotProd = nspwvDotProdP(Vec1(LBound(Vec1)), Vec2(LBound(Vec2)), N, _
     ScaleMode, ScaleFactor)
 End Function



Sub nspsbThresh1(Vec() As Single, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
    Call nspsbThresh1P(Vec(LBound(Vec)), N, Thresh, re10p)
End Sub
Sub nspcbThresh1(Vec() As SCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
    Call nspcbThresh1P(Vec(LBound(Vec)), N, Thresh, re10p)
End Sub
Sub nspdbThresh1(Vec() As Double, ByVal N As Long, ByVal Thresh As Double, _
    ByVal re10p As Long)
    Call nspdbThresh1P(Vec(LBound(Vec)), N, Thresh, re10p)
End Sub
Sub nspzbThresh1(Vec() As DCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
    Call nspzbThresh1P(Vec(LBound(Vec)), N, Thresh, re10p)
End Sub
Sub nspwbThresh1(Vec() As Integer, ByVal N As Long, ByVal Thresh As Integer, _
    ByVal re10p As Long)
    Call nspwbThresh1P(Vec(LBound(Vec)), N, Thresh, re10p)
End Sub
Sub nspvbThresh1(Vec() As WCplx, ByVal N As Long, ByVal Thresh As Single, _
    ByVal re10p As Long)
    Call nspvbThresh1P(Vec(LBound(Vec)), N, Thresh, re10p)
End Sub
Sub nspsbThresh2(Src() As Single, Dst() As Single, ByVal N As Long, _
    ByVal Thresh As Single, ByVal re10p As Long)
    Call nspsbThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh, re10p)
End Sub
Sub nspcbThresh2(Src() As SCplx, Dst() As SCplx, ByVal N As Long, _
    ByVal Thresh As Single, ByVal re10p As Long)
    Call nspcbThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh, re10p)
End Sub
Sub nspdbThresh2(Src() As Double, Dst() As Double, ByVal N As Long, _
    ByVal Thresh As Double, ByVal re10p As Long)
    Call nspdbThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh, re10p)
End Sub
Sub nspzbThresh2(Src() As DCplx, Dst() As DCplx, ByVal N As Long, _
    ByVal Thresh As Double, ByVal re10p As Long)
    Call nspzbThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh, re10p)
End Sub
Sub nspwbThresh2(Src() As Integer, Dst() As Integer, ByVal N As Long, _
    ByVal Thresh As Integer, ByVal re10p As Long)
    Call nspwbThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh, re10p)
End Sub
Sub nspvbThresh2(Src() As WCplx, Dst() As WCplx, ByVal N As Long, _
    ByVal Thresh As Integer, ByVal re10p As Long)
    Call nspvbThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh, re10p)
End Sub
Sub nspsbInvThresh1(Vec() As Single, ByVal N As Long, ByVal Thresh As Single)
    Call nspsbInvThresh1P(Vec(LBound(Vec)), N, Thresh)
End Sub
Sub nspcbInvThresh1(Vec() As SCplx, ByVal N As Long, ByVal Thresh As Single)
    Call nspcbInvThresh1P(Vec(LBound(Vec)), N, Thresh)
End Sub
Sub nspdbInvThresh1(Vec() As Double, ByVal N As Long, ByVal Thresh As Double)
    Call nspdbInvThresh1P(Vec(LBound(Vec)), N, Thresh)
End Sub
Sub nspzbInvThresh1(Vec() As DCplx, ByVal N As Long, ByVal Thresh As Double)
    Call nspzbInvThresh1P(Vec(LBound(Vec)), N, Thresh)
End Sub
Sub nspsbInvThresh2(Src() As Single, Dst() As Single, ByVal N As Long, _
    ByVal Thresh As Single)
    Call nspsbInvThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh)
End Sub
Sub nspcbInvThresh2(Src() As SCplx, Dst() As SCplx, ByVal N As Long, _
    ByVal Thresh As Single)
    Call nspcbInvThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh)
End Sub
Sub nspdbInvThresh2(Src() As Double, Dst() As Double, ByVal N As Long, _
    ByVal Thresh As Double)
    Call nspdbInvThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh)
End Sub
Sub nspzbInvThresh2(Src() As DCplx, Dst() As DCplx, ByVal N As Long, _
    ByVal Thresh As Double)
    Call nspzbInvThresh2P(Src(LBound(Src)), Dst(LBound(Dst)), N, Thresh)
End Sub
Sub nspsbAbs1(Vec() As Single, ByVal N As Long)
     Call nspsbAbs1P(Vec(LBound(Vec)), N)
End Sub
Sub nspdbAbs1(Vec() As Double, ByVal N As Long)
     Call nspdbAbs1P(Vec(LBound(Vec)), N)
End Sub
Sub nspwbAbs1(Vec() As Integer, ByVal N As Long)
     Call nspwbAbs1P(Vec(LBound(Vec)), N)
End Sub
Sub nspsbAbs2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbAbs2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbAbs2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbAbs2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbAbs2(Src() As Integer, Dst() As Integer, ByVal N As Long)
     Call nspwbAbs2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspsbSqr1(Vec() As Single, ByVal N As Long)
     Call nspsbSqr1P(Vec(LBound(Vec)), N)
End Sub
Sub nspcbSqr1(Vec() As SCplx, ByVal N As Long)
     Call nspcbSqr1P(Vec(LBound(Vec)), N)
End Sub
Sub nspdbSqr1(Vec() As Double, ByVal N As Long)
     Call nspdbSqr1P(Vec(LBound(Vec)), N)
End Sub
Sub nspzbSqr1(Vec() As DCplx, ByVal N As Long)
     Call nspzbSqr1P(Vec(LBound(Vec)), N)
End Sub
Sub nspwbSqr1(Vec() As Integer, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbSqr1P(Vec(LBound(Vec)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspvbSqr1(Vec() As WCplx, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbSqr1P(Vec(LBound(Vec)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbSqr2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbSqr2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbSqr2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbSqr2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbSqr2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbSqr2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbSqr2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbSqr2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbSqr2(Src() As Integer, Dst() As Integer, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbSqr2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspvbSqr2(Src() As WCplx, Dst() As WCplx, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvbSqr2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsbSqrt1(Vec() As Single, ByVal N As Long)
     Call nspsbSqrt1P(Vec(LBound(Vec)), N)
End Sub
Sub nspcbSqrt1(Vec() As SCplx, ByVal N As Long)
     Call nspcbSqrt1P(Vec(LBound(Vec)), N)
End Sub
Sub nspdbSqrt1(Vec() As Double, ByVal N As Long)
     Call nspdbSqrt1P(Vec(LBound(Vec)), N)
End Sub
Sub nspzbSqrt1(Vec() As DCplx, ByVal N As Long)
     Call nspzbSqrt1P(Vec(LBound(Vec)), N)
End Sub
Sub nspwbSqrt1(Vec() As Integer, ByVal N As Long)
     Call nspwbSqrt1P(Vec(LBound(Vec)), N)
End Sub
Sub nspvbSqrt1(Vec() As WCplx, ByVal N As Long)
     Call nspvbSqrt1P(Vec(LBound(Vec)), N)
End Sub
Sub nspsbSqrt2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbSqrt2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbSqrt2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbSqrt2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspdbSqrt2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbSqrt2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbSqrt2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbSqrt2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbSqrt2(Src() As Integer, Dst() As Integer, ByVal N As Long)
     Call nspwbSqrt2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbSqrt2(Src() As WCplx, Dst() As WCplx, ByVal N As Long)
     Call nspvbSqrt2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspsbExp1(Vec() As Single, ByVal N As Long)
     Call nspsbExp1P(Vec(LBound(Vec)), N)
End Sub
Sub nspdbExp1(Vec() As Double, ByVal N As Long)
     Call nspdbExp1P(Vec(LBound(Vec)), N)
End Sub
Sub nspwbExp1(Vec() As Integer, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbExp1P(Vec(LBound(Vec)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsbExp2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbExp2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspsdbExp2(Src() As Single, Dst() As Double, ByVal N As Long)
     Call nspsdbExp2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub


Sub nspdbExp2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbExp2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbExp2(Src() As Integer, Dst() As Integer, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwbExp2P(Src(LBound(Src)), Dst(LBound(Dst)), N, _
     ScaleMode, ScaleFactor)
End Sub

Sub nspsbLn1(Vec() As Single, ByVal N As Long)
     Call nspsbLn1P(Vec(LBound(Vec)), N)
End Sub
Sub nspdbLn1(Vec() As Double, ByVal N As Long)
     Call nspdbLn1P(Vec(LBound(Vec)), N)
End Sub
Sub nspwbLn1(Vec() As Integer, ByVal N As Long)
     Call nspwbLn1P(Vec(LBound(Vec)), N)
End Sub
Sub nspsbLn2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbLn2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspdsbLn2(Src() As Double, Dst() As Single, ByVal N As Long)
     Call nspdsbLn2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub

Sub nspdbLn2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbLn2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspwbLn2(Src() As Integer, Dst() As Integer, ByVal N As Long)
     Call nspwbLn2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'********
Sub nspsbLg1(Vec() As Single, ByVal N As Long)
     Call nspsbLg1P(Vec(LBound(Vec)), N)
End Sub
'********
Sub nspdbLg1(Vec() As Double, ByVal N As Long)
     Call nspdbLg1P(Vec(LBound(Vec)), N)
End Sub
'********
Sub nspcbLg1(Vec() As SCplx, ByVal N As Long)
     Call nspcbLg1P(Vec(LBound(Vec)), N)
End Sub
'********
Sub nspsbLg2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbLg2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'********
Sub nspdbLg2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbLg2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'********
Sub nspcbLg2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbLg2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'********
Sub nspczbLg2(Src() As SCplx, Dst() As DCplx, ByVal N As Long)
     Call nspczbLg2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspsbArctan1(Vec() As Single, ByVal N As Long)
     Call nspsbArctan1P(Vec(LBound(Vec)), N)
End Sub
'*********
Sub nspdbArctan1(Vec() As Double, ByVal N As Long)
     Call nspdbArctan1P(Vec(LBound(Vec)), N)
End Sub
'*********
Sub nspsbArctan2(Src() As Single, Dst() As Single, ByVal N As Long)
     Call nspsbArctan2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspdbArctan2(Src() As Double, Dst() As Double, ByVal N As Long)
     Call nspdbArctan2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
'_________________________________________________________________
'*********
Sub nspwbAnd1(Val As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbAnd1P(Val, Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbAnd2(Val() As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbAnd2P(Val(LBound(Val)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbAnd3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbAnd3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub

'*********
Sub nspwbOr1(Val As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbOr1P(Val, Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbOr2(Val() As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbOr2P(Val(LBound(Val)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbOr3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbOr3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbXor1(Val As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbXor1P(Val, Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbXor2(Val() As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbXor2P(Val(LBound(Val)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbXor3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, ByVal N As Long)
    Call nspwbXor3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbNot(Dst() As Integer, ByVal N As Long)
    Call nspwbNotP(Dst(LBound(Dst)), N)
End Sub
'*********
Sub nspwbShiftL(Dst() As Integer, ByVal N As Long, ByVal nShift As Long)
    Call nspwbShiftLP(Dst(LBound(Dst)), N, nShift)
End Sub
'*********
Sub nspwbShiftR(Dst() As Integer, ByVal N As Long, ByVal nShift As Long)
    Call nspwbShiftRP(Dst(LBound(Dst)), N, nShift)
End Sub
'__________________________________________________________________________
Function nspsMax(Vec() As Single, ByVal N As Long) As Single
      nspsMax = nspsMaxP(Vec(LBound(Vec)), N)
End Function
Function nspdMax(Vec() As Double, ByVal N As Long) As Double
     nspdMax = nspdMaxP(Vec(LBound(Vec)), N)
End Function
Function nspwMax(Vec() As Integer, ByVal N As Long) As Integer
     nspwMax = nspwMaxP(Vec(LBound(Vec)), N)
End Function
'*******
Function nspsMaxExt(Vec() As Single, ByVal N As Long, Index As Long) As Single
      nspsMaxExt = nspsMaxExtP(Vec(LBound(Vec)), N, Index)
End Function
'*******
Function nspdMaxExt(Vec() As Double, ByVal N As Long, Index As Long) As Double
      nspdMaxExt = nspdMaxExtP(Vec(LBound(Vec)), N, Index)
End Function
'*******
Function nspwMaxExt(Vec() As Integer, ByVal N As Long, Index As Long) As Integer
      nspwMaxExt = nspwMaxExtP(Vec(LBound(Vec)), N, Index)
End Function

Function nspsMin(Vec() As Single, ByVal N As Long) As Single
      nspsMin = nspsMinP(Vec(LBound(Vec)), N)
End Function
Function nspdMin(Vec() As Double, ByVal N As Long) As Double
     nspdMin = nspdMinP(Vec(LBound(Vec)), N)
End Function
Function nspwMin(Vec() As Integer, ByVal N As Long) As Integer
     nspwMin = nspwMinP(Vec(LBound(Vec)), N)
End Function
'*******
Function nspsMinExt(Vec() As Single, ByVal N As Long, Index As Long) As Single
      nspsMinExt = nspsMinExtP(Vec(LBound(Vec)), N, Index)
End Function
'*******
Function nspdMinExt(Vec() As Double, ByVal N As Long, Index As Long) As Double
      nspdMinExt = nspdMinExtP(Vec(LBound(Vec)), N, Index)
End Function
'*******
Function nspwMinExt(Vec() As Integer, ByVal N As Long, Index As Long) As Integer
      nspwMinExt = nspwMinExtP(Vec(LBound(Vec)), N, Index)
End Function
'*******
Function nspsSum(Src() As Single, ByVal N As Long) As Single
    nspsSum = nspsSumP(Src(LBound(Src)), N)
End Function
'*******
Function nspdSum(Src() As Double, ByVal N As Long) As Double
    nspdSum = nspdSumP(Src(LBound(Src)), N)
End Function
'*******
Function nspwSum(Src() As Integer, ByVal N As Long, _
         ByVal ScaleMode As Long, ScaleFactor As Long) As Long
    nspwSum = nspwSumP(Src(LBound(Src)), N, ScaleMode, ScaleFactor)
End Function
'*******
Function nspcSum(Src() As SCplx, ByVal N As Long, Sum() As SCplx) As Long
    nspcSum = nspcSumP(Src(LBound(Src)), N, Sum(LBound(Sum)))
End Function
'*******
Function nspzSum(Src() As DCplx, ByVal N As Long, Sum() As DCplx) As Long
    nspzSum = nspzSumP(Src(LBound(Src)), N, Sum(LBound(Sum)))
End Function
'*******
Function nspvSum(Src() As WCplx, ByVal N As Long, Sum() As ICplx, _
         ByVal ScaleMode As Long, ScaleFactor As Long) As Long
    nspvSum = nspvSumP(Src(LBound(Src)), N, Sum(LBound(Sum)), ScaleMode, ScaleFactor)
End Function

Function nspsMean(Vec() As Single, ByVal N As Long) As Single
      nspsMean = nspsMeanP(Vec(LBound(Vec)), N)
End Function
Function nspdMean(Vec() As Double, ByVal N As Long) As Double
     nspdMean = nspdMeanP(Vec(LBound(Vec)), N)
End Function
Function nspwMean(Vec() As Integer, ByVal N As Long) As Integer
     nspwMean = nspwMeanP(Vec(LBound(Vec)), N)
End Function
Function nspsStdDev(Vec() As Single, ByVal N As Long) As Single
     nspsStdDev = nspsStdDevP(Vec(LBound(Vec)), N)
End Function
Function nspdStdDev(Vec() As Double, ByVal N As Long) As Double
     nspdStdDev = nspdStdDevP(Vec(LBound(Vec)), N)
End Function
Function nspwStdDev(Vec() As Integer, ByVal N As Long, _
     ByVal ScaleMode As Long, ScaleFactor As Long) As Integer
     nspwStdDev = nspwStdDevP(Vec(LBound(Vec)), N, _
     ScaleMode, ScaleFactor)
End Function
Function nspsNorm(SrcA() As Single, SrcB() As Single, ByVal N As Long, _
    ByVal flag As Long) As Single
    nspsNorm = nspsNormP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, flag)
End Function
Function nspcNorm(SrcA() As SCplx, SrcB() As SCplx, ByVal N As Long, _
    ByVal flag As Long) As Single
    nspcNorm = nspcNormP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, flag)
End Function
Function nspdNorm(SrcA() As Double, SrcB() As Double, ByVal N As Long, _
    ByVal flag As Long) As Double
    nspdNorm = nspdNormP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, flag)
End Function
Function nspzNorm(SrcA() As DCplx, SrcB() As DCplx, ByVal N As Long, _
    ByVal flag As Long) As Double
    nspzNorm = nspzNormP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, flag)
End Function
Function nspwNorm(SrcA() As Integer, SrcB() As Integer, ByVal N As Long, _
    ByVal flag As Long) As Single
    nspwNorm = nspwNormP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, flag)
End Function
Function nspvNorm(SrcA() As WCplx, SrcB() As WCplx, ByVal N As Long, _
    ByVal flag As Long) As Single
    nspvNorm = nspvNormP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, flag)
End Function
'*******
Function nspwNormExt(SrcA() As Integer, SrcB() As Integer, ByVal N As Long, _
         ByVal flag As Long, ByVal ScaleMode As Long, _
         ScaleFactor As Long) As Long
    nspwNormExt = nspwNormExtP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, _
                  flag, ScaleMode, ScaleFactor)
End Function
'*******
Function nspvNormExt(SrcA() As WCplx, SrcB() As WCplx, ByVal N As Long, _
         ByVal flag As Long, ByVal ScaleMode As Long, _
         ScaleFactor As Long) As Long
    nspvNormExt = nspvNormExtP(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), N, _
                  flag, ScaleMode, ScaleFactor)
End Function
'________________________________________________________________________
Sub nspcbConj1(Vec() As SCplx, ByVal N As Long)
     Call nspcbConj1P(Vec(LBound(Vec)), N)
End Sub
Sub nspzbConj1(Vec() As DCplx, ByVal N As Long)
     Call nspzbConj1P(Vec(LBound(Vec)), N)
End Sub
Sub nspvbConj1(Vec() As WCplx, ByVal N As Long)
     Call nspvbConj1P(Vec(LBound(Vec)), N)
End Sub
Sub nspcbConj2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbConj2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbConj2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbConj2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbConj2(Src() As WCplx, Dst() As WCplx, ByVal N As Long)
     Call nspvbConj2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbConjExtend1(Vec() As SCplx, ByVal N As Long)
     Call nspcbConjExtend1P(Vec(LBound(Vec)), N)
End Sub
Sub nspzbConjExtend1(Vec() As DCplx, ByVal N As Long)
     Call nspzbConjExtend1P(Vec(LBound(Vec)), N)
End Sub
Sub nspvbConjExtend1(Vec() As WCplx, ByVal N As Long)
     Call nspvbConjExtend1P(Vec(LBound(Vec)), N)
End Sub
Sub nspcbConjExtend2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbConjExtend2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbConjExtend2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbConjExtend2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbConjExtend2(Src() As WCplx, Dst() As WCplx, ByVal N As Long)
     Call nspvbConjExtend2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbConjFlip2(Src() As SCplx, Dst() As SCplx, ByVal N As Long)
     Call nspcbConjFlip2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbConjFlip2(Src() As DCplx, Dst() As DCplx, ByVal N As Long)
     Call nspzbConjFlip2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbConjFlip2(Src() As WCplx, Dst() As WCplx, ByVal N As Long)
     Call nspvbConjFlip2P(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspsUpSample(Src() As Single, ByVal SrcLen As Long, Dst() As Single, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspsUpSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspcUpSample(Src() As SCplx, ByVal SrcLen As Long, Dst() As SCplx, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspcUpSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspdUpSample(Src() As Double, ByVal SrcLen As Long, Dst() As Double, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspdUpSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspzUpSample(Src() As DCplx, ByVal SrcLen As Long, Dst() As DCplx, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspzUpSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspwUpSample(Src() As Integer, ByVal SrcLen As Long, Dst() As Integer, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspwUpSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspvUpSample(Src() As WCplx, ByVal SrcLen As Long, Dst() As WCplx, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspvUpSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspsDownSample(Src() As Single, ByVal SrcLen As Long, Dst() As Single, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspsDownSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspcDownSample(Src() As SCplx, ByVal SrcLen As Long, Dst() As SCplx, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspcDownSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspdDownSample(Src() As Double, ByVal SrcLen As Long, Dst() As Double, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspdDownSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspzDownSample(Src() As DCplx, ByVal SrcLen As Long, Dst() As DCplx, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspzDownSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspwDownSample(Src() As Integer, ByVal SrcLen As Long, Dst() As Integer, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspwDownSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspvDownSample(Src() As WCplx, ByVal SrcLen As Long, Dst() As WCplx, _
    DstLen As Long, ByVal factor As Long, phase As Long)
    Call nspvDownSampleP(Src(LBound(Src)), SrcLen, Dst(LBound(Dst)), DstLen, factor, _
    phase)
End Sub
Sub nspsAutoCorr(Src() As Single, ByVal lenn As Long, Dst() As Single, _
    ByVal nLags As Long, ByVal flag As Long)
    Call nspsAutoCorrP(Src(LBound(Src)), lenn, Dst(LBound(Dst)), _
    nLags, flag)
End Sub
Sub nspcAutoCorr(Src() As SCplx, ByVal lenn As Long, Dst() As SCplx, _
    ByVal nLags As Long, ByVal flag As Long)
    Call nspcAutoCorrP(Src(LBound(Src)), lenn, Dst(LBound(Dst)), _
    nLags, flag)
End Sub
Sub nspdAutoCorr(Src() As Double, ByVal lenn As Long, Dst() As Double, _
    ByVal nLags As Long, ByVal flag As Long)
    Call nspdAutoCorrP(Src(LBound(Src)), lenn, Dst(LBound(Dst)), _
    nLags, flag)
End Sub
Sub nspzAutoCorr(Src() As DCplx, ByVal lenn As Long, Dst() As DCplx, _
    ByVal nLags As Long, ByVal flag As Long)
    Call nspzAutoCorrP(Src(LBound(Src)), lenn, Dst(LBound(Dst)), _
    nLags, flag)
End Sub
Sub nspwAutoCorr(Src() As Integer, ByVal lenn As Long, Dst() As Integer, _
    ByVal nLags As Long, ByVal flag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwAutoCorrP(Src(LBound(Src)), lenn, Dst(LBound(Dst)), _
    nLags, flag, ScaleMode, ScaleFactor)
End Sub
Sub nspvAutoCorr(Src() As WCplx, ByVal lenn As Long, Dst() As WCplx, _
    ByVal nLags As Long, ByVal flag As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvAutoCorrP(Src(LBound(Src)), lenn, Dst(LBound(Dst)), _
    nLags, flag, ScaleMode, ScaleFactor)
End Sub
Sub nspsCrossCorr(SrcA() As Single, ByVal LennA As Long, SrcB() As Single, _
    ByVal LennB As Long, Dst() As Single, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspsCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspcCrossCorr(SrcA() As SCplx, ByVal LennA As Long, SrcB() As SCplx, _
    ByVal LennB As Long, Dst() As SCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspcCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspscCrossCorr(SrcA() As Single, ByVal LennA As Long, SrcB() As SCplx, _
    ByVal LennB As Long, Dst() As SCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspscCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspcsCrossCorr(SrcA() As SCplx, ByVal LennA As Long, SrcB() As Single, _
    ByVal LennB As Long, Dst() As SCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspcsCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspdCrossCorr(SrcA() As Double, ByVal LennA As Long, SrcB() As Double, _
    ByVal LennB As Long, Dst() As Double, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspdCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspzCrossCorr(SrcA() As DCplx, ByVal LennA As Long, SrcB() As DCplx, _
    ByVal LennB As Long, Dst() As DCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspzCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspdzCrossCorr(SrcA() As Double, ByVal LennA As Long, SrcB() As DCplx, _
    ByVal LennB As Long, Dst() As DCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspdzCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspzdCrossCorr(SrcA() As DCplx, ByVal LennA As Long, SrcB() As Double, _
    ByVal LennB As Long, Dst() As DCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long)
    Call nspzdCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag)
End Sub
Sub nspwCrossCorr(SrcA() As Integer, ByVal LennA As Long, SrcB() As Integer, _
    ByVal LennB As Long, Dst() As Integer, ByVal LoLag As Long, _
    ByVal HiLag As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag, ScaleMode, ScaleFactor)
End Sub
Sub nspvCrossCorr(SrcA() As WCplx, ByVal LennA As Long, SrcB() As WCplx, _
    ByVal LennB As Long, Dst() As WCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag, ScaleMode, ScaleFactor)
End Sub
Sub nspwvCrossCorr(SrcA() As Integer, ByVal LennA As Long, SrcB() As WCplx, _
    ByVal LennB As Long, Dst() As WCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwvCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag, ScaleMode, ScaleFactor)
End Sub
Sub nspvwCrossCorr(SrcA() As WCplx, ByVal LennA As Long, SrcB() As Integer, _
    ByVal LennB As Long, Dst() As WCplx, ByVal LoLag As Long, _
    ByVal HiLag As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvwCrossCorrP(SrcA(LBound(SrcA)), LennA, SrcB(LBound(SrcB)), LennB, _
    Dst(LBound(Dst)), LoLag, HiLag, ScaleMode, ScaleFactor)
End Sub

'CHAPTER 4.
'Vector Data Conversion Functions.

Sub nspcbReal(Src() As SCplx, Dst() As Single, ByVal N As Long)
    Call nspcbRealP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbReal(Src() As DCplx, Dst() As Double, ByVal N As Long)
    Call nspzbRealP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbReal(Src() As WCplx, Dst() As Integer, ByVal N As Long)
    Call nspvbRealP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcbImag(Src() As SCplx, Dst() As Single, ByVal N As Long)
    Call nspcbImagP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspzbImag(Src() As DCplx, Dst() As Double, ByVal N As Long)
    Call nspzbImagP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspvbImag(Src() As WCplx, Dst() As Integer, ByVal N As Long)
    Call nspvbImagP(Src(LBound(Src)), Dst(LBound(Dst)), N)
End Sub
Sub nspcb2RealToCplx(srcReal() As Single, srcImag() As Single, Dst() As SCplx, _
    ByVal N As Long)
    Call nspcb2RealToCplxP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    Dst(LBound(Dst)), N)
End Sub
Sub nspzb2RealToCplx(srcReal() As Double, srcImag() As Double, Dst() As DCplx, _
    ByVal N As Long)
    Call nspzb2RealToCplxP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    Dst(LBound(Dst)), N)
End Sub
Sub nspvb2RealToCplx(srcReal() As Integer, srcImag() As Integer, Dst() As WCplx, _
    ByVal N As Long)
    Call nspvb2RealToCplxP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    Dst(LBound(Dst)), N)
End Sub
Sub nspcbCplxTo2Real(Src() As SCplx, DstReal() As Single, DstImag() As Single, _
    ByVal N As Long)
    Call nspcbCplxTo2RealP(Src(LBound(Src)), DstReal(LBound(DstReal)), _
    DstImag(LBound(DstImag)), N)
End Sub
Sub nspzbCplxTo2Real(Src() As DCplx, DstReal() As Double, DstImag() As Double, _
    ByVal N As Long)
    Call nspzbCplxTo2RealP(Src(LBound(Src)), DstReal(LBound(DstReal)), _
    DstImag(LBound(DstImag)), N)
End Sub
Sub nspvbCplxTo2Real(Src() As WCplx, DstReal() As Integer, DstImag() As Integer, _
    ByVal N As Long)
    Call nspvbCplxTo2RealP(Src(LBound(Src)), DstReal(LBound(DstReal)), _
    DstImag(LBound(DstImag)), N)
End Sub

Sub nspcbMag(Src() As SCplx, mag() As Single, ByVal N As Long)
    Call nspcbMagP(Src(LBound(Src)), mag(LBound(mag)), N)
End Sub
Sub nspzbMag(Src() As DCplx, mag() As Double, ByVal N As Long)
    Call nspzbMagP(Src(LBound(Src)), mag(LBound(mag)), N)
End Sub
Sub nspvbMag(Src() As WCplx, mag() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvbMagP(Src(LBound(Src)), mag(LBound(mag)), N, ScaleMode, ScaleFactor)
End Sub

Sub nspsbrMag(srcReal() As Single, srcImag() As Single, mag() As Single, _
    ByVal N As Long)
    Call nspsbrMagP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    mag(LBound(mag)), N)
End Sub
Sub nspdbrMag(srcReal() As Double, srcImag() As Double, mag() As Double, _
    ByVal N As Long)
    Call nspdbrMagP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    mag(LBound(mag)), N)
End Sub
Sub nspwbrMag(srcReal() As Integer, srcImag() As Integer, mag() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwbrMagP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    mag(LBound(mag)), N, ScaleMode, ScaleFactor)
End Sub

Sub nspcbPhase(Src() As SCplx, phase() As Single, ByVal N As Long)
    Call nspcbPhaseP(Src(LBound(Src)), phase(LBound(phase)), N)
End Sub
Sub nspzbPhase(Src() As DCplx, phase() As Double, ByVal N As Long)
    Call nspzbPhaseP(Src(LBound(Src)), phase(LBound(phase)), N)
End Sub
Sub nspvbPhase(Src() As WCplx, phase() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvbPhaseP(Src(LBound(Src)), phase(LBound(phase)), N, ScaleMode, ScaleFactor)
End Sub

Sub nspsbrPhase(srcReal() As Single, srcImag() As Single, phase() As Single, _
    ByVal N As Long)
    Call nspsbrPhaseP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    phase(LBound(phase)), N)
End Sub
Sub nspdbrPhase(srcReal() As Double, srcImag() As Double, phase() As Double, _
    ByVal N As Long)
    Call nspdbrPhaseP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    phase(LBound(phase)), N)
End Sub
Sub nspwbrPhase(srcReal() As Integer, srcImag() As Integer, phase() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwbrPhaseP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    phase(LBound(phase)), N, ScaleMode, ScaleFactor)
End Sub

Sub nspcbPowerSpectr(Src() As SCplx, Spectr() As Single, ByVal N As Long)
    Call nspcbPowerSpectrP(Src(LBound(Src)), Spectr(LBound(Spectr)), N)
End Sub
Sub nspzbPowerSpectr(Src() As DCplx, Spectr() As Double, ByVal N As Long)
    Call nspzbPowerSpectrP(Src(LBound(Src)), Spectr(LBound(Spectr)), N)
End Sub
Sub nspvbPowerSpectr(Src() As WCplx, Spectr() As Integer, ByVal N As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvbPowerSpectrP(Src(LBound(Src)), Spectr(LBound(Spectr)), N, _
    ScaleMode, ScaleFactor)
End Sub

Sub nspsbrPowerSpectr(srcReal() As Single, srcImag() As Single, Spectr() As Single, _
    ByVal N As Long)
    Call nspsbrPowerSpectrP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    Spectr(LBound(Spectr)), N)
End Sub
Sub nspdbrPowerSpectr(srcReal() As Double, srcImag() As Double, Spectr() As Double, _
    ByVal N As Long)
    Call nspdbrPowerSpectrP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    Spectr(LBound(Spectr)), N)
End Sub
Sub nspwbrPowerSpectr(srcReal() As Integer, srcImag() As Integer, _
    Spectr() As Integer, ByVal N As Long, ByVal ScaleMode As Long, _
    ScaleFactor As Long)
    Call nspwbrPowerSpectrP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    Spectr(LBound(Spectr)), N, ScaleMode, ScaleFactor)
End Sub

Sub nspsbFloatToInt8(Src() As Single, Dst() As Byte, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 8
    Call nspsbFloatToInt8P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspsbFloatToInt16(Src() As Single, Dst() As Integer, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 16
    Call nspsbFloatToInt16P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspsbFloatToInt32(Src() As Single, Dst() As Long, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 32
    Call nspsbFloatToInt32P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspdbFloatToInt8(Src() As Double, Dst() As Byte, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 8
    Call nspdbFloatToInt8P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspdbFloatToInt16(Src() As Double, Dst() As Integer, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 16
    Call nspdbFloatToInt16P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspdbFloatToInt32(Src() As Double, Dst() As Long, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 32
    Call nspdbFloatToInt32P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspsbInt8ToFloat(Src() As Byte, Dst() As Single, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 8
    Call nspsbInt8ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspsbInt16ToFloat(Src() As Integer, Dst() As Single, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 16
    Call nspsbInt16ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspsbInt32ToFloat(Src() As Long, Dst() As Single, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 32
    Call nspsbInt32ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspdbInt8ToFloat(Src() As Byte, Dst() As Double, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 8
    Call nspdbInt8ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspdbInt16ToFloat(Src() As Integer, Dst() As Double, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 16
    Call nspdbInt16ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspdbInt32ToFloat(Src() As Long, Dst() As Double, ByVal lenn As Long, _
    ByVal flags As Long)
    wordSize = 32
    Call nspdbInt32ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, flags)
End Sub
Sub nspsbFloatToFix8(Src() As Single, Dst() As Byte, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 8
    Call nspsbFloatToFix8P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspsbFloatToFix16(Src() As Single, Dst() As Integer, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 16
    Call nspsbFloatToFix16P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspsbFloatToFix32(Src() As Single, Dst() As Long, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 32
    Call nspsbFloatToFix32P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspdbFloatToFix8(Src() As Double, Dst() As Byte, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 8
    Call nspdbFloatToFix8P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspdbFloatToFix16(Src() As Double, Dst() As Integer, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 16
    Call nspdbFloatToFix16P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspdbFloatToFix32(Src() As Double, Dst() As Long, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 32
    Call nspdbFloatToFix32P(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspsbFix8ToFloat(Src() As Byte, Dst() As Single, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 8
    Call nspsbFix8ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspsbFix16ToFloat(Src() As Integer, Dst() As Single, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 16
    Call nspsbFix16ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspsbFix32ToFloat(Src() As Long, Dst() As Single, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 32
    Call nspsbFix32ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspdbFix8ToFloat(Src() As Byte, Dst() As Double, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 8
    Call nspdbFix8ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspdbFix16ToFloat(Src() As Integer, Dst() As Double, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 16
    Call nspdbFix16ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspdbFix32ToFloat(Src() As Long, Dst() As Double, ByVal lenn As Long, _
    ByVal fractBits As Long, ByVal flags As Long)
    wordSize = 32
    Call nspdbFix32ToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, wordSize, _
    fractBits, flags)
End Sub
Sub nspsbFloatToS31Fix(Src() As Single, Dst() As Long, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspsbFloatToS31FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspdbFloatToS31Fix(Src() As Double, Dst() As Long, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspdbFloatToS31FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspsbS31FixToFloat(Src() As Long, Dst() As Single, ByVal lenn As Long)
    Call nspsbS31FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbS31FixToFloat(Src() As Long, Dst() As Double, ByVal lenn As Long)
    Call nspdbS31FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspsbFloatToS1516Fix(Src() As Single, Dst() As Long, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspsbFloatToS1516FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspdbFloatToS1516Fix(Src() As Double, Dst() As Long, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspdbFloatToS1516FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspsbS1516FixToFloat(Src() As Long, Dst() As Single, ByVal lenn As Long)
    Call nspsbS1516FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbS1516FixToFloat(Src() As Long, Dst() As Double, ByVal lenn As Long)
    Call nspdbS1516FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspsbFloatToS15Fix(Src() As Single, Dst() As Integer, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspsbFloatToS15FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspdbFloatToS15Fix(Src() As Double, Dst() As Integer, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspdbFloatToS15FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspsbS15FixToFloat(Src() As Integer, Dst() As Single, ByVal lenn As Long)
    Call nspsbS15FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbS15FixToFloat(Src() As Integer, Dst() As Double, ByVal lenn As Long)
    Call nspdbS15FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspsbFloatToS7Fix(Src() As Single, Dst() As Byte, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspsbFloatToS7FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspdbFloatToS7Fix(Src() As Double, Dst() As Byte, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspdbFloatToS7FixP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspsbS7FixToFloat(Src() As Byte, Dst() As Single, ByVal lenn As Long)
    Call nspsbS7FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbS7FixToFloat(Src() As Byte, Dst() As Double, ByVal lenn As Long)
    Call nspdbS7FixToFloatP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspcbCartToPolar(Src() As SCplx, mag() As Single, phase() As Single, _
    ByVal lenn As Long)
    Call nspcbCartToPolarP(Src(LBound(Src)), mag(LBound(mag)), phase(LBound(phase)), _
    lenn)
End Sub
Sub nspzbCartToPolar(Src() As DCplx, mag() As Double, phase() As Double, _
    ByVal lenn As Long)
    Call nspzbCartToPolarP(Src(LBound(Src)), mag(LBound(mag)), phase(LBound(phase)), _
    lenn)
End Sub
Sub nspsbrCartToPolar(srcReal() As Single, srcImag() As Single, mag() As Single, _
    phase() As Single, ByVal lenn As Long)
    Call nspsbrCartToPolarP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
    mag(LBound(mag)), phase(LBound(phase)), lenn)
End Sub

Sub nspdbrCartToPolar(srcReal() As Double, srcImag() As Double, mag() As Double, _
    phase() As Double, ByVal lenn As Long)
    Call nspdbrCartToPolarP(srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), _
     mag(LBound(mag)), phase(LBound(phase)), lenn)
End Sub

Sub nspcbPolarToCart(mag() As Single, phase() As Single, Src() As SCplx, _
    ByVal lenn As Long)
    Call nspcbPolarToCartP(mag(LBound(mag)), phase(LBound(phase)), Src(LBound(Src)), _
    lenn)
End Sub
Sub nspzbPolarToCart(mag() As Double, phase() As Double, Src() As DCplx, _
    ByVal lenn As Long)
    Call nspzbPolarToCartP(mag(LBound(mag)), phase(LBound(phase)), Src(LBound(Src)), _
    lenn)
End Sub
Sub nspsbrPolarToCart(mag() As Single, phase() As Single, srcReal() As Single, _
    srcImag() As Single, ByVal lenn As Long)
    Call nspsbrPolarToCartP(mag(LBound(mag)), phase(LBound(phase)), _
    srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), lenn)
End Sub
Sub nspdbrPolarToCart(mag() As Double, phase() As Double, srcReal() As Double, _
    srcImag() As Double, ByVal lenn As Long)
    Call nspdbrPolarToCartP(mag(LBound(mag)), phase(LBound(phase)), _
    srcReal(LBound(srcReal)), srcImag(LBound(srcImag)), lenn)
End Sub
Sub nspsbMuLawToLin(Src() As Byte, Dst() As Single, ByVal lenn As Long)
    Call nspsbMuLawToLinP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbMuLawToLin(Src() As Byte, Dst() As Double, ByVal lenn As Long)
    Call nspdbMuLawToLinP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspwbMuLawToLin(Src() As Byte, Dst() As Integer, ByVal lenn As Long)
    Call nspwbMuLawToLinP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspsbLinToMuLaw(Src() As Single, Dst() As Byte, ByVal lenn As Long)
    Call nspsbLinToMuLawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbLinToMuLaw(Src() As Double, Dst() As Byte, ByVal lenn As Long)
    Call nspdbLinToMuLawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspwbLinToMuLaw(Src() As Integer, Dst() As Byte, ByVal lenn As Long)
    Call nspwbLinToMuLawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspsbALawToLin(Src() As Byte, Dst() As Single, ByVal lenn As Long)
    Call nspsbALawToLinP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbALawToLin(Src() As Byte, Dst() As Double, ByVal lenn As Long)
    Call nspdbALawToLinP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspwbALawToLin(Src() As Byte, Dst() As Integer, ByVal lenn As Long)
    Call nspwbALawToLinP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspsbLinToALaw(Src() As Single, Dst() As Byte, ByVal lenn As Long)
    Call nspsbLinToALawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspdbLinToALaw(Src() As Double, Dst() As Byte, ByVal lenn As Long)
    Call nspdbLinToALawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspwbLinToALaw(Src() As Integer, Dst() As Byte, ByVal lenn As Long)
    Call nspwbLinToALawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspbMuLawToALaw(Src() As Byte, Dst() As Byte, ByVal lenn As Long)
    Call nspbMuLawToALawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub
Sub nspbALawToMuLaw(Src() As Byte, Dst() As Byte, ByVal lenn As Long)
    Call nspbALawToMuLawP(Src(LBound(Src)), Dst(LBound(Dst)), lenn)
End Sub

'CHAPTER 5.
'Sample-Generating Functions.

Sub nspsbTone(statePtr As NSPSToneState, Samps() As Single, _
    ByVal SampsLenn As Long)
     Call nspsbToneP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspcbTone(statePtr As NSPCToneState, Samps() As SCplx, _
    ByVal SampsLenn As Long)
     Call nspcbToneP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspdbTone(statePtr As NSPDToneState, Samps() As Double, _
    ByVal SampsLenn As Long)
     Call nspdbToneP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspzbTone(statePtr As NSPZToneState, Samps() As DCplx, _
    ByVal SampsLenn As Long)
     Call nspzbToneP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspwbTone(statePtr As NSPWToneState, Samps() As Integer, _
    ByVal SampsLenn As Long)
     Call nspwbToneP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspvbTone(statePtr As NSPVToneState, Samps() As WCplx, _
    ByVal SampsLenn As Long)
     Call nspvbToneP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspsbTrngl(statePtr As NSPSTrnglState, Samps() As Single, _
    ByVal SampsLenn As Long)
     Call nspsbTrnglP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspcbTrngl(statePtr As NSPCTrnglState, Samps() As SCplx, _
    ByVal SampsLenn As Long)
     Call nspcbTrnglP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspdbTrngl(statePtr As NSPDTrnglState, Samps() As Double, _
    ByVal SampsLenn As Long)
     Call nspdbTrnglP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspzbTrngl(statePtr As NSPZTrnglState, Samps() As DCplx, _
    ByVal SampsLenn As Long)
     Call nspzbTrnglP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspwbTrngl(statePtr As NSPWTrnglState, Samps() As Integer, _
    ByVal SampsLenn As Long)
     Call nspwbTrnglP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspvbTrngl(statePtr As NSPVTrnglState, Samps() As WCplx, _
    ByVal SampsLenn As Long)
     Call nspvbTrnglP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspsbRandUni(statePtr As NSPSRandUniState, Samps() As Single, _
    ByVal SampsLenn As Long)
     Call nspsbRandUniP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspcbRandUni(statePtr As NSPCRandUniState, Samps() As SCplx, _
    ByVal SampsLenn As Long)
     Call nspcbRandUniP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspdbRandUni(statePtr As NSPDRandUniState, Samps() As Double, _
    ByVal SampsLenn As Long)
     Call nspdbRandUniP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspzbRandUni(statePtr As NSPZRandUniState, Samps() As DCplx, _
    ByVal SampsLenn As Long)
     Call nspzbRandUniP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspwbRandUni(statePtr As NSPWRandUniState, Samps() As Integer, _
    ByVal SampsLenn As Long)
     Call nspwbRandUniP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspvbRandUni(statePtr As NSPVRandUniState, Samps() As WCplx, _
    ByVal SampsLenn As Long)
     Call nspvbRandUniP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspsbRandGaus(statePtr As NSPSRandGausState, Samps() As Single, _
    ByVal SampsLenn As Long)
     Call nspsbRandGausP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspcbRandGaus(statePtr As NSPCRandGausState, Samps() As SCplx, _
    ByVal SampsLenn As Long)
     Call nspcbRandGausP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspdbRandGaus(statePtr As NSPDRandGausState, Samps() As Double, _
    ByVal SampsLenn As Long)
     Call nspdbRandGausP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspzbRandGaus(statePtr As NSPZRandGausState, Samps() As DCplx, _
    ByVal SampsLenn As Long)
     Call nspzbRandGausP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspwbRandGaus(statePtr As NSPWRandGausState, Samps() As Integer, _
    ByVal SampsLenn As Long)
     Call nspwbRandGausP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub
Sub nspvbRandGaus(statePtr As NSPVRandGausState, Samps() As WCplx, _
    ByVal SampsLenn As Long)
     Call nspvbRandGausP(statePtr, Samps(LBound(Samps)), SampsLenn)
End Sub

'CHAPTER 6.
'Windowing Functions.

Sub nspsWinBartlett(Vec() As Single, ByVal N As Long)
     Call nspsWinBartlettP(Vec(LBound(Vec)), N)
End Sub
Sub nspcWinBartlett(Vec() As SCplx, ByVal N As Long)
     Call nspcWinBartlettP(Vec(LBound(Vec)), N)
End Sub
Sub nspdWinBartlett(Vec() As Double, ByVal N As Long)
     Call nspdWinBartlettP(Vec(LBound(Vec)), N)
End Sub
Sub nspzWinBartlett(Vec() As DCplx, ByVal N As Long)
     Call nspzWinBartlettP(Vec(LBound(Vec)), N)
End Sub
Sub nspwWinBartlett(Vec() As Integer, ByVal N As Long)
     Call nspwWinBartlettP(Vec(LBound(Vec)), N)
End Sub
Sub nspvWinBartlett(Vec() As WCplx, ByVal N As Long)
     Call nspvWinBartlettP(Vec(LBound(Vec)), N)
End Sub
Sub nspsWinBlackman(Vec() As Single, ByVal N As Long, ByVal alpha As Single)
     Call nspsWinBlackmanP(Vec(LBound(Vec)), N, alpha)
End Sub
Sub nspcWinBlackman(Vec() As SCplx, ByVal N As Long, ByVal alpha As Single)
     Call nspcWinBlackmanP(Vec(LBound(Vec)), N, alpha)
End Sub
Sub nspdWinBlackman(Vec() As Double, ByVal N As Long, ByVal alpha As Double)
     Call nspdWinBlackmanP(Vec(LBound(Vec)), N, alpha)
End Sub
Sub nspzWinBlackman(Vec() As DCplx, ByVal N As Long, ByVal alpha As Double)
     Call nspzWinBlackmanP(Vec(LBound(Vec)), N, alpha)
End Sub
Sub nspwWinBlackman(Vec() As Integer, ByVal N As Long, ByVal alpha As Single)
     Call nspwWinBlackmanP(Vec(LBound(Vec)), N, alpha)
End Sub
Sub nspvWinBlackman(Vec() As WCplx, ByVal N As Long, ByVal alpha As Single)
     Call nspvWinBlackmanP(Vec(LBound(Vec)), N, alpha)
End Sub
Sub nspsWinBlackmanStd(Vec() As Single, ByVal N As Long)
     Call nspsWinBlackmanStdP(Vec(LBound(Vec)), N)
End Sub
Sub nspcWinBlackmanStd(Vec() As SCplx, ByVal N As Long)
     Call nspcWinBlackmanStdP(Vec(LBound(Vec)), N)
End Sub
Sub nspdWinBlackmanStd(Vec() As Double, ByVal N As Long)
     Call nspdWinBlackmanStdP(Vec(LBound(Vec)), N)
End Sub
Sub nspzWinBlackmanStd(Vec() As DCplx, ByVal N As Long)
     Call nspzWinBlackmanStdP(Vec(LBound(Vec)), N)
End Sub
Sub nspwWinBlackmanStd(Vec() As Integer, ByVal N As Long)
     Call nspwWinBlackmanStdP(Vec(LBound(Vec)), N)
End Sub
Sub nspvWinBlackmanStd(Vec() As WCplx, ByVal N As Long)
     Call nspvWinBlackmanStdP(Vec(LBound(Vec)), N)
End Sub
Sub nspsWinBlackmanOpt(Vec() As Single, ByVal N As Long)
     Call nspsWinBlackmanOptP(Vec(LBound(Vec)), N)
End Sub
Sub nspcWinBlackmanOpt(Vec() As SCplx, ByVal N As Long)
     Call nspcWinBlackmanOptP(Vec(LBound(Vec)), N)
End Sub
Sub nspdWinBlackmanOpt(Vec() As Double, ByVal N As Long)
     Call nspdWinBlackmanOptP(Vec(LBound(Vec)), N)
End Sub
Sub nspzWinBlackmanOpt(Vec() As DCplx, ByVal N As Long)
     Call nspzWinBlackmanOptP(Vec(LBound(Vec)), N)
End Sub
Sub nspwWinBlackmanOpt(Vec() As Integer, ByVal N As Long)
     Call nspwWinBlackmanOptP(Vec(LBound(Vec)), N)
End Sub
Sub nspvWinBlackmanOpt(Vec() As WCplx, ByVal N As Long)
     Call nspvWinBlackmanOptP(Vec(LBound(Vec)), N)
End Sub
Sub nspsWinHamming(Vec() As Single, ByVal N As Long)
     Call nspsWinHammingP(Vec(LBound(Vec)), N)
End Sub
Sub nspcWinHamming(Vec() As SCplx, ByVal N As Long)
     Call nspcWinHammingP(Vec(LBound(Vec)), N)
End Sub
Sub nspdWinHamming(Vec() As Double, ByVal N As Long)
     Call nspdWinHammingP(Vec(LBound(Vec)), N)
End Sub
Sub nspzWinHamming(Vec() As DCplx, ByVal N As Long)
     Call nspzWinHammingP(Vec(LBound(Vec)), N)
End Sub
Sub nspwWinHamming(Vec() As Integer, ByVal N As Long)
     Call nspwWinHammingP(Vec(LBound(Vec)), N)
End Sub
Sub nspvWinHamming(Vec() As WCplx, ByVal N As Long)
     Call nspvWinHammingP(Vec(LBound(Vec)), N)
End Sub
Sub nspsWinHann(Vec() As Single, ByVal N As Long)
     Call nspsWinHannP(Vec(LBound(Vec)), N)
End Sub
Sub nspcWinHann(Vec() As SCplx, ByVal N As Long)
     Call nspcWinHannP(Vec(LBound(Vec)), N)
End Sub
Sub nspdWinHann(Vec() As Double, ByVal N As Long)
     Call nspdWinHannP(Vec(LBound(Vec)), N)
End Sub
Sub nspzWinHann(Vec() As DCplx, ByVal N As Long)
     Call nspzWinHannP(Vec(LBound(Vec)), N)
End Sub
Sub nspwWinHann(Vec() As Integer, ByVal N As Long)
     Call nspwWinHannP(Vec(LBound(Vec)), N)
End Sub
Sub nspvWinHann(Vec() As WCplx, ByVal N As Long)
     Call nspvWinHannP(Vec(LBound(Vec)), N)
End Sub
Sub nspsWinKaiser(Vec() As Single, ByVal N As Long, ByVal beta As Single)
     Call nspsWinKaiserP(Vec(LBound(Vec)), N, beta)
End Sub
Sub nspcWinKaiser(Vec() As SCplx, ByVal N As Long, ByVal beta As Single)
     Call nspcWinKaiserP(Vec(LBound(Vec)), N, beta)
End Sub
Sub nspdWinKaiser(Vec() As Double, ByVal N As Long, ByVal beta As Double)
     Call nspdWinKaiserP(Vec(LBound(Vec)), N, beta)
End Sub
Sub nspzWinKaiser(Vec() As DCplx, ByVal N As Long, ByVal beta As Single)
     Call nspzWinKaiserP(Vec(LBound(Vec)), N, beta)
End Sub
Sub nspwWinKaiser(Vec() As Integer, ByVal N As Long, ByVal beta As Single)
     Call nspwWinKaiserP(Vec(LBound(Vec)), N, beta)
End Sub
Sub nspvWinKaiser(Vec() As WCplx, ByVal N As Long, ByVal beta As Single)
     Call nspvWinKaiserP(Vec(LBound(Vec)), N, beta)
End Sub

'CHAPTER 7.
'Fourier and Discrete Cosine Transform Functions.

Sub nspcDft(inSamps() As SCplx, OutSamps() As SCplx, ByVal Length As Long, _
    ByVal flags As Long)
     Call nspcDftP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), Length, _
     flags)
End Sub
Sub nspzDft(inSamps() As DCplx, OutSamps() As DCplx, ByVal Length As Long, _
    ByVal flags As Long)
     Call nspzDftP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), Length, _
     flags)
End Sub
Sub nspvDft(inSamps() As WCplx, OutSamps() As WCplx, ByVal Length As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspvDftP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), Length, _
     flags, ScaleMode, ScaleFactor)
End Sub
Function nspsbGoertz(stPtr As NSPSGoertzState, inSamps() As Single, _
    ByVal lenn As Long) As SCplx
    nspsbGoertz = nspsbGoertzP(stPtr, inSamps(LBound(inSamps)), lenn)
End Function
Function nspcbGoertz(stPtr As NSPCGoertzState, inSamps() As SCplx, _
    ByVal lenn As Long) As SCplx
    nspcbGoertz = nspcbGoertzP(stPtr, inSamps(LBound(inSamps)), lenn)
End Function
Function nspdbGoertz(stPtr As NSPDGoertzState, inSamps() As Double, _
    ByVal lenn As Long) As DCplx
    nspdbGoertz = nspdbGoertzP(stPtr, inSamps(LBound(inSamps)), lenn)
End Function
Function nspzbGoertz(stPtr As NSPZGoertzState, inSamps() As DCplx, _
    ByVal lenn As Long) As DCplx
    nspzbGoertz = nspzbGoertzP(stPtr, inSamps(LBound(inSamps)), lenn)
End Function
Function nspwbGoertz(stPtr As NSPWGoertzState, inSamps() As Integer, _
    ByVal lenn As Long, ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
    nspwbGoertz = nspwbGoertzP(stPtr, inSamps(LBound(inSamps)), lenn, _
    ScaleMode, ScaleFactor)
End Function
Function nspvbGoertz(stPtr As NSPVGoertzState, inSamps() As WCplx, _
    ByVal lenn As Long, ByVal ScaleMode As Long, ScaleFactor As Long) As WCplx
    nspvbGoertz = nspvbGoertzP(stPtr, inSamps(LBound(inSamps)), lenn, _
    ScaleMode, ScaleFactor)
End Function
Sub nspcFft(Samps() As SCplx, ByVal order As Long, ByVal flags As Long)
    Call nspcFftP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspcrFft(reSamps() As Single, imSamps() As Single, ByVal order As Long, _
    ByVal flags As Long)
    Call nspcrFftP(reSamps(LBound(reSamps)), imSamps(LBound(imSamps)), order, flags)
End Sub
Sub nspcFftNip(inSamps() As SCplx, OutSamps() As SCplx, ByVal order As Long, _
    ByVal flags As Long)
    Call nspcFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), order, _
    flags)
End Sub
Sub nspcrFftNip(reInSamps() As Single, imInSamps() As Single, _
    reOutSamps() As Single, imOutSamps() As Single, ByVal order As Long, _
    ByVal flags As Long)
    Call nspcrFftNipP(reInSamps(LBound(reInSamps)), imInSamps(LBound(imInSamps)), _
    reOutSamps(LBound(reOutSamps)), imOutSamps(LBound(imOutSamps)), order, flags)
End Sub
Sub nspzFft(Samps() As DCplx, ByVal order As Long, ByVal flags As Long)
    Call nspzFftP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspzrFft(reSamps() As Double, imSamps() As Double, ByVal order As Long, _
    ByVal flags As Long)
    Call nspzrFftP(reSamps(LBound(reSamps)), imSamps(LBound(imSamps)), order, flags)
End Sub
Sub nspzFftNip(inSamps() As DCplx, OutSamps() As DCplx, ByVal order As Long, _
    ByVal flags As Long)
    Call nspzFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), order, _
    flags)
End Sub
Sub nspzrFftNip(reInSamps() As Double, imInSamps() As Double, _
    reOutSamps() As Double, imOutSamps() As Double, ByVal order As Long, _
    ByVal flags As Long)
    Call nspzrFftNipP(reInSamps(LBound(reInSamps)), imInSamps(LBound(imInSamps)), _
    reOutSamps(LBound(reOutSamps)), imOutSamps(LBound(imOutSamps)), order, flags)
End Sub
Sub nspvFft(Samps() As WCplx, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvFftP(Samps(LBound(Samps)), order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspvrFft(reSamps() As Integer, imSamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvrFftP(reSamps(LBound(reSamps)), imSamps(LBound(imSamps)), order, flags, _
    ScaleMode, ScaleFactor)
End Sub
Sub nspvFftNip(inSamps() As WCplx, OutSamps() As WCplx, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), order, _
    flags, ScaleMode, ScaleFactor)
End Sub
Sub nspvrFftNip(reInSamps() As Integer, imInSamps() As Integer, _
    reOutSamps() As Integer, imOutSamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspvrFftNipP(reInSamps(LBound(reInSamps)), imInSamps(LBound(imInSamps)), _
    reOutSamps(LBound(reOutSamps)), imOutSamps(LBound(imOutSamps)), order, flags, _
    ScaleMode, ScaleFactor)
End Sub
Sub nspsRealFftl(Samps() As Single, ByVal order As Long, ByVal flags As Long)
    Call nspsRealFftlP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspsRealFftlNip(inSamps() As Single, OutSamps() As Single, ByVal order As Long, _
    ByVal flags As Long)
    Call nspsRealFftlNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    order, flags)
End Sub
Sub nspdRealFftl(Samps() As Double, ByVal order As Long, ByVal flags As Long)
    Call nspdRealFftlP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspdRealFftlNip(inSamps() As Double, OutSamps() As Double, ByVal order As Long, _
    ByVal flags As Long)
    Call nspdRealFftlNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    order, flags)
End Sub
Sub nspwRealFftl(Samps() As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwRealFftlP(Samps(LBound(Samps)), order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspwRealFftlNip(inSamps() As Integer, OutSamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwRealFftlNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspsMpyRCPack2(Src() As Single, Dst() As Single, ByVal order As Long)
     Call nspsMpyRCPack2P(Src(LBound(Src)), Dst(LBound(Dst)), order)
End Sub
Sub nspdMpyRCPack2(Src() As Double, Dst() As Double, ByVal order As Long)
     Call nspdMpyRCPack2P(Src(LBound(Src)), Dst(LBound(Dst)), order)
End Sub
Sub nspwMpyRCPack2(Src() As Integer, Dst() As Integer, ByVal order As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwMpyRCPack2P(Src(LBound(Src)), Dst(LBound(Dst)), order, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsMpyRCPack3(SrcA() As Single, SrcB() As Single, Dst() As Single, _
    ByVal N As Long)
     Call nspsMpyRCPack3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), _
     Dst(LBound(Dst)), N)
End Sub
Sub nspdMpyRCPack3(SrcA() As Double, SrcB() As Double, Dst() As Double, _
    ByVal N As Long)
     Call nspdMpyRCPack3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), _
     Dst(LBound(Dst)), N)
End Sub
Sub nspwMpyRCPack3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwMpyRCPack3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), _
     Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsMpyRCPerm2(Src() As Single, Dst() As Single, ByVal order As Long)
     Call nspsMpyRCPerm2P(Src(LBound(Src)), Dst(LBound(Dst)), order)
End Sub
Sub nspdMpyRCPerm2(Src() As Double, Dst() As Double, ByVal order As Long)
     Call nspdMpyRCPerm2P(Src(LBound(Src)), Dst(LBound(Dst)), order)
End Sub
Sub nspwMpyRCPerm2(Src() As Integer, Dst() As Integer, ByVal order As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwMpyRCPerm2P(Src(LBound(Src)), Dst(LBound(Dst)), order, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsMpyRCPerm3(SrcA() As Single, SrcB() As Single, Dst() As Single, _
    ByVal N As Long)
     Call nspsMpyRCPerm3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), _
     Dst(LBound(Dst)), N)
End Sub
Sub nspdMpyRCPerm3(SrcA() As Double, SrcB() As Double, Dst() As Double, _
    ByVal N As Long)
     Call nspdMpyRCPerm3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), _
     Dst(LBound(Dst)), N)
End Sub
Sub nspwMpyRCPerm3(SrcA() As Integer, SrcB() As Integer, Dst() As Integer, _
    ByVal N As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwMpyRCPerm3P(SrcA(LBound(SrcA)), SrcB(LBound(SrcB)), _
     Dst(LBound(Dst)), N, ScaleMode, ScaleFactor)
End Sub
Sub nspsCcsFftl(Samps() As Single, ByVal order As Long, ByVal flags As Long)
     Call nspsCcsFftlP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspdCcsFftl(Samps() As Double, ByVal order As Long, ByVal flags As Long)
     Call nspdCcsFftlP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspwCcsFftl(Samps() As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwCcsFftlP(Samps(LBound(Samps)), order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspsCcsFftlNip(inSamps() As Single, OutSamps() As Single, _
    ByVal order As Long, ByVal flags As Long)
     Call nspsCcsFftlNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
     order, flags)
End Sub
Sub nspdCcsFftlNip(inSamps() As Double, OutSamps() As Double, _
    ByVal order As Long, ByVal flags As Long)
     Call nspdCcsFftlNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
     order, flags)
End Sub
Sub nspwCcsFftlNip(inSamps() As Integer, OutSamps() As Integer, _
    ByVal order As Long, ByVal flags As Long, ByVal ScaleMode As Long, _
    ScaleFactor As Long)
     Call nspwCcsFftlNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
     order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspsRealFft(Samps() As Single, ByVal order As Long, ByVal flags As Long)
     Call nspsRealFftP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspsRealFftNip(inSamps() As Single, OutSamps() As SCplx, ByVal order As Long, _
    ByVal flags As Long)
    Call nspsRealFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    order, flags)
End Sub
Sub nspdRealFft(Samps() As Double, ByVal order As Long, ByVal flags As Long)
     Call nspdRealFftP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspdRealFftNip(inSamps() As Double, OutSamps() As DCplx, ByVal order As Long, _
    ByVal flags As Long)
    Call nspdRealFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    order, flags)
End Sub
Sub nspwRealFft(Samps() As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwRealFftP(Samps(LBound(Samps)), order, flags, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspwRealFftNip(inSamps() As Integer, OutSamps() As WCplx, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwRealFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspsCcsFft(Samps() As Single, ByVal order As Long, ByVal flags As Long)
     Call nspsCcsFftP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspdCcsFft(Samps() As Double, ByVal order As Long, ByVal flags As Long)
     Call nspdCcsFftP(Samps(LBound(Samps)), order, flags)
End Sub
Sub nspwCcsFft(Samps() As Integer, ByVal order As Long, ByVal flags As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwCcsFftP(Samps(LBound(Samps)), order, flags, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsCcsFftNip(inSamps() As SCplx, OutSamps() As Single, ByVal order As Long, _
    ByVal flags As Long)
     Call nspsCcsFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
     order, flags)
End Sub
Sub nspdCcsFftNip(inSamps() As DCplx, OutSamps() As Double, ByVal order As Long, _
    ByVal flags As Long)
     Call nspdCcsFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
     order, flags)
End Sub
Sub nspwCcsFftNip(inSamps() As WCplx, OutSamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwCcsFftNipP(inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
     order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspsReal2Fft(xSamps() As Single, ySamps() As Single, ByVal order As Long, _
    ByVal flags As Long)
     Call nspsReal2FftP(xSamps(LBound(xSamps)), ySamps(LBound(ySamps)), _
     order, flags)
End Sub
Sub nspsReal2FftNip(xInSamps() As Single, xOutSamps() As SCplx, _
    yInSamps() As Single, yOutSamps() As SCplx, ByVal order As Long, _
    ByVal flags As Long)
     Call nspsReal2FftNipP(xInSamps(LBound(xInSamps)), xOutSamps(LBound(xOutSamps)), _
     yInSamps(LBound(yInSamps)), yOutSamps(LBound(yOutSamps)), order, flags)
End Sub
Sub nspdReal2Fft(xSamps() As Double, ySamps() As Double, ByVal order As Long, _
    ByVal flags As Long)
     Call nspdReal2FftP(xSamps(LBound(xSamps)), ySamps(LBound(ySamps)), _
     order, flags)
End Sub
Sub nspdReal2FftNip(xInSamps() As Double, xOutSamps() As DCplx, _
    yInSamps() As Double, yOutSamps() As DCplx, ByVal order As Long, _
    ByVal flags As Long)
     Call nspdReal2FftNipP(xInSamps(LBound(xInSamps)), xOutSamps(LBound(xOutSamps)), _
     yInSamps(LBound(yInSamps)), yOutSamps(LBound(yOutSamps)), order, flags)
End Sub
Sub nspwReal2Fft(xSamps() As Integer, ySamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwReal2FftP(xSamps(LBound(xSamps)), ySamps(LBound(ySamps)), order, _
     flags, ScaleMode, ScaleFactor)
End Sub
Sub nspwReal2FftNip(xInSamps() As Integer, xOutSamps() As WCplx, _
    yInSamps() As Integer, yOutSamps() As WCplx, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwReal2FftNipP(xInSamps(LBound(xInSamps)), xOutSamps(LBound(xOutSamps)), _
     yInSamps(LBound(yInSamps)), yOutSamps(LBound(yOutSamps)), order, flags, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsCcs2Fft(xSamps() As Single, ySamps() As Single, ByVal order As Long, _
    ByVal flags As Long)
     Call nspsCcs2FftP(xSamps(LBound(xSamps)), ySamps(LBound(ySamps)), _
     order, flags)
End Sub
Sub nspdCcs2Fft(xSamps() As Double, ySamps() As Double, ByVal order As Long, _
    ByVal flags As Long)
     Call nspdCcs2FftP(xSamps(LBound(xSamps)), ySamps(LBound(ySamps)), _
     order, flags)
End Sub
Sub nspwCcs2Fft(xSamps() As Integer, ySamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwCcs2FftP(xSamps(LBound(xSamps)), ySamps(LBound(ySamps)), _
     order, flags, ScaleMode, ScaleFactor)
End Sub
Sub nspsCcs2FftNip(xInSamps() As SCplx, xOutSamps() As Single, yInSamps() As SCplx, _
    yOutSamps() As Single, ByVal order As Long, ByVal flags As Long)
     Call nspsCcs2FftNipP(xInSamps(LBound(xInSamps)), xOutSamps(LBound(xOutSamps)), _
     yInSamps(LBound(yInSamps)), yOutSamps(LBound(yOutSamps)), order, flags)
End Sub
Sub nspdCcs2FftNip(xInSamps() As DCplx, xOutSamps() As Double, yInSamps() As DCplx, _
    yOutSamps() As Double, ByVal order As Long, ByVal flags As Long)
     Call nspdCcs2FftNipP(xInSamps(LBound(xInSamps)), xOutSamps(LBound(xOutSamps)), _
     yInSamps(LBound(yInSamps)), yOutSamps(LBound(yOutSamps)), order, flags)
End Sub
Sub nspwCcs2FftNip(xInSamps() As WCplx, xOutSamps() As Integer, _
    yInSamps() As WCplx, yOutSamps() As Integer, ByVal order As Long, _
    ByVal flags As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
     Call nspwCcs2FftNipP(xInSamps(LBound(xInSamps)), xOutSamps(LBound(xOutSamps)), _
     yInSamps(LBound(yInSamps)), yOutSamps(LBound(yOutSamps)), order, flags, _
     ScaleMode, ScaleFactor)
End Sub
Sub nspsDct(Src() As Single, Dst() As Single, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspsDctP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspdDct(Src() As Double, Dst() As Double, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspdDctP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub
Sub nspwDct(Src() As Integer, Dst() As Integer, ByVal lenn As Long, _
    ByVal flags As Long)
    Call nspwDctP(Src(LBound(Src)), Dst(LBound(Dst)), lenn, flags)
End Sub

'CHAPTER 8.
'Filtering Functions.

Sub nspsFirlInit(taps() As Single, ByVal tapsLenn As Long, _
    tapStPtr As NSPFirTapState)
    Call nspsFirlInitP(taps(LBound(taps)), tapsLenn, tapStPtr)
End Sub
Sub nspsFirlInitMr(taps() As Single, ByVal tapsLenn As Long, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, tapStPtr As NSPFirTapState)
    Call nspsFirlInitMrP(taps(LBound(taps)), tapsLenn, upFactor, upPhase, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspsFirlInitDlyl(tapStPtr As NSPFirTapState, dlyl() As Single, _
    dlyStPtr As NSPFirDlyState)
    Call nspsFirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspcFirlInit(taps() As SCplx, ByVal tapsLenn As Long, _
    tapStPtr As NSPFirTapState)
    Call nspcFirlInitP(taps(LBound(taps)), tapsLenn, tapStPtr)
End Sub
Sub nspcFirlInitMr(taps() As SCplx, ByVal tapsLenn As Long, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, tapStPtr As NSPFirTapState)
    Call nspcFirlInitMrP(taps(LBound(taps)), tapsLenn, upFactor, upPhase, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspcFirlInitDlyl(tapStPtr As NSPFirTapState, dlyl() As SCplx, _
    dlyStPtr As NSPFirDlyState)
    Call nspcFirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspdFirlInit(taps() As Double, ByVal tapsLenn As Long, _
    tapStPtr As NSPFirTapState)
    Call nspdFirlInitP(taps(LBound(taps)), tapsLenn, tapStPtr)
End Sub
Sub nspdFirlInitMr(taps() As Double, ByVal tapsLenn As Long, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, tapStPtr As NSPFirTapState)
    Call nspdFirlInitMrP(taps(LBound(taps)), tapsLenn, upFactor, upPhase, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspdFirlInitDlyl(tapStPtr As NSPFirTapState, dlyl() As Double, _
    dlyStPtr As NSPFirDlyState)
    Call nspdFirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspzFirlInit(taps() As DCplx, ByVal tapsLenn As Long, _
    tapStPtr As NSPFirTapState)
    Call nspzFirlInitP(taps(LBound(taps)), tapsLenn, tapStPtr)
End Sub
Sub nspzFirlInitMr(taps() As DCplx, ByVal tapsLenn As Long, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, tapStPtr As NSPFirTapState)
    Call nspzFirlInitMrP(taps(LBound(taps)), tapsLenn, upFactor, upPhase, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspzFirlInitDlyl(tapStPtr As NSPFirTapState, dlyl() As DCplx, _
    dlyStPtr As NSPFirDlyState)
    Call nspzFirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspwFirlInit(taps() As Integer, ByVal tapsLenn As Long, _
    tapStPtr As NSPFirTapState)
    Call nspwFirlInitP(taps(LBound(taps)), tapsLenn, tapStPtr)
End Sub
Sub nspwFirlInitMr(taps() As Integer, ByVal tapsLenn As Long, _
    ByVal upFactor As Long, ByVal upPhase As Long, ByVal downFactor As Long, _
    ByVal downPhase As Long, tapStPtr As NSPFirTapState)
    Call nspwFirlInitMrP(taps(LBound(taps)), tapsLenn, upFactor, upPhase, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspwFirlInitDlyl(tapStPtr As NSPFirTapState, dlyl() As Integer, _
    dlyStPtr As NSPFirDlyState)
    Call nspwFirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspsbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As Single, OutSamps() As Single, ByVal numIters As Long)
    Call nspsbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    samp As SCplx) As SCplx
    nspcFirl = nspcFirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspcbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As SCplx, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspscbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As Single, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspscbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcsFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    samp As SCplx) As SCplx
    nspcsFirl = nspcsFirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspcsbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As SCplx, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcsbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As Double, OutSamps() As Double, ByVal numIters As Long)
    Call nspdbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    samp As DCplx) As DCplx
    nspzFirl = nspzFirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspzbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As DCplx, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdzbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As Double, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspdzbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzdFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    samp As DCplx) As DCplx
    nspzdFirl = nspzdFirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspzdbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As DCplx, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzdbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspwbFirl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    inSamps() As Integer, OutSamps() As Integer, ByVal numIters As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwbFirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters, ScaleMode, ScaleFactor)
End Sub
Sub nspsFirlGetTaps(tapStPtr As NSPFirTapState, outTaps() As Single)
    Call nspsFirlGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspsFirlSetTaps(inTaps() As Single, tapStPtr As NSPFirTapState)
    Call nspsFirlSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspcFirlGetTaps(tapStPtr As NSPFirTapState, outTaps() As SCplx)
    Call nspcFirlGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspcFirlSetTaps(inTaps() As SCplx, tapStPtr As NSPFirTapState)
    Call nspcFirlSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspdFirlGetTaps(tapStPtr As NSPFirTapState, outTaps() As Double)
    Call nspdFirlGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspdFirlSetTaps(inTaps() As Double, tapStPtr As NSPFirTapState)
    Call nspdFirlSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspzFirlGetTaps(tapStPtr As NSPFirTapState, outTaps() As DCplx)
    Call nspzFirlGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspzFirlSetTaps(inTaps() As DCplx, tapStPtr As NSPFirTapState)
    Call nspzFirlSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspwFirlGetTaps(tapStPtr As NSPFirTapState, outTaps() As Single)
    Call nspwFirlGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspwFirlSetTaps(inTaps() As Single, tapStPtr As NSPFirTapState)
    Call nspwFirlSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspsFirlGetDlyl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    outDlyl() As Single)
    Call nspsFirlGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspsFirlSetDlyl(tapStPtr As NSPFirTapState, inDlyl() As Single, _
    dlyStPtr As NSPFirDlyState)
    Call nspsFirlSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspcFirlGetDlyl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    outDlyl() As SCplx)
    Call nspcFirlGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspcFirlSetDlyl(tapStPtr As NSPFirTapState, inDlyl() As SCplx, _
    dlyStPtr As NSPFirDlyState)
    Call nspcFirlSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspdFirlGetDlyl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    outDlyl() As Double)
    Call nspdFirlGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspdFirlSetDlyl(tapStPtr As NSPFirTapState, inDlyl() As Double, _
    dlyStPtr As NSPFirDlyState)
    Call nspdFirlSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspzFirlGetDlyl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    outDlyl() As DCplx)
    Call nspzFirlGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspzFirlSetDlyl(tapStPtr As NSPFirTapState, inDlyl() As DCplx, _
    dlyStPtr As NSPFirDlyState)
    Call nspzFirlSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspwFirlGetDlyl(tapStPtr As NSPFirTapState, dlyStPtr As NSPFirDlyState, _
    outDlyl() As Integer)
    Call nspwFirlGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspwFirlSetDlyl(tapStPtr As NSPFirTapState, inDlyl() As Integer, _
    dlyStPtr As NSPFirDlyState)
    Call nspwFirlSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspsFirInit(tapVals() As Single, ByVal tapsLen As Long, _
    dlyVals() As Single, statePtr As NSPFirState)
    Call nspsFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspsFirInitMr(tapVals() As Single, ByVal tapsLen As Long, _
    dlyVals() As Single, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspsFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspcFirInit(tapVals() As SCplx, ByVal tapsLen As Long, _
    dlyVals() As SCplx, statePtr As NSPFirState)
    Call nspcFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspcFirInitMr(tapVals() As SCplx, ByVal tapsLen As Long, _
    dlyVals() As SCplx, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspcFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspscFirInit(tapVals() As SCplx, ByVal tapsLen As Long, _
    dlyVals() As Single, statePtr As NSPFirState)
    Call nspscFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspscFirInitMr(tapVals() As SCplx, ByVal tapsLen As Long, _
    dlyVals() As Single, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspscFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspcsFirInit(tapVals() As Single, ByVal tapsLen As Long, _
    dlyVals() As SCplx, statePtr As NSPFirState)
    Call nspcsFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspcsFirInitMr(tapVals() As Single, ByVal tapsLen As Long, _
    dlyVals() As SCplx, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspcsFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspdFirInit(tapVals() As Double, ByVal tapsLen As Long, _
    dlyVals() As Double, statePtr As NSPFirState)
    Call nspdFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspdFirInitMr(tapVals() As Double, ByVal tapsLen As Long, _
    dlyVals() As Double, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspdFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspzFirInit(tapVals() As DCplx, ByVal tapsLen As Long, _
    dlyVals() As DCplx, statePtr As NSPFirState)
    Call nspzFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspzFirInitMr(tapVals() As DCplx, ByVal tapsLen As Long, _
    dlyVals() As DCplx, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspzFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspdzFirInit(tapVals() As DCplx, ByVal tapsLen As Long, _
    dlyVals() As Double, statePtr As NSPFirState)
    Call nspdzFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspdzFirInitMr(tapVals() As DCplx, ByVal tapsLen As Long, _
    dlyVals() As Double, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspdzFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspzdFirInit(tapVals() As Double, ByVal tapsLen As Long, _
    dlyVals() As DCplx, statePtr As NSPFirState)
    Call nspzdFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspzdFirInitMr(tapVals() As Double, ByVal tapsLen As Long, _
    dlyVals() As DCplx, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspzdFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspwFirInit(tapVals() As Integer, ByVal tapsLen As Long, _
    dlyVals() As Integer, statePtr As NSPFirState)
    Call nspwFirInitP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), statePtr)
End Sub
Sub nspwFirInitMr(tapVals() As Integer, ByVal tapsLen As Long, _
    dlyVals() As Integer, ByVal upFactor As Long, ByVal upPhase As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPFirState)
    Call nspwFirInitMrP(tapVals(LBound(tapVals)), tapsLen, _
    dlyVals(LBound(dlyVals)), upFactor, upPhase, downFactor, downPhase, _
    statePtr)
End Sub
Sub nspsbFir(statePtr As NSPFirState, inSamps() As Single, _
    OutSamps() As Single, ByVal numIters As Long)
    Call nspsbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcFir(statePtr As NSPFirState, samp As SCplx) As SCplx
    nspcFir = nspcFirP(statePtr, samp.re, samp.im)
End Function
Sub nspcbFir(statePtr As NSPFirState, inSamps() As SCplx, _
    OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspscbFir(statePtr As NSPFirState, inSamps() As Single, _
    OutSamps() As SCplx, ByVal numIters As Long)
    Call nspscbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcsFir(statePtr As NSPFirState, samp As SCplx) As SCplx
    nspcsFir = nspcsFirP(statePtr, samp.re, samp.im)
End Function
Sub nspcsbFir(statePtr As NSPFirState, inSamps() As SCplx, _
    OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcsbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdbFir(statePtr As NSPFirState, inSamps() As Double, _
    OutSamps() As Double, ByVal numIters As Long)
    Call nspdbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzFir(statePtr As NSPFirState, samp As DCplx) As DCplx
    nspzFir = nspzFirP(statePtr, samp.re, samp.im)
End Function
Sub nspzbFir(statePtr As NSPFirState, inSamps() As DCplx, _
    OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdzbFir(statePtr As NSPFirState, inSamps() As Double, _
    OutSamps() As DCplx, ByVal numIters As Long)
    Call nspdzbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzdFir(statePtr As NSPFirState, samp As DCplx) As DCplx
    nspzdFir = nspzdFirP(statePtr, samp.re, samp.im)
End Function
Sub nspzdbFir(statePtr As NSPFirState, inSamps() As DCplx, _
    OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzdbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspwbFir(statePtr As NSPFirState, inSamps() As Integer, _
    OutSamps() As Integer, ByVal numIters As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwbFirP(statePtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters, ScaleMode, ScaleFactor)
End Sub
Sub nspsFirGetTaps(statePtr As NSPFirState, outTaps() As Single)
    Call nspsFirGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspsFirSetTaps(inTaps() As Single, statePtr As NSPFirState)
    Call nspsFirSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspcFirGetTaps(statePtr As NSPFirState, outTaps() As SCplx)
    Call nspcFirGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspcFirSetTaps(inTaps() As SCplx, statePtr As NSPFirState)
    Call nspcFirSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspdFirGetTaps(statePtr As NSPFirState, outTaps() As Double)
    Call nspdFirGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspdFirSetTaps(inTaps() As Double, statePtr As NSPFirState)
    Call nspdFirSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspzFirGetTaps(statePtr As NSPFirState, outTaps() As DCplx)
    Call nspzFirGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspzFirSetTaps(inTaps() As DCplx, statePtr As NSPFirState)
    Call nspzFirSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspwFirGetTaps(statePtr As NSPFirState, outTaps() As Single)
    Call nspwFirGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspwFirSetTaps(inTaps() As Single, statePtr As NSPFirState)
    Call nspwFirSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspsFirGetDlyl(statePtr As NSPFirState, outDlyl() As Single)
    Call nspsFirGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspsFirSetDlyl(inDlyl() As Single, statePtr As NSPFirState)
    Call nspsFirSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspcFirGetDlyl(statePtr As NSPFirState, outDlyl() As SCplx)
    Call nspcFirGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspcFirSetDlyl(inDlyl() As SCplx, statePtr As NSPFirState)
    Call nspcFirSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspdFirGetDlyl(statePtr As NSPFirState, outDlyl() As Double)
    Call nspdFirGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspdFirSetDlyl(inDlyl() As Double, statePtr As NSPFirState)
    Call nspdFirSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspzFirGetDlyl(statePtr As NSPFirState, outDlyl() As DCplx)
    Call nspzFirGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspzFirSetDlyl(inDlyl() As DCplx, statePtr As NSPFirState)
    Call nspzFirSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspwFirGetDlyl(statePtr As NSPFirState, outDlyl() As Integer)
    Call nspwFirGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspwFirSetDlyl(inDlyl() As Integer, statePtr As NSPFirState)
    Call nspwFirSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspdFirLowpass(ByVal rFreq As Double, taps() As Double, _
    ByVal tapsLen As Integer, ByVal winType As NSP_WindowType, _
    ByVal doNormal As Integer)
    Call nspdFirLowpassP(rFreq, taps(LBound(taps)), tapsLen, _
         winType, doNormal)
End Sub
Sub nspdFirHighpass(ByVal rFreq As Double, taps() As Double, _
    ByVal tapsLen As Integer, ByVal winType As NSP_WindowType, _
    ByVal doNormal As Integer)
    Call nspdFirHighpassP(rFreq, taps(LBound(taps)), tapsLen, _
         winType, doNormal)
End Sub
Sub nspdFirBandpass(ByVal rLowFreq As Double, ByVal rHighFreq As Double, _
    taps() As Double, ByVal tapsLen As Integer, _
    ByVal winType As NSP_WindowType, ByVal doNormal As Integer)
    Call nspdFirBandpassP(rLowFreq, rHighFreq, taps(LBound(taps)), _
         tapsLen, winType, doNormal)
End Sub
Sub nspdFirBandstop(ByVal rLowFreq As Double, ByVal rHighFreq As Double, _
    taps() As Double, ByVal tapsLen As Integer, _
    ByVal winType As NSP_WindowType, ByVal doNormal As Integer)
    Call nspdFirBandstopP(rLowFreq, rHighFreq, taps(LBound(taps)), _
         tapsLen, winType, doNormal)
End Sub
Sub nspsLmslInit(ByVal lmsType As Long, taps() As Single, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
    Call nspsLmslInitP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    tapStPtr)
End Sub
Sub nspsLmslInitMr(ByVal lmsType As Long, taps() As Single, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
    Call nspsLmslInitMrP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspsLmslInitDlyl(tapStPtr As NSPLmsTapState, dlyl() As Single, _
    ByVal adaptB As Long, dlyStPtr As NSPLmsDlyState)
    Call nspsLmslInitDlylP(tapStPtr, dlyl(LBound(dlyl)), adaptB, dlyStPtr)
End Sub
Sub nspcLmslInit(ByVal lmsType As Long, taps() As SCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
    Call nspcLmslInitP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    tapStPtr)
End Sub
Sub nspcLmslInitMr(ByVal lmsType As Long, taps() As SCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
    Call nspcLmslInitMrP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspcLmslInitDlyl(tapStPtr As NSPLmsTapState, dlyl() As SCplx, _
    ByVal adaptB As Long, dlyStPtr As NSPLmsDlyState)
    Call nspcLmslInitDlylP(tapStPtr, dlyl(LBound(dlyl)), adaptB, dlyStPtr)
End Sub
Sub nspdLmslInit(ByVal lmsType As Long, taps() As Double, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
    Call nspdLmslInitP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    tapStPtr)
End Sub
Sub nspdLmslInitMr(ByVal lmsType As Long, taps() As Double, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
    Call nspdLmslInitMrP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspdLmslInitDlyl(tapStPtr As NSPLmsTapState, dlyl() As Double, _
    ByVal adaptB As Long, dlyStPtr As NSPLmsDlyState)
    Call nspdLmslInitDlylP(tapStPtr, dlyl(LBound(dlyl)), adaptB, dlyStPtr)
End Sub
Sub nspzLmslInit(ByVal lmsType As Long, taps() As DCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    tapStPtr As NSPLmsTapState)
    Call nspzLmslInitP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    tapStPtr)
End Sub
Sub nspzLmslInitMr(ByVal lmsType As Long, taps() As DCplx, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal Leak As Single, ByVal errDly As Long, _
    ByVal downFactor As Long, ByVal downPhase As Long, tapStPtr As NSPLmsTapState)
    Call nspzLmslInitMrP(lmsType, taps(LBound(taps)), tapsLenn, Step, Leak, errDly, _
    downFactor, downPhase, tapStPtr)
End Sub
Sub nspzLmslInitDlyl(tapStPtr As NSPLmsTapState, dlyl() As DCplx, _
    ByVal adaptB As Long, dlyStPtr As NSPLmsDlyState)
    Call nspzLmslInitDlylP(tapStPtr, dlyl(LBound(dlyl)), adaptB, dlyStPtr)
End Sub
Sub nspwLmslInit(ByVal lmsType As Long, taps() As Single, ByVal tapsLenn As Long, _
    ByVal Step As Single, ByVal errDly As Long, tapStPtr As NSPWLmsTapState)
    Call nspwLmslInitP(lmsType, taps(LBound(taps)), tapsLenn, Step, errDly, tapStPtr)
End Sub
Sub nspwLmslInitDlyl(tapStPtr As NSPWLmsTapState, dlyl() As Integer, _
    dlyStPtr As NSPWLmsDlyState)
    Call nspwLmslInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspsLmslGetTaps(tapStPtr As NSPLmsTapState, outTaps() As Single)
    Call nspsLmslGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspsLmslSetTaps(inTaps() As Single, tapStPtr As NSPLmsTapState)
    Call nspsLmslSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspcLmslGetTaps(tapStPtr As NSPLmsTapState, outTaps() As SCplx)
    Call nspcLmslGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspcLmslSetTaps(inTaps() As SCplx, tapStPtr As NSPLmsTapState)
    Call nspcLmslSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspdLmslGetTaps(tapStPtr As NSPLmsTapState, outTaps() As Double)
    Call nspdLmslGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspdLmslSetTaps(inTaps() As Double, tapStPtr As NSPLmsTapState)
    Call nspdLmslSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspzLmslGetTaps(tapStPtr As NSPLmsTapState, outTaps() As DCplx)
    Call nspzLmslGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspzLmslSetTaps(inTaps() As DCplx, tapStPtr As NSPLmsTapState)
    Call nspzLmslSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspwLmslGetTaps(tapStPtr As NSPWLmsTapState, outTaps() As Single)
    Call nspwLmslGetTapsP(tapStPtr, outTaps(LBound(outTaps)))
End Sub
Sub nspwLmslSetTaps(inTaps() As Single, tapStPtr As NSPWLmsTapState)
    Call nspwLmslSetTapsP(inTaps(LBound(inTaps)), tapStPtr)
End Sub
Sub nspsLmslGetDlyl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    outDlyl() As Single)
    Call nspsLmslGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspsLmslSetDlyl(tapStPtr As NSPLmsTapState, inDlyl() As Single, _
    dlyStPtr As NSPLmsDlyState)
    Call nspsLmslSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspcLmslGetDlyl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    outDlyl() As SCplx)
    Call nspcLmslGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspcLmslSetDlyl(tapStPtr As NSPLmsTapState, inDlyl() As SCplx, _
    dlyStPtr As NSPLmsDlyState)
    Call nspcLmslSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspdLmslGetDlyl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    outDlyl() As Double)
    Call nspdLmslGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspdLmslSetDlyl(inDlyl() As Double, tapStPtr As NSPLmsTapState, _
    dlyStPtr As NSPLmsDlyState)
    Call nspdLmslSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspzLmslGetDlyl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    outDlyl() As DCplx)
    Call nspzLmslGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspzLmslSetDlyl(tapStPtr As NSPLmsTapState, inDlyl() As DCplx, _
    dlyStPtr As NSPLmsDlyState)
    Call nspzLmslSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Sub nspwLmslGetDlyl(tapStPtr As NSPWLmsTapState, dlyStPtr As NSPWLmsDlyState, _
    outDlyl() As Integer)
    Call nspwLmslGetDlylP(tapStPtr, dlyStPtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspwLmslSetDlyl(tapStPtr As NSPWLmsTapState, inDlyl() As Integer, _
    dlyStPtr As NSPWLmsDlyState)
    Call nspwLmslSetDlylP(tapStPtr, inDlyl(LBound(inDlyl)), dlyStPtr)
End Sub
Function nspsbLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Single, ByVal Errr As Single) As Single
    nspsbLmsl = nspsbLmslP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), Errr)
End Function
Function nspcLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As SCplx, Errr As SCplx) As SCplx
    nspcLmsl = nspcLmslP(tapStPtr, dlyStPtr, samp.re, samp.im, Errr.re, Errr.im)
End Function
Function nspcbLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As SCplx, Errr As SCplx) As SCplx
    nspcbLmsl = nspcbLmslP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    Errr.re, Errr.im)
End Function
Function nspscLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As Single, Errr As SCplx) As SCplx
    nspscLmsl = nspscLmslP(tapStPtr, dlyStPtr, samp, Errr.re, Errr.im)
End Function
Function nspscbLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Single, Errr As SCplx) As SCplx
    nspscbLmsl = nspscbLmslP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    Errr.re, Errr.im)
End Function
Function nspdbLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Double, ByVal Errr As Double) As Double
    nspdbLmsl = nspdbLmslP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), Errr)
End Function
Function nspzLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As DCplx, Errr As DCplx) As DCplx
    nspzLmsl = nspzLmslP(tapStPtr, dlyStPtr, samp.re, samp.im, Errr.re, Errr.im)
End Function
Function nspzbLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As DCplx, Errr As DCplx) As DCplx
    nspzbLmsl = nspzbLmslP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    Errr.re, Errr.im)
End Function
Function nspdzLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As Double, Errr As DCplx) As DCplx
    nspdzLmsl = nspdzLmslP(tapStPtr, dlyStPtr, samp, Errr.re, Errr.im)
End Function
Function nspdzbLmsl(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Double, Errr As DCplx) As DCplx
    nspdzbLmsl = nspdzbLmslP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    Errr.re, Errr.im)
End Function
Sub nspsbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Single, OutSamps() As Single, ByVal numIters As Long)
    Call nspsbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As SCplx) As SCplx
    nspcLmslNa = nspcLmslNaP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspcbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As SCplx, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspscbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Single, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspscbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcsLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As SCplx) As SCplx
    nspcsLmslNa = nspcsLmslNaP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspcsbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As SCplx, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcsbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Double, OutSamps() As Double, ByVal numIters As Long)
    Call nspdbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As DCplx) As DCplx
    nspzLmslNa = nspzLmslNaP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspzbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As DCplx, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdzbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As Double, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspdzbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzdLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    samp As DCplx) As DCplx
    nspzdLmslNa = nspzdLmslNaP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspzdbLmslNa(tapStPtr As NSPLmsTapState, dlyStPtr As NSPLmsDlyState, _
    inSamps() As DCplx, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzdbLmslNaP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspsLmsInit(ByVal lmsType As Long, tapVals() As Single, ByVal tapsLenn As Long, _
    dlyVals() As Single, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, statePtr As NSPLmsState)
    Call nspsLmsInitP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, statePtr)
End Sub
Sub nspsLmsInitMr(ByVal lmsType As Long, tapVals() As Single, ByVal tapsLenn As Long, _
    dlyVals() As Single, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPLmsState)
    Call nspsLmsInitMrP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, downFactor, downPhase, statePtr)
End Sub
Sub nspcLmsInit(ByVal lmsType As Long, tapVals() As SCplx, ByVal tapsLenn As Long, _
    dlyVals() As SCplx, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, statePtr As NSPLmsState)
    Call nspcLmsInitP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, statePtr)
End Sub
Sub nspcLmsInitMr(ByVal lmsType As Long, tapVals() As SCplx, ByVal tapsLenn As Long, _
    dlyVals() As SCplx, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPLmsState)
    Call nspcLmsInitMrP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, downFactor, downPhase, statePtr)
End Sub
Sub nspscLmsInit(ByVal lmsType As Long, tapVals() As SCplx, ByVal tapsLenn As Long, _
    dlyVals() As Single, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, statePtr As NSPLmsState)
    Call nspscLmsInitP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, statePtr)
End Sub
Sub nspscLmsInitMr(ByVal lmsType As Long, tapVals() As SCplx, ByVal tapsLenn As Long, _
    dlyVals() As Single, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPLmsState)
    Call nspscLmsInitMrP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, downFactor, downPhase, statePtr)
End Sub
Sub nspdLmsInit(ByVal lmsType As Long, tapVals() As Double, ByVal tapsLenn As Long, _
    dlyVals() As Double, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, statePtr As NSPLmsState)
    Call nspdLmsInitP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, statePtr)
End Sub
Sub nspdLmsInitMr(ByVal lmsType As Long, tapVals() As Double, ByVal tapsLenn As Long, _
    dlyVals() As Double, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPLmsState)
    Call nspdLmsInitMrP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, downFactor, downPhase, statePtr)
End Sub
Sub nspzLmsInit(ByVal lmsType As Long, tapVals() As DCplx, ByVal tapsLenn As Long, _
    dlyVals() As DCplx, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, statePtr As NSPLmsState)
    Call nspzLmsInitP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, statePtr)
End Sub
Sub nspzLmsInitMr(ByVal lmsType As Long, tapVals() As DCplx, ByVal tapsLenn As Long, _
    dlyVals() As DCplx, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPLmsState)
    Call nspzLmsInitMrP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, downFactor, downPhase, statePtr)
End Sub
Sub nspdzLmsInit(ByVal lmsType As Long, tapVals() As DCplx, ByVal tapsLenn As Long, _
    dlyVals() As Double, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, statePtr As NSPLmsState)
    Call nspdzLmsInitP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, statePtr)
End Sub
Sub nspdzLmsInitMr(ByVal lmsType As Long, tapVals() As DCplx, ByVal tapsLenn As Long, _
    dlyVals() As Double, ByVal Step As Single, ByVal Leak As Single, _
    ByVal errDly As Long, ByVal downFactor As Long, ByVal downPhase As Long, _
    statePtr As NSPLmsState)
    Call nspdzLmsInitMrP(lmsType, tapVals(LBound(tapVals)), tapsLenn, _
    dlyVals(LBound(dlyVals)), Step, Leak, errDly, downFactor, downPhase, statePtr)
End Sub
Function nspsbLms(statePtr As NSPLmsState, inSamps() As Single, _
    ByVal Errr As Single) As Single
    nspsbLms = nspsbLmsP(statePtr, inSamps(LBound(inSamps)), Errr)
End Function
Function nspcLms(statePtr As NSPLmsState, samp As SCplx, Errr As SCplx) As SCplx
    nspcLms = nspcLmsP(statePtr, samp.re, samp.im, Errr.re, Errr.im)
End Function
Function nspcbLms(statePtr As NSPLmsState, inSamps() As SCplx, Errr As SCplx) _
    As SCplx
    nspcbLms = nspcbLmsP(statePtr, inSamps(LBound(inSamps)), Errr.re, Errr.im)
End Function
Function nspscLms(statePtr As NSPLmsState, ByVal samp As Single, Errr As SCplx) _
    As SCplx
    nspscLms = nspscLmsP(statePtr, samp, Errr.re, Errr.im)
End Function
Function nspscbLms(statePtr As NSPLmsState, inSamps() As Single, Errr As SCplx) _
    As SCplx
    nspscbLms = nspscbLmsP(statePtr, inSamps(LBound(inSamps)), Errr.re, Errr.im)
End Function
Function nspdbLms(statePtr As NSPLmsState, inSamps() As Double, _
    ByVal Errr As Double) As Double
    nspdbLms = nspdbLmsP(statePtr, inSamps(LBound(inSamps)), Errr)
End Function
Function nspzLms(statePtr As NSPLmsState, samp As DCplx, Errr As DCplx) As DCplx
    nspzLms = nspzLmsP(statePtr, samp.re, samp.im, Errr.re, Errr.im)
End Function
Function nspzbLms(statePtr As NSPLmsState, inSamps() As DCplx, Errr As DCplx) _
    As DCplx
    nspzbLms = nspzbLmsP(statePtr, inSamps(LBound(inSamps)), Errr.re, Errr.im)
End Function
Function nspdzLms(statePtr As NSPLmsState, ByVal samp As Double, Errr As DCplx) _
    As DCplx
    nspdzLms = nspdzLmsP(statePtr, samp, Errr.re, Errr.im)
End Function
Function nspdzbLms(statePtr As NSPLmsState, inSamps() As Double, Errr As DCplx) _
    As DCplx
    nspdzbLms = nspdzbLmsP(statePtr, inSamps(LBound(inSamps)), Errr.re, Errr.im)
End Function
Sub nspsLmsGetTaps(statePtr As NSPLmsState, outTaps() As Single)
    Call nspsLmsGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspsLmsSetTaps(inTaps() As Single, statePtr As NSPLmsState)
    Call nspsLmsSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspcLmsGetTaps(statePtr As NSPLmsState, outTaps() As SCplx)
    Call nspcLmsGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspcLmsSetTaps(inTaps() As SCplx, statePtr As NSPLmsState)
    Call nspcLmsSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspdLmsGetTaps(statePtr As NSPLmsState, outTaps() As Double)
    Call nspdLmsGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspdLmsSetTaps(inTaps() As Double, statePtr As NSPLmsState)
    Call nspdLmsSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspzLmsGetTaps(statePtr As NSPLmsState, outTaps() As DCplx)
    Call nspzLmsGetTapsP(statePtr, outTaps(LBound(outTaps)))
End Sub
Sub nspzLmsSetTaps(inTaps() As DCplx, statePtr As NSPLmsState)
    Call nspzLmsSetTapsP(inTaps(LBound(inTaps)), statePtr)
End Sub
Sub nspsLmsGetDlyl(statePtr As NSPLmsState, outDlyl() As Single)
    Call nspsLmsGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspsLmsSetDlyl(inDlyl() As Single, statePtr As NSPLmsState)
    Call nspsLmsSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspcLmsGetDlyl(statePtr As NSPLmsState, outDlyl() As SCplx)
    Call nspcLmsGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspcLmsSetDlyl(inDlyl() As SCplx, statePtr As NSPLmsState)
    Call nspcLmsSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspdLmsGetDlyl(statePtr As NSPLmsState, outDlyl() As Double)
    Call nspdLmsGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspdLmsSetDlyl(inDlyl() As Double, statePtr As NSPLmsState)
    Call nspdLmsSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspzLmsGetDlyl(statePtr As NSPLmsState, outDlyl() As DCplx)
    Call nspzLmsGetDlylP(statePtr, outDlyl(LBound(outDlyl)))
End Sub
Sub nspzLmsSetDlyl(inDlyl() As DCplx, statePtr As NSPLmsState)
    Call nspzLmsSetDlylP(inDlyl(LBound(inDlyl)), statePtr)
End Sub
Sub nspsbLmsDes(statePtr As NSPLmsState, inSamps() As Single, desSamps() As Single, _
    OutSamps() As Single, ByVal numIters As Long)
    Call nspsbLmsDesP(statePtr, inSamps(LBound(inSamps)), desSamps(LBound(desSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcLmsDes(statePtr As NSPLmsState, samp As SCplx, des As SCplx) As SCplx
    nspcLmsDes = nspcLmsDesP(statePtr, samp.re, samp.im, des.re, des.im)
End Function
Sub nspcbLmsDes(statePtr As NSPLmsState, inSamps() As SCplx, desSamps() As SCplx, _
    OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcbLmsDesP(statePtr, inSamps(LBound(inSamps)), desSamps(LBound(desSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspscLmsDes(statePtr As NSPLmsState, ByVal samp As Single, des As SCplx) _
    As SCplx
    nspscLmsDes = nspscLmsDesP(statePtr, samp, des.re, des.im)
End Function
Sub nspscbLmsDes(statePtr As NSPLmsState, inSamps() As Single, desSamps() As SCplx, _
    OutSamps() As SCplx, ByVal numIters As Long)
    Call nspscbLmsDesP(statePtr, inSamps(LBound(inSamps)), _
    desSamps(LBound(desSamps)), OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdbLmsDes(statePtr As NSPLmsState, inSamps() As Double, desSamps() As Double, _
    OutSamps() As Double, ByVal numIters As Long)
    Call nspdbLmsDesP(statePtr, inSamps(LBound(inSamps)), desSamps(LBound(desSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzLmsDes(statePtr As NSPLmsState, samp As DCplx, des As DCplx) As DCplx
    nspzLmsDes = nspzLmsDesP(statePtr, samp.re, samp.im, des.re, des.im)
End Function
Sub nspzbLmsDes(statePtr As NSPLmsState, inSamps() As DCplx, desSamps() As DCplx, _
    OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzbLmsDesP(statePtr, inSamps(LBound(inSamps)), desSamps(LBound(desSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspdzLmsDes(statePtr As NSPLmsState, ByVal samp As Double, des As DCplx) _
    As DCplx
    nspdzLmsDes = nspdzLmsDesP(statePtr, samp, des.re, des.im)
End Function
Sub nspdzbLmsDes(statePtr As NSPLmsState, inSamps() As Double, desSamps() As DCplx, _
    OutSamps() As DCplx, ByVal numIters As Long)
    Call nspdzbLmsDesP(statePtr, inSamps(LBound(inSamps)), desSamps(LBound(desSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspcLmsSetErrVal(Errr As SCplx, statePtr As NSPLmsState)
    Call nspcLmsSetErrValP(Errr.re, Errr.im, statePtr)
End Sub
Sub nspzLmsSetErrVal(Errr As DCplx, statePtr As NSPLmsState)
    Call nspzLmsSetErrValP(Errr.re, Errr.im, statePtr)
End Sub
Sub nspsbMedianFilter1(InOut() As Single, ByVal winLength As Long, _
    ByVal maskSize As Long)
    Call nspsbMedianFilter1P(InOut(LBound(InOut)), winLength, maskSize)
End Sub
Sub nspdbMedianFilter1(InOut() As Double, ByVal winLength As Long, _
    ByVal maskSize As Long)
    Call nspdbMedianFilter1P(InOut(LBound(InOut)), winLength, maskSize)
End Sub
Sub nspwbMedianFilter1(InOut() As Integer, ByVal winLength As Long, _
    ByVal maskSize As Long)
    Call nspwbMedianFilter1P(InOut(LBound(InOut)), winLength, maskSize)
End Sub
Sub nspsbMedianFilter2(medIn() As Single, medOut() As Single, ByVal winLength As Long, _
    ByVal maskSize As Long)
    Call nspsbMedianFilter2P(medIn(LBound(medIn)), medOut(LBound(medOut)), winLength, _
    maskSize)
End Sub
Sub nspdbMedianFilter2(medIn() As Double, medOut() As Double, ByVal winLength As Long, _
    ByVal maskSize As Long)
    Call nspdbMedianFilter2P(medIn(LBound(medIn)), medOut(LBound(medOut)), winLength, _
    maskSize)
End Sub
Sub nspwbMedianFilter2(medIn() As Integer, medOut() As Integer, ByVal winLength As Long, _
    ByVal maskSize As Long)
    Call nspwbMedianFilter2P(medIn(LBound(medIn)), medOut(LBound(medOut)), winLength, _
    maskSize)
End Sub
Sub nspsIirlInit(ByVal iirType As Long, taps() As Single, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
    Call nspsIirlInitP(iirType, taps(LBound(taps)), order, tapStPtr)
End Sub
Sub nspsIirlInitBq(ByVal iirType As Long, taps() As Single, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
    Call nspsIirlInitBqP(iirType, taps(LBound(taps)), numQuads, tapStPtr)
End Sub
Sub nspsIirlInitDlyl(tapStPtr As NSPIirTapState, dlyl() As Single, _
    dlyStPtr As NSPIirDlyState)
    Call nspsIirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspcIirlInit(ByVal iirType As Long, taps() As SCplx, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
    Call nspcIirlInitP(iirType, taps(LBound(taps)), order, tapStPtr)
End Sub
Sub nspcIirlInitBq(ByVal iirType As Long, taps() As SCplx, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
    Call nspcIirlInitBqP(iirType, taps(LBound(taps)), numQuads, tapStPtr)
End Sub
Sub nspcIirlInitDlyl(tapStPtr As NSPIirTapState, dlyl() As SCplx, _
    dlyStPtr As NSPIirDlyState)
    Call nspcIirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspdIirlInit(ByVal iirType As Long, taps() As Double, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
    Call nspdIirlInitP(iirType, taps(LBound(taps)), order, tapStPtr)
End Sub
Sub nspdIirlInitBq(ByVal iirType As Long, taps() As Double, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
    Call nspdIirlInitBqP(iirType, taps(LBound(taps)), numQuads, tapStPtr)
End Sub
Sub nspdIirlInitDlyl(tapStPtr As NSPIirTapState, dlyl() As Double, _
    dlyStPtr As NSPIirDlyState)
    Call nspdIirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspzIirlInit(ByVal iirType As Long, taps() As DCplx, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
    Call nspzIirlInitP(iirType, taps(LBound(taps)), order, tapStPtr)
End Sub
Sub nspzIirlInitBq(ByVal iirType As Long, taps() As DCplx, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
    Call nspzIirlInitBqP(iirType, taps(LBound(taps)), numQuads, tapStPtr)
End Sub
Sub nspzIirlInitDlyl(tapStPtr As NSPIirTapState, dlyl() As DCplx, _
    dlyStPtr As NSPIirDlyState)
    Call nspzIirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspwIirlInit(ByVal iirType As Long, taps() As Single, ByVal order As Long, _
    tapStPtr As NSPIirTapState)
    Call nspwIirlInitP(iirType, taps(LBound(taps)), order, tapStPtr)
End Sub
Sub nspwIirlInitBq(ByVal iirType As Long, taps() As Single, ByVal numQuads As Long, _
    tapStPtr As NSPIirTapState)
    Call nspwIirlInitBqP(iirType, taps(LBound(taps)), numQuads, tapStPtr)
End Sub
Sub nspwIirlInitDlyl(tapStPtr As NSPIirTapState, dlyl() As Long, _
    dlyStPtr As NSPIirDlyState)
    Call nspwIirlInitDlylP(tapStPtr, dlyl(LBound(dlyl)), dlyStPtr)
End Sub
Sub nspsbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As Single, OutSamps() As Single, ByVal numIters As Long)
    Call nspsbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    samp As SCplx) As SCplx
    nspcIirl = nspcIirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspcbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As SCplx, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspscbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As Single, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspscbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspcsIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    samp As SCplx) As SCplx
    nspcsIirl = nspcsIirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspcsbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As SCplx, OutSamps() As SCplx, ByVal numIters As Long)
    Call nspcsbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As Double, OutSamps() As Double, ByVal numIters As Long)
    Call nspdbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    samp As DCplx) As DCplx
    nspzIirl = nspzIirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspzbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As DCplx, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspdzbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As Double, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspdzbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Function nspzdIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    samp As DCplx) As DCplx
    nspzdIirl = nspzdIirlP(tapStPtr, dlyStPtr, samp.re, samp.im)
End Function
Sub nspzdbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As DCplx, OutSamps() As DCplx, ByVal numIters As Long)
    Call nspzdbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters)
End Sub
Sub nspwbIirl(tapStPtr As NSPIirTapState, dlyStPtr As NSPIirDlyState, _
    inSamps() As Integer, OutSamps() As Integer, ByVal numIters As Long, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwbIirlP(tapStPtr, dlyStPtr, inSamps(LBound(inSamps)), _
    OutSamps(LBound(OutSamps)), numIters, ScaleMode, ScaleFactor)
End Sub
Sub nspsIirInit(ByVal iirType As Long, tapVals() As Single, ByVal order As Long, _
    statePtr As NSPIirState)
    Call nspsIirInitP(iirType, tapVals(LBound(tapVals)), order, statePtr)
End Sub
Sub nspsIirInitBq(ByVal iirType As Long, tapVals() As Single, ByVal numQuads As Long, _
    statePtr As NSPIirState)
    Call nspsIirInitBqP(iirType, tapVals(LBound(tapVals)), numQuads, statePtr)
End Sub
Sub nspdIirInit(ByVal iirType As Long, tapVals() As Double, ByVal order As Long, _
    statePtr As NSPIirState)
    Call nspdIirInitP(iirType, tapVals(LBound(tapVals)), order, statePtr)
End Sub
Sub nspdIirInitBq(ByVal iirType As Long, tapVals() As Double, ByVal numQuads As Long, _
    statePtr As NSPIirState)
    Call nspdIirInitBqP(iirType, tapVals(LBound(tapVals)), numQuads, statePtr)
End Sub
Sub nspwIirInit(ByVal iirType As Long, tapVals() As Single, ByVal order As Long, _
    statePtr As NSPIirState)
    Call nspwIirInitP(iirType, tapVals(LBound(tapVals)), order, statePtr)
End Sub
Sub nspwIirInitBq(ByVal iirType As Long, tapVals() As Single, ByVal numQuads As Long, _
    statePtr As NSPIirState)
    Call nspwIirInitBqP(iirType, tapVals(LBound(tapVals)), numQuads, statePtr)
End Sub
Sub nspsbIir(statePtr As NSPIirState, inSamps() As Single, OutSamps() As Single, _
    ByVal numIters As Long)
    Call nspsbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Function nspcIir(statePtr As NSPIirState, samp As SCplx) As SCplx
    nspcIir = nspcIirP(statePtr, samp.re, samp.im)
End Function
Sub nspcbIir(statePtr As NSPIirState, inSamps() As SCplx, OutSamps() As SCplx, _
    ByVal numIters As Long)
    Call nspcbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Sub nspscbIir(statePtr As NSPIirState, inSamps() As Single, OutSamps() As SCplx, _
    ByVal numIters As Long)
    Call nspscbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Function nspcsIir(statePtr As NSPIirState, samp As SCplx) As SCplx
    nspcsIir = nspcsIirP(statePtr, samp.re, samp.im)
End Function
Sub nspcsbIir(statePtr As NSPIirState, inSamps() As SCplx, OutSamps() As SCplx, _
    ByVal numIters As Long)
    Call nspcsbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Sub nspdbIir(statePtr As NSPIirState, inSamps() As Double, OutSamps() As Double, _
    ByVal numIters As Long)
    Call nspdbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Function nspzIir(statePtr As NSPIirState, samp As DCplx) As DCplx
    nspzIir = nspzIirP(statePtr, samp.re, samp.im)
End Function
Sub nspzbIir(statePtr As NSPIirState, inSamps() As DCplx, OutSamps() As DCplx, _
    ByVal numIters As Long)
    Call nspzbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Sub nspdzbIir(statePtr As NSPIirState, inSamps() As Double, OutSamps() As DCplx, _
    ByVal numIters As Long)
    Call nspdzbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Function nspzdIir(statePtr As NSPIirState, samp As DCplx) As DCplx
    nspzdIir = nspzdIirP(statePtr, samp.re, samp.im)
End Function
Sub nspzdbIir(statePtr As NSPIirState, inSamps() As DCplx, OutSamps() As DCplx, _
    ByVal numIters As Long)
    Call nspzdbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters)
End Sub
Sub nspwbIir(statePtr As NSPIirState, inSamps() As Integer, OutSamps() As Integer, _
    ByVal numIters As Long, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwbIirP(statePtr, inSamps(LBound(inSamps)), OutSamps(LBound(OutSamps)), _
    numIters, ScaleMode, ScaleFactor)
End Sub

'CHAPTER 9.
'Convolution Functions.

Sub nspsConv(X() As Single, ByVal xLenn As Long, h() As Single, ByVal hLenn As Long, _
    Y() As Single)
    Call nspsConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspcConv(X() As SCplx, ByVal xLenn As Long, h() As SCplx, ByVal hLenn As Long, _
    Y() As SCplx)
    Call nspcConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspscConv(X() As Single, ByVal xLenn As Long, h() As SCplx, ByVal hLenn As Long, _
    Y() As SCplx)
    Call nspscConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspcsConv(X() As SCplx, ByVal xLenn As Long, h() As Single, ByVal hLenn As Long, _
    Y() As SCplx)
    Call nspcsConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspdConv(X() As Double, ByVal xLenn As Long, h() As Double, ByVal hLenn As Long, _
    Y() As Double)
    Call nspdConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspzConv(X() As DCplx, ByVal xLenn As Long, h() As DCplx, ByVal hLenn As Long, _
    Y() As DCplx)
    Call nspzConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspdzConv(X() As Double, ByVal xLenn As Long, h() As DCplx, ByVal hLenn As Long, _
    Y() As DCplx)
    Call nspdzConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspzdConv(X() As DCplx, ByVal xLenn As Long, h() As Double, ByVal hLenn As Long, _
    Y() As DCplx)
    Call nspzdConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)))
End Sub
Sub nspwConv(X() As Integer, ByVal xLenn As Long, h() As Integer, ByVal hLenn As Long, _
    Y() As Integer, ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwConvP(X(LBound(X)), xLenn, h(LBound(h)), hLenn, Y(LBound(Y)), _
    ScaleMode, ScaleFactor)
End Sub
Sub nspsConv2D(X() As Single, ByVal xCols As Long, ByVal xRows As Long, h() As Single, _
    ByVal hCols As Long, ByVal hRows As Long, Y() As Single)
    Call nspsConv2DP(X(LBound(X)), xCols, xRows, h(LBound(h)), hCols, hRows, _
    Y(LBound(Y)))
End Sub
Sub nspdConv2D(X() As Double, ByVal xCols As Long, ByVal xRows As Long, _
    h() As Double, ByVal hCols As Long, ByVal hRows As Long, Y() As Double)
    Call nspdConv2DP(X(LBound(X)), xCols, xRows, h(LBound(h)), hCols, hRows, _
    Y(LBound(Y)))
End Sub
Sub nspwConv2D(X() As Integer, ByVal xCols As Long, ByVal xRows As Long, _
    h() As Integer, ByVal hCols As Long, ByVal hRows As Long, Y() As Integer, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwConv2DP(X(LBound(X)), xCols, xRows, h(LBound(h)), hCols, hRows, _
    Y(LBound(Y)), ScaleMode, ScaleFactor)
End Sub
Sub nspsFilter2D(X() As Single, ByVal xCols As Long, ByVal xRows As Long, _
    h() As Single, ByVal hCols As Long, ByVal hRows As Long, Y() As Single)
    Call nspsFilter2DP(X(LBound(X)), xCols, xRows, h(LBound(h)), hCols, hRows, _
    Y(LBound(Y)))
End Sub
Sub nspdFilter2D(X() As Double, ByVal xCols As Long, ByVal xRows As Long, _
    h() As Double, ByVal hCols As Long, ByVal hRows As Long, Y() As Double)
    Call nspdFilter2DP(X(LBound(X)), xCols, xRows, h(LBound(h)), hCols, hRows, _
    Y(LBound(Y)))
End Sub
Sub nspwFilter2D(X() As Integer, ByVal xCols As Long, ByVal xRows As Long, _
    h() As Integer, ByVal hCols As Long, ByVal hRows As Long, Y() As Integer, _
    ByVal ScaleMode As Long, ScaleFactor As Long)
    Call nspwFilter2DP(X(LBound(X)), xCols, xRows, h(LBound(h)), hCols, hRows, _
    Y(LBound(Y)), ScaleMode, ScaleFactor)
End Sub

'CHAPTER 10.
'Wavelet Functions.

Sub nspsWtSetState(wtstate As NSPWtState, ByVal wtType As Long, ByVal par1 As Long, _
    ByVal par2 As Long, ByVal dataOrder As Long, ByVal level As Long, _
    tapsDecLow() As Single, tapsDecHigh() As Single, tapsRecLow() As Single, _
    tapsRecHigh() As Single, Flen() As Long, Fofs() As Long)
    Dim TapsArr(0 To 3) As Long
    TapsArr(0) = VarPtr(tapsDecLow(LBound(tapsDecLow)))
    TapsArr(1) = VarPtr(tapsDecHigh(LBound(tapsDecHigh)))
    TapsArr(2) = VarPtr(tapsRecLow(LBound(tapsRecLow)))
    TapsArr(3) = VarPtr(tapsRecHigh(LBound(tapsRecHigh)))
    Call nspsWtSetStateP(wtstate, wtType, par1, par2, dataOrder, level, _
    TapsArr(0), Flen(LBound(Flen)), Fofs(LBound(Fofs)))
End Sub
Sub nspdWtSetState(wtstate As NSPWtState, ByVal wtType As Long, ByVal par1 As Long, _
    ByVal par2 As Long, ByVal dataOrder As Long, ByVal level As Long, _
    tapsDecLow() As Double, tapsDecHigh() As Double, tapsRecLow() As Double, _
    tapsRecHigh() As Double, Flen() As Long, Fofs() As Long)
    Dim TapsArr(0 To 3) As Long
    TapsArr(0) = VarPtr(tapsDecLow(LBound(tapsDecLow)))
    TapsArr(1) = VarPtr(tapsDecHigh(LBound(tapsDecHigh)))
    TapsArr(2) = VarPtr(tapsRecLow(LBound(tapsRecLow)))
    TapsArr(3) = VarPtr(tapsRecHigh(LBound(tapsRecHigh)))
    Call nspdWtSetStateP(wtstate, wtType, par1, par2, dataOrder, level, _
    TapsArr(0), Flen(LBound(Flen)), Fofs(LBound(Fofs)))
End Sub
Sub nspwWtSetState(wtstate As NSPWtState, ByVal wtType As Long, ByVal par1 As Long, _
    ByVal par2 As Long, ByVal dataOrder As Long, ByVal level As Long, _
    tapsDecLow() As Single, tapsDecHigh() As Single, tapsRecLow() As Single, _
    tapsRecHigh() As Single, Flen() As Long, Fofs() As Long)
    Dim TapsArr(0 To 3) As Long
    TapsArr(0) = VarPtr(tapsDecLow(LBound(tapsDecLow)))
    TapsArr(1) = VarPtr(tapsDecHigh(LBound(tapsDecHigh)))
    TapsArr(2) = VarPtr(tapsRecLow(LBound(tapsRecLow)))
    TapsArr(3) = VarPtr(tapsRecHigh(LBound(tapsRecHigh)))
    Call nspwWtSetStateP(wtstate, wtType, par1, par2, dataOrder, level, _
    TapsArr(0), Flen(LBound(Flen)), Fofs(LBound(Fofs)))
End Sub

Sub nspsWtGetState(wtstate As NSPWtState, wtType As Long, par1 As Long, _
    par2 As Long, dataOrder As Long, level As Long, tapsDecLow() As Single, _
    tapsDecHigh() As Single, tapsRecLow() As Single, tapsRecHigh() As Single, _
    Flen() As Long, Fofs() As Long)
    Dim TapsArr(0 To 3) As Long
    Call nspsWtGetStateP(wtstate, wtType, par1, par2, dataOrder, level, _
        TapsArr(0), Flen(LBound(Flen)), Fofs(LBound(Fofs)))
    Call nspsbCopyPtr(TapsArr(0), _
        VarPtr(tapsDecLow(LBound(tapsDecLow))), Flen(LBound(Flen)))
    Call nspsbCopyPtr(TapsArr(1), _
        VarPtr(tapsDecHigh(LBound(tapsDecHigh))), Flen(LBound(Flen) + 1))
    Call nspsbCopyPtr(TapsArr(2), _
        VarPtr(tapsRecLow(LBound(tapsRecLow))), Flen(LBound(Flen) + 2))
    Call nspsbCopyPtr(TapsArr(3), _
        VarPtr(tapsRecHigh(LBound(tapsRecHigh))), Flen(LBound(Flen) + 3))
End Sub
Sub nspdWtGetState(wtstate As NSPWtState, wtType As Long, par1 As Long, _
    par2 As Long, dataOrder As Long, level As Long, tapsDecLow() As Double, _
    tapsDecHigh() As Double, tapsRecLow() As Double, tapsRecHigh() As Double, _
    Flen() As Long, Fofs() As Long)
    Dim TapsArr(0 To 3) As Long
    Call nspdWtGetStateP(wtstate, wtType, par1, par2, dataOrder, level, _
        TapsArr(0), Flen(LBound(Flen)), Fofs(LBound(Fofs)))
    Call nspdbCopyPtr(TapsArr(0), _
        VarPtr(tapsDecLow(LBound(tapsDecLow))), Flen(LBound(Flen)))
    Call nspdbCopyPtr(TapsArr(1), _
        VarPtr(tapsDecHigh(LBound(tapsDecHigh))), Flen(LBound(Flen) + 1))
    Call nspdbCopyPtr(TapsArr(2), _
        VarPtr(tapsRecLow(LBound(tapsRecLow))), Flen(LBound(Flen) + 2))
    Call nspdbCopyPtr(TapsArr(3), _
        VarPtr(tapsRecHigh(LBound(tapsRecHigh))), Flen(LBound(Flen) + 3))
End Sub
Sub nspwWtGetState(wtstate As NSPWtState, wtType As Long, par1 As Long, _
    par2 As Long, dataOrder As Long, level As Long, tapsDecLow() As Single, _
    tapsDecHigh() As Single, tapsRecLow() As Single, tapsRecHigh() As Single, _
    Flen() As Long, Fofs() As Long)
    Dim TapsArr(0 To 3) As Long
    Call nspsWtGetStateP(wtstate, wtType, par1, par2, dataOrder, level, _
        TapsArr(0), Flen(LBound(Flen)), Fofs(LBound(Fofs)))
    Call nspsbCopyPtr(TapsArr(0), _
        VarPtr(tapsDecLow(LBound(tapsDecLow))), Flen(LBound(Flen)))
    Call nspsbCopyPtr(TapsArr(1), _
        VarPtr(tapsDecHigh(LBound(tapsDecHigh))), Flen(LBound(Flen) + 1))
    Call nspsbCopyPtr(TapsArr(2), _
        VarPtr(tapsRecLow(LBound(tapsRecLow))), Flen(LBound(Flen) + 2))
    Call nspsbCopyPtr(TapsArr(3), _
        VarPtr(tapsRecHigh(LBound(tapsRecHigh))), Flen(LBound(Flen) + 3))
End Sub
Sub nspsWtInitUserFilter(tapsDecLow() As Single, tapsDecHigh() As Single, _
    tapsRecLow() As Single, tapsRecHigh() As Single, Flen() As Long, _
    Fofs() As Long, ByVal Length As Long, ByVal level As Long, _
    wtstate As NSPWtState, len_dec As Long)
    Dim TapsArr(0 To 3) As Long
    TapsArr(0) = VarPtr(tapsDecLow(LBound(tapsDecLow)))
    TapsArr(1) = VarPtr(tapsDecHigh(LBound(tapsDecHigh)))
    TapsArr(2) = VarPtr(tapsRecLow(LBound(tapsRecLow)))
    TapsArr(3) = VarPtr(tapsRecHigh(LBound(tapsRecHigh)))
    Call nspsWtInitUserFilterP(TapsArr(0), Flen(LBound(Flen)), _
    Fofs(LBound(Fofs)), Length, level, wtstate, len_dec)
End Sub
Sub nspdWtInitUserFilter(tapsDecLow() As Double, tapsDecHigh() As Double, _
    tapsRecLow() As Double, tapsRecHigh() As Double, Flen() As Long, _
    Fofs() As Long, ByVal Length As Long, ByVal level As Long, _
    wtstate As NSPWtState, len_dec As Long)
    Dim TapsArr(0 To 3) As Long
    TapsArr(0) = VarPtr(tapsDecLow(LBound(tapsDecLow)))
    TapsArr(1) = VarPtr(tapsDecHigh(LBound(tapsDecHigh)))
    TapsArr(2) = VarPtr(tapsRecLow(LBound(tapsRecLow)))
    TapsArr(3) = VarPtr(tapsRecHigh(LBound(tapsRecHigh)))
    Call nspdWtInitUserFilterP(TapsArr(0), Flen(LBound(Flen)), _
    Fofs(LBound(Fofs)), Length, level, wtstate, len_dec)
End Sub
Sub nspwWtInitUserFilter(tapsDecLow() As Single, tapsDecHigh() As Single, _
    tapsRecLow() As Single, tapsRecHigh() As Single, Flen() As Long, _
    Fofs() As Long, ByVal Length As Long, ByVal level As Long, _
    wtstate As NSPWtState, len_dec As Long)
    Dim TapsArr(0 To 3) As Long
    TapsArr(0) = VarPtr(tapsDecLow(LBound(tapsDecLow)))
    TapsArr(1) = VarPtr(tapsDecHigh(LBound(tapsDecHigh)))
    TapsArr(2) = VarPtr(tapsRecLow(LBound(tapsRecLow)))
    TapsArr(3) = VarPtr(tapsRecHigh(LBound(tapsRecHigh)))
    Call nspwWtInitUserFilterP(TapsArr(0), Flen(LBound(Flen)), _
    Fofs(LBound(Fofs)), Length, level, wtstate, len_dec)
End Sub
Sub nspsWtDecompose(wtstate As NSPWtState, Src() As Single, Dst() As Single)
    Call nspsWtDecomposeP(wtstate, Src(LBound(Src)), Dst(LBound(Dst)))
End Sub
Sub nspdWtDecompose(wtstate As NSPWtState, Src() As Double, Dst() As Double)
    Call nspdWtDecomposeP(wtstate, Src(LBound(Src)), Dst(LBound(Dst)))
End Sub
Sub nspwWtDecompose(wtstate As NSPWtState, Src() As Integer, Dst() As Integer)
    Call nspwWtDecomposeP(wtstate, Src(LBound(Src)), Dst(LBound(Dst)))
End Sub
Sub nspsWtReconstruct(wtstate As NSPWtState, Src() As Single, Dst() As Single)
    Call nspsWtReconstructP(wtstate, Src(LBound(Src)), Dst(LBound(Dst)))
End Sub
Sub nspdWtReconstruct(wtstate As NSPWtState, Src() As Double, Dst() As Double)
    Call nspdWtReconstructP(wtstate, Src(LBound(Src)), Dst(LBound(Dst)))
End Sub
Sub nspwWtReconstruct(wtstate As NSPWtState, Src() As Integer, Dst() As Integer)
    Call nspwWtReconstructP(wtstate, Src(LBound(Src)), Dst(LBound(Dst)))
End Sub


'CHAPTER 11.
'Library Information

Function nspGetLibVersionVB() As NSPLibVersion
    
    nspGetLibVersionVB = nspGetLibVersionVBP()
    
    nspGetLibVersionVB.Namee = Left(nspGetLibVersionVB.Namee, _
        InStr(1, nspGetLibVersionVB.Namee, Chr(0), vbTextCompare) - 1)
    nspGetLibVersionVB.InternalVersionn = _
        Left(nspGetLibVersionVB.InternalVersionn, _
        InStr(1, nspGetLibVersionVB.InternalVersionn, Chr(0), vbTextCompare) - 1)
    nspGetLibVersionVB.Versionn = Left(nspGetLibVersionVB.Versionn, _
        InStr(1, nspGetLibVersionVB.Versionn, Chr(0), vbTextCompare) - 1)
    nspGetLibVersionVB.BuildDate = Left(nspGetLibVersionVB.BuildDate, _
        InStr(1, nspGetLibVersionVB.BuildDate, Chr(0), vbTextCompare) - 1)
    nspGetLibVersionVB.CallConv = Left(nspGetLibVersionVB.CallConv, _
        InStr(1, nspGetLibVersionVB.CallConv, Chr(0), vbTextCompare) - 1)

End Function

